C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE Autocorrelation
C
C**********************************************************************C
C
C AUTO READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C computes trace by trace autocorrelation and outputs the result
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, cross
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis
#include <f77/pid.h>
      REAL        wtrce(2*SZLNHD),xtrace(2*SZLNHD)
      CHARACTER   NAME * 4, ntap * 100, otap * 100
      logical     verbos,query
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'AUTO'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,lags,nst,ned,nrst,nred,verbos)

C**********************************************************************C
C     open I/O data sets & assign logical units
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

C**********************************************************************C
C     read input line header; save certain parameters; adjust output
C     line header; update historical line header
C**********************************************************************C
      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'AUTO: no header read on ',ntap,' unit= ',luin
         write(LERR,*)'Check existence of file & rerun'
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTES, NAME, 4,         LERR)
#include <f77/saveh.h>

c---
c  build pointers to selected trace headers
c---
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
c-------------------------------------------
c  check start/end rec/trc parameters
      call cmdchk ( nst, ned, nrst, nred, ntrc, nrec)

      jtrc=ned-nst+1
       call savew( itr, 'NumTrc', jtrc , LINHED)
      nrecc=nred-nrst+1
       call savew( itr, 'NumRec', nrecc, LINHED)
      if(lags .eq. 0) then
         lags=nsamp/2
      endif
      obytes = SZTRHD + SZSMPD * lags
       call savew( itr, 'NumSmp', lags  , LINHED)
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Number of lags to autocorrelate= ',lags
 
c----------------------------------------------------------
c  update historical line header & write out output header
      call savhlh( itr, lbytes, lbyout)
      call wrtape(luout,itr,lbyout)
 
C**********************************************************************C
C     skip to desired start record
C**********************************************************************C
      call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C
C     READ TRACE, DO AUTO (cross)
C
C**********************************************************************C
 
      DO 100 JJ = NRST, NRED

c-------------------------------
c  skip to desired trace
c-------------------------------
            call trcskp(jj,1,nst-1,luin,ntrc,itr)

           DO 99 KK = NST, NED
                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif

                 call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                       irec   , TRACEHEADER)

                 call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)

                 IF(istatic .ne. 30000) THEN
                    call vmov(lhed(ITHWP1),1,xtrace,1,nsamp)
c------------------------------
c   do cross correlation
c------------------------------
                    call conv(xtrace,1,xtrace,1,wtrce,1,lags,nsamp,1)
 
                    call vmov (wtrce,1,lhed(ITHWP1),1,lags)
                 ELSE
                    call vclr (lhed(ITHWP1), 1, lags)
                 ENDIF
                 call wrtape(luout,itr,obytes)
   99      CONTINUE
            if(verbos) then
              write(LERR,*)' Autocorrelated Record= ',irec
            endif

c------------------------------------
c  skip to end of current record
c------------------------------------
            call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END

c----------------------------------------------------------
c   online help section
c----------------------------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for AUTO: autocorrelation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-L[lags]   -- number of autocorrelation lags'
        write(LER,*)'-ns[nstr]  -- start trace number           (first)'
        write(LER,*)'-ne[netr]  -- end trace number              (last)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        auto -N[] -O[] -L[] -ns[] -ne[] -rs[]'
        write(LER,*)'              -re[] -V'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    lags   - I      autocorrelation lags
c     nst   - I      start trace
c     ned   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,lags,nst,ned,nrst,nred,verbos)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    nst,ned,nrst,nred,lags,argis
      logical    verbos

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-L',lags,0,0)
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          verbos = (argis('-V') .gt. 0)

      return
      end
