C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c--------------------------- subroutine anal2 --------------------------
c  this routine does a dft, integration of the spectrum
c  and a quadratic least squares fit to the integrated spectrum.

      subroutine anal2 ( u, ug, uavb, amp, cum, gtab, ctab, stab, ntr, 
     :     nsmp, nfr )

c declare variables passed from calling routine

      integer ntr, nsmp, nfr

      real u(nsmp,ntr), ug(nsmp), uavb(nsmp,ntr), amp(nfr), cum(nfr)
      real  gtab(nsmp), ctab(nsmp,nfr), stab(nsmp,nfr)

c declare local variables

      integer ifr, itr, ismp

      real res, c1, c2, c3, c4, c5, x, detc, umin, umax
      real ur, ui, y1, y2, y3, func, a0, a1, a2

c initialize variables

      c1 = real(nfr)
      c2 = 0.0
      c3 = 0.0
      c4 = 0.0
      c5 = 0.0

      do ifr = 1, nfr
         x = real(ifr-1)
         c2 = c2 + x
         c3 = c3 + x*x
         c4 = c4 + x*x*x
         c5 = c5 + x*x*x*x
      enddo

      detc = c1*(c3*c5-c4*c4)-c2*(c2*c5-c3*c4)+c3*(c2*c4-c3*c3)

c--------------------------- compute transform -------------------------
      
      DO itr = 1,ntr

         umin = u(1,itr)
         umax = u(1,itr)

         do ismp = 1,nsmp
            if(u(ismp,itr) .lt. umin)umin = u(ismp,itr)
            if(u(ismp,itr) .gt. umax)umax = u(ismp,itr)
         enddo

         IF ( umin .ne. umax ) then

            do ismp = 1,nsmp
               ug(ismp) = gtab(ismp) * u(ismp,itr)
            enddo

            do ifr = 1,nfr
               ur = 0.0
               ui = 0.0
               do ismp = 1, nsmp
                  ur = ur + ug(ismp)*ctab(ismp,ifr)
                  ui = ui + ug(ismp)*stab(ismp,ifr)
               enddo

               amp(ifr) = sqrt(ur**2 + ui**2)
            enddo

            do ifr = 1,nfr
               cum(ifr) = amp(ifr)
            enddo

            y1 = 0.0
            y2 = 0.0
            y3 = 0.0

            do ifr = 1,nfr
               x = real(ifr-1)
               y1 = y1 + cum(ifr)
               y2 = y2 + x*cum(ifr)
               y3 = y3 + x*x*cum(ifr)
            enddo

            a0 = (y1*(c3*c5-c4*c4)-c2*(y2*c5-y3*c4)+c3*(y2*c4-y3*c3))
     :           /detc
            a1 = (c1*(y2*c5-y3*c4)-y1*(c2*c5-c3*c4)+c3*(y3*c2-y2*c3))
     :           /detc
            a2 = (c1*(y3*c3-y2*c4)-c2*(y3*c2-y2*c3)+y1*(c2*c4-c3*c3))
     :           /detc

            res = 0.0

            do ifr = 1,nfr
               x = real(ifr-1)
               func = a0 + a1*x + a2*x*x
               res = res + (func - cum(ifr))**2
            enddo

            res = sqrt(res)/real(nfr)

            uavb(1,itr) = a0
            uavb(2,itr) = a1
            uavb(3,itr) = a2
            uavb(4,itr) = res

         ELSE
            uavb(1,itr) = 0.0
            uavb(2,itr) = 0.0
            uavb(3,itr) = 0.0
            uavb(4,itr) = 0.0
         ENDIF

      ENDDO

      return
      end
