C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ASKW(A,NPT)
C
C  JH BODINE 9/2/81
C
C  Routine to calculate the asymmetry of the envelope
C
C  Routine to set analytic signal envelope lobes to value of
C  the difference between the array positions of the envelope lobe
C  peak and the first moment of the lobe.
C  The value of the envelope is set to that of this difference * 100
C  from trough to trough. The resulting "ENVELOPE" may be
C  considered to be a measure of the degree of asymmetry of each
C  envelope lobe.
C
C  SEE TANER ET AL., 1979, GEOPHYSICS, V.44, #6,P.1041.
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  Program assumes the first point in the signal is a trough
C  and the first point of zero slope is a peak. If this point
C  is a trough it will be skipped (STATEMENT #50).
C
C  Note for user's;
C     This routine will find every envelope peak regardless
C     of relative amplitude. Display of relults for noisy
C     data is thus most effective with a color plot where color
C     intensity is amplitude modulated.
C
C
      DIMENSION A(1),ITRF(4096),IPEAK(4096)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C Find array positions of maxima and minima.
C
      NPT1 = NPT - 1
      DO 20  I = 2,NPT1
         SLAST = SLOP
         SLOP = A(I+1) - A(I)
         CHNG = SLAST * SLOP
         IF(CHNG.GE.0.) GO TO 20
         IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 10
         IPEAK(JP) = I
         JP = JP+1
         GO TO 20
C
   10    CONTINUE
         IF(JP.EQ.1) GO TO 20
         ITRF(JT) = I
         JT = JT+1
   20 CONTINUE
C
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C Set envelope lobes to difference in array position of envelope
C peak and first moment.
C
      J = 1
      ISTRT = 1
   30 IEND = ITRF(J)
      SUMM = 0.
      ASUM = 0.
C
C Get fractional array position of envelope peak.
C
      K = IPEAK(J)
      FP = FPEAK(A,K)
C
C Get position of first moment
C
      DO 40  II = ISTRT,IEND
         SUMM = SUMM + (FP-II)*A(II)
         ASUM = ASUM + A(II)
   40 CONTINUE
      IF(ASUM.EQ.0.) ASUM = 1.
      AMOM = SUMM/ASUM
      IF(ASUM.EQ.0.) AMOM = 0.
C
C Set envelope array to difference of peak and 1st mom positions.
C
      DO 50  I = ISTRT,IEND
         A(I) = AMOM *100.
   50 CONTINUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 60
      ISTRT = IEND
      GO TO 30
C
   60 CONTINUE
C
      RETURN
      END
