C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ASLP(A,NPT)
C
C  JH BODINE 9/2/81
C
C  Routine to set analytic signal envelope lobes to a value
C  proportional to the max slope of the envelope lobes.
C
C    SLOPE = MAX(A(I+1)-A(I))/MAX(A(I)) * 1000.
C
C  The value of the envelope is set from trough
C  to trough. The resulting "ENVELOPE" may be considered to
C  represent a modification of
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  Program assumes the first point in the signal is a trough
C  and the first maxima is a peak. If the first maxima is a trough,
C  it will be skipped (STATEMENT #50).
C
      DIMENSION A(1),ITRF(4096),SLOPMX(4096),ENVMAX(4096)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C Find array positions of maxima and minima
C
      NPT1 = NPT - 1
      SMAX = 0.
      AMAX = 0.
      DO 20  I = 2,NPT1
         SLAST = SLOP
         SLOP = A(I+1) - A(I)
         CHNG = SLAST * SLOP
         IF(ABS(SLOP).GT.ABS(SMAX)) SMAX = SLOP
         IF(ABS(A(I)).GT.ABS(AMAX)) AMAX = A(I)
         IF(CHNG.GE.0.) GO TO 20
         IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 10
         JP = JP+1
         GO TO 20
C
   10    CONTINUE
         IF(JP.EQ.1) GO TO 20
         ENVMAX(JT) = AMAX
         SLOPMX(JT) = SMAX
         SMAX = 0.
         ITRF(JT) = I
         JT = JT+1
   20 CONTINUE
C
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C Set envelope lobes to value of envelope lobe -1.0
C
      J = 1
      ISTRT = 1
   30 IEND = ITRF(J)
      DO 40  I = ISTRT,IEND
         IF (ENVMAX(J).EQ.0.) ENVMAX(J) = 1.
         A(I) = SLOPMX(J)/ENVMAX(J)*1000.
   40 CONTINUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 50
      ISTRT = IEND
      GO TO 30
C
   50 CONTINUE
      RETURN
      END
