C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE FFTMCK(DATA,AMP,PHASE,NSAMP,ID)
      REAL DATA( * ),AMP( * ),PHASE( * ),TDATA(4096),PI
      INTEGER NSAMP,ID,N
C
C Set constants
C
      PI = 3.14159
      N = NSAMP / 2
C
C Copy DATA array into temporary work array TDATA
C
      IF(ID.EQ.1) THEN
          DO 10 I=1,NSAMP
              TDATA(I) = DATA(I)
   10     CONTINUE
C
C     Transform TDATA to frequency domain
C
          CALL REALFT(TDATA,N,+1)
C
C     Calculate AMP and PHASE from TDATA
C
C         PHASE(0) = 0.0
          DO 20 I=1,N
              AMP(I)   = SQRT(TDATA(2*I-1)**2 + TDATA(2*I)**2)
              AMP(I)   = AMP(I) / FLOAT(N)
C             IF(TDATA(2*I).NE.0.0) THEN
                  PHASE(I) = (360.0/(2.0*PI))*ATAN2(TDATA(2*I-1),
     :                       TDATA(2*I))
C             ELSE
C                 IF(I.EQ.1) THEN
C                     PHASE(I) = 90.0
C                     GOTO 321
C                 ENDIF
C                 IF(PHASE(I-1).GT.0.0.AND.PHASE(I-1).LT.180.0) THEN
C                     PHASE(I) = 90.0
C                 ELSE
C                     PHASE(I) = 270.0
C                 ENDIF
C 321             CONTINUE
C             ENDIF
   20     CONTINUE
      ELSE
C
C Transform AMP and PHASE into time domain array TDATA
C     Copy AMP and PHASE into temporary work array TDATA
C
          DO 30 I=1,N
              TDATA(I*2-1) = AMP(I)*SIN(PHASE(I)*2.0*PI/360.0)
              TDATA(I*2  ) = AMP(I)*COS(PHASE(I)*2.0*PI/360.0)
   30     CONTINUE
C
C     Transform TDATA to time domain
C
          CALL REALFT(TDATA,N,-1)
C
C Copy TDATA work array into output array DATA
C
          DO 40 I=1,NSAMP
              DATA(I) = TDATA(I)
   40     CONTINUE
      ENDIF
      RETURN
      END
