C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE HILBRT(NZ,NF,WC,F,DX,NX,X,Z)
C
C Program to perform a Hilbert transform on a vector X of length NX.
C
C Z serves first as a dummy convolution array and must be
C dimensioned NZ=NX+NF-1
C
C Transform is returned as Z of length NX
C
C NOTE: HILF OPERATOR RESULTS IN COS --> -SIN.....
C BY JH BODINE   7/27/81
C
C
C F = Dummy array for the Hilbert operator
C NF = No. points in Hilbert transfer function (ODD)
C DX = Sample interval
C NX,X = No. points in vector X which is to be transformed
C
      DIMENSION X(1),F(4096),Z(1)
C     DIMENSION X(1),F(NF),Z(NZ)
C
      CALL HILF(DX,WC,NF,F)
C
      CALL FOLD(NF,F,NX,X,NZ,Z)
C
      DO 10 I=1,NX
C     WRITE(*,*) Z(I),I
   10 Z(I)= Z((NF-1)/2+I)*DX
C
      RETURN
      END
