C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ofd1d(filtfa,filtfp,points,deltat,f,angle,
     :                 weight,type,q)
      real filtfa(*),filtfp(*),deltat,f(*),angle,q
      real filtt(4096),smoot(4096),fn,deltaf
      integer points,weight,type
      integer nsamp,i,j,start,stop
C 
C This routine designs an Ormsby filter in the frequency domain
C returning two arrays, filtfa and filtfp containing the amplitude
C and phase values for the filter.  The length of the operator
C is nsamp which is the next higher integer power of 2.  The flag
C weight when zero means no weighting.  When it is not zero, type
C is tested where zero is Ross weighting at value "q" and not zero
C is Bartlett weighting.  Bartlett weighting requires no parameters.
C
C Filter is an 18 April 1994 revision of the 8 May 1990 Lindsay and
C Kelly FILT1D filter algorithm.
C
C Find Nyquist frequency, FN
C
      fn = 1.0 / (2.0 * deltat)
C
C Find size of the input array and set nsamp to the next higher 
C integer power of 2.
C
      j=1
   10 continue
      if(2**j.ge.points) goto 20
      if(2**j.eq.4096) goto 20
      j=j+1
      goto 10
   20 continue
      nsamp = 2**j
C
C Find deltaf
C
      deltaf = fn / float(nsamp/2)
C
C Design the operator in the frequency domain
C
      do 30 i=1,nsamp/2
          filtfa(i) = 0.0
          filtfp(i) = 0.0
   30 continue
C
C Build low cut ramp, if needed
C
      if(f(2).eq.0.0) goto 50
C
      if(f(1).eq.0.0) then
          start = 1
      else
          start = nint(f(1) / deltaf)
      endif
C
      if(f(2).gt.f(1)) then
          stop = nint(f(2)/deltaf)
      else
          goto 50
      endif
C
      do 40 i=start,stop
          filtfa(i) = float(i-start) / float(stop-start)
   40 continue
C
   50 continue
C
C Build pass band
C
      if(f(2).eq.0.0) then
          start = 1
      else
          start = nint(f(2)/deltaf)
      endif
C
      if(f(3).eq.0.0) then
          stop = 1
      else
          stop = nint(f(3)/deltaf)
      endif
C
      do 60 i=start,stop
          filtfa(i) = 1.0
   60 continue
C
C Build high ramp, if needed
C
      if(f(3).eq.0.0) then
          start = 1
      else
          start = nint(f(3)/deltaf)
      endif
C
      if(f(4).gt.f(3)) then
          stop = nint(f(4)/deltaf)
      else
          stop = start + 1
      endif
C
      do 70 i=start,stop
          filtfa(i) = float(stop-i)/float(stop-start)
   70 continue
C
C Build and apply smoothing, if requested
C
      if(weight.gt.0) then
          if(type.eq.0) then
C
C     Build Ross operator
C
              do 80 i=1,nsamp/2
                  smoot(i) = (1.0-(float(i-1) /
     :                       float(nsamp/2-1))**2.)**q
                  smoot(nsamp-i+1) = smoot(I)
   80         continue
          else
C
C     Build Bartlett operator
C
              do 90 i=1,nsamp/2
                  smoot(i) = 1.0 - float(i-1) /
     :                       float(nsamp/2-1)
                  smoot(nsamp-i+1) = smoot(i)
   90         continue
          endif
C
C     Transform filter operator to time
C
          call fftmck(filtt,filtfa,filtfp,nsamp,-1)
C
C     Apply smoothing
C
          do 100 i=1,nsamp
              filtt(i) = filtt(i) * smoot(i)
  100     continue
C
C     Transform smoothed operator back to frequency
C
          call fftmck(filtt,filtfa,filtfp,nsamp,+1)
      endif
C
C Apply phase shift, if requested
C
      do 110 i=1,nsamp/2
          filtfp(i) = angle
  110 continue
C
C Return to calling object
C
      return
      end
