C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      FUNCTION PHAS(FR,FI)
C
C  JH BODINE    7/28/81
C
C  PROGRAM CALCULATES PHASE IN RADIANS ZERO TO 2*PI
C  FROM ENTERED REAL AND IMAGINARY COMPONENTS.
C
      PHAS = 0.
      PI=3.14159265
      A = (FR**2 + FI**2)**.5
      IF(A.EQ.0.) GO TO 10
      ARG = ABS(FI)/A
      IF(ARG.GT.1.) ARG=1.
C
C  0 TO PI/2
      IF(FI.GT.0. .AND. FR.GE.0.) PHAS=ASIN(ARG)
C
C  PI/2 TO PI
      IF(FI.GE.0. .AND. FR.LT.0.) PHAS=PI - ASIN(ARG)
C
C  PI TO 3*PI/2
      IF(FI.LT.0. .AND. FR.LE.0.) PHAS=PI + ASIN(ARG)
C
C  3*PI/2 TO 2*PI
      IF(FI.LT.0. .AND. FR.GT.0.) PHAS=2*PI - ASIN(ARG)
C
   10 RETURN
      END
