C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       QCON                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      QCON  (R,Q,A,N)                                                 *
C  ARGUMENTS:                                                          *
C      R       REAL     ??IOU*  (1) -                                  *
C      Q       REAL     ??IOU*  (1) -                                  *
C      A       REAL     ??IOU*  (1) -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/10/15  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIN     GENERIC -                                               *
C      COS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
       SUBROUTINE QCON(R,Q,A,N)
C
C  JH BODINE  10/19/82
C
C  Routine to obtain complimentary functions from real
C  seismic trace using the response phase (described in program
C  CSIG). One function is associated with zero phase and the other
C  with PI/2 phase.
C
C      R = Real seismic trace input
C          returned as zero phase component
C      Q = Quadrature for analytic signal as input
C          returned as PI/2 phase component
C      A = Response phase array
C
C      N = Integer length of all arrays
C
C Derivation of math by Ken Hanson.
C
C
       DIMENSION R(1),Q(1),A(1)
C
       PI = 3.14159265
       DEGRAD = PI/180.
C
       DO 10 I=1,N
          ANG = A(I) * DEGRAD
          RP = (COS(ANG)**2*R(I)+COS(ANG)*SIN(ANG)*Q(I))
          Q(I) = R(I) - RP
          R(I) = RP
   10  CONTINUE
       RETURN
       END
