C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SQRTRC(SPIKES, POSNEG, SQLOBE, NSAMPS)
      REAL    SPIKES(*), SQLOBE(*), LOBMAX
      INTEGER POSNEG(*), NSAMPS, OSIGN, NSIGN, IFIRST, ILAST
C
C Catch the first sample and set the appropriate parameters
C acccordingly.
C
      LOBMAX = SPIKES(1)
      IF (POSNEG(1) .LT. 0) THEN
         OSIGN = -1
      ELSE
         OSIGN =  1
      ENDIF
      IFIRST = 1
      ILAST  = 1
C
C Now deal with the rest of the samples.
C
      DO 20 I = 2, NSAMPS
         IF (POSNEG(I) .LT. 0) THEN
              NSIGN = -1
         ELSE
              NSIGN =  1
         ENDIF
C
         IF (NSIGN .EQ. OSIGN) THEN
              IF (ABS(SPIKES(I)) .GT. ABS(LOBMAX)) THEN
                   LOBMAX = SPIKES(I)
                   OSIGN = NSIGN
                   GO TO 20
              ENDIF
         ELSE
              ILAST = I - 1
              DO 10 J = IFIRST, ILAST
                   SQLOBE(J) = LOBMAX
   10         CONTINUE
              OSIGN = NSIGN
              LOBMAX = SPIKES(I)
              IFIRST = I
              ILAST  = I
         ENDIF
   20 CONTINUE
C
C Now take care of the last lobe in the trace.
C
      ILAST = NSAMPS
      DO 30 I = IFIRST, ILAST
         SQLOBE(I) = LOBMAX
   30 CONTINUE
      RETURN
      END
