C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      FUNCTION XFREQ(R,Q,DX,NPT,M)
C
C  JH BODINE  7/28/81
C
C  CALCULATES INSTANTANEOUS FREQUENCY FOR ANALYTIC
C  TRACE ANALYSIS USING FINITE DIFFERENCE APPROXIMATIONS
C  (SEE TANER ET AL., 1979, GEOPHYSICS, V44 NO.6, P1041.).
C
C      R, Q = REAL AND QUADRATURE TRACES
C       NPT = NUMBER OF POINTS IN THE TRACE ARRAYS
C        DX = SAMPLE INTERVAL
C         M = CURRENT CENTRAL DIFFERENCE POSITION
C
      DIMENSION R(2),Q(2)
      PI = 3.14159265
C
      XFREQ = 0.
      IF(R(M).EQ.0. .AND. Q(M).EQ.0.) GO TO 10
C
      RLST = R(2)
      QLST = Q(2)
      RMST = R(NPT-1)
      QMST = Q(NPT-1)
C
      IF(M.LT.NPT) RMST = R(M+1)
      IF(M.LT.NPT) QMST = Q(M+1)
      IF(M.GT.1) RLST = R(M-1)
      IF(M.GT.1) QLST = Q(M-1)
C
      XFREQ = (R(M)*(QMST-QLST)/(2.*DX)
     : - Q(M)*(RMST-RLST)/(2.*DX))
     : /(R(M)**2 + Q(M)**2)
C
   10 RETURN
      END
