C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine DistOff ( rec, index, nseg, dist, ntr, offsets, times, 
     :     count, start, nsamp, dt_units, NoExtrap, NoInterp )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer rec, index(2*SZSMPM,2), nseg, ntr, count, pointer
      integer trndx, trndx2, nsamp

      real dist, offsets(*), times(*), start, start1, start2, dt_units

      logical NoExtrap, NoInterp

c initialize variables

      start = 0.
      start1 = 0.
      start2 = 0.
      trndx = 0
      trndx2 = 0
      
      IF ( rec .le. index(1,2) ) then

c before first record 

         if ( (rec .lt. index(1,2)) .and. ( NoExtrap .or. NoInterp ) ) 
     :        then
            start = float( nsamp ) * dt_units
            return
         endif
 
         if ( dist .lt. offsets(1) .or. 
     :        dist .gt. offsets( index(1,1) ) )then
            start = float( nsamp ) * dt_units
            return
         else
            call GetStart ( dist, offsets, times, 1, index(1,1), start )
            return
         endif

      ENDIF

      IF ( rec .ge. index(nseg,2) ) then 

c after last record

         if ( ( rec .gt. index(nseg,2) ) .and. 
     :        ( NoExtrap.or. NoInterp ) ) then
            start = float( nsamp ) * dt_units
            return
         endif            

         trndx2 = 0

         do i = 1,nseg-1
            trndx2 = trndx2 + index(i,1)
         enddo

         pointer = trndx2 + index(nseg,1) 
         trndx2 = trndx2 + 1

         if ( dist .lt. offsets(trndx2) .or. 
     :        dist .gt. offsets(pointer) )then
            start = float( nsamp ) * dt_units
            return
         else
            call GetStart ( dist, offsets, times, trndx2, pointer, 
     :           start )
            return
         endif

      ENDIF

c record is within bounds of pick segments
c locate position within pick control and interpolate mute start time

      do i = 1, nseg - 1

c determine records that bracket input record that trace is from


         if ( i .eq. nseg-1 .and. rec .eq. index(nseg,2) ) then
            trndx = trndx + 1
            trndx2 = trndx + index(i,1)
            pointer = trndx2 + index(i+1,1) - 1

c doing record at last segment

            if ( dist .lt. offsets(trndx2) .or. 
     :           dist .gt. offsets(pointer) )then

c if dist is outside pick segment then set start to max time

               start = float( nsamp ) * dt_units
            else  
               call GetStart ( dist, offsets, times, trndx2, pointer, 
     :              start )
            endif
            return

         elseif ( i .eq. nseg-1 .and. rec .eq. index(1,2) ) then
            trndx2 = 1
            pointer = trndx2 + index(1,1) - 1

c doing record at first segment (data indexed in reverse) 

            if ( dist .lt. offsets(trndx2) .or. 
     :           dist .gt. offsets(pointer) )then

c if dist is outside pick segment then set start to max time

               start = float( nsamp ) * dt_units
            else  
               call GetStart ( dist, offsets, times, trndx2, pointer, 
     :              start )
            endif
            return

         elseif ( rec .lt. index(i+1,2) ) then
            trndx = trndx + 1
            trndx2 = trndx + index(i,1) - 1
            pointer = trndx2 + index(i+1,1)
            goto 40


         else
            trndx = trndx + index(i,1)
         endif

      enddo

 40   if ( dist .lt. offsets(trndx) .or. dist .gt. offsets(trndx2) )then

c if dist is outside first pick segment then set start to max time

         start = float( nsamp ) * dt_units
         return
      endif

c if no interpolation flag is set then check if this record is in pickfile
c else no mute

      if ( NoInterp .and. rec .ne. index(i,2) ) then
         start = float( nsamp ) * dt_units
         return
      endif

c retrieve start time from first segment 

      call GetStart ( dist, offsets, times, trndx, trndx2, start1 )

      trndx2 = trndx2 + 1

      if ( dist .lt. offsets(trndx2) .or. dist .gt. offsets(pointer) )
     :     then

         start = float(nsamp) * dt_units     
         return
      else
c retrieve start time from second segment 

         call GetStart ( dist, offsets, times, trndx2, pointer, start2 )

      endif

c interpolate start time for this record

      call CalcStart ( start1, start2, index, i, rec, start )

      return
      end
