C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine off ( rec, index, nseg, tr, ntr, traces, times, count, 
     :     start, dt_units, nsamp, NoExtrap, NoInterp )

#include <f77/lhdrsz.h>

      integer rec, index(2*SZSMPM,2), tr, ntr, count, i, j, rndx, nelem
      integer trndx2, nsamp, trndx

      real times(*), traces(*), start, start1, start2, dt_units

      logical NoExtrap, NoInterp

#include <f77/iounit.h>

c initialize variables

      start = 0.
      start1 = 0.
      start2 = 0.
      rndx = 0
      trndx = 0
      trndx2 = 0

c determine if record is defined in pick file
c if before --> use first segment
c if after --> use last segment
c if within --> interpolate

      IF ( rec .le. index(1,2) ) then 

c BEFORE FIRST SEGMENT

c no muting if either no extrapolation or no interpolation option is on

         if ( (rec .lt. index(1,2)) .and.  ( NoExtrap .or. NoInterp ) ) 
     :        then
            start = float(nsamp) * dt_units  
            return
         endif

c if trace is outside range of picks within the
c segment then do not mute (ie set mute start time to end of trace)

         rndx = 1
         nelem = index(1,1)

         if(tr.lt.traces(1).or.tr.gt.traces(nelem)) then
            start = float(nsamp)*dt_units       
            return
         endif

c trace is within pic file, bracket trace and interpolate mute start time

         do i = 2, nelem
            if(tr.le.traces(i)) then
               start = times(i-1) + ((times(i) - times(i-1))/(traces(i) 
     :                 - traces(i-1))*(tr - traces(i-1)))
               return
            endif
         enddo

      ELSEIF ( rec .ge. index(nseg,2) ) then

c AFTER LAST SEGMENT

c no muting if no extrapolation or no interpolation option is on

         if ( rec .gt. index(nseg,2) .and. ( NoExtrap .or. NoInterp ) ) 
     :        then
            start = float(nsamp) * dt_units  
            return
         endif

         rndx = nseg
         nelem = index(nseg,1)
         trndx = count - nelem + 1

c determine if trace is before 1st trace in segment
c or after last trace in segment DO NOT MUTE

         if ( tr .lt. traces(trndx) .or. tr .gt. traces(count) ) then
            start = float(nsamp)*dt_units       
            return
         endif

c trace is within segment, bracket trace and interpolate mute start time

         do i = trndx+1,count
            if ( tr .le. traces(i) ) then
               start = times(i-1) + ( ( times(i) - times(i-1) ) / 
     :              ( traces(i) - traces(i-1) ) * ( tr - traces(i-1) ) ) 
               return
            endif
         enddo

      ENDIF

      IF ( start .le. 1.e-5 ) then

c record exists in pick file, locate segments that bracket
c and determine trace index in traces and times array for first
c element of first segment

         do i = 1, nseg - 1
            if ( rec .lt. index(i+1,2) ) then
               trndx = trndx + 1
               trndx2 = trndx + index(i,1)
               goto 10
            else
               trndx = trndx + index(i,1)
            endif
         enddo

 10      continue

c if no interpolation option is on then no muting unless this record
c is in pickfile

         if ( NoInterp ) then
            if ( rec .ne. index(i,2) ) then
               start = float(nsamp) * dt_units
               return
            endif
         endif

c get time value for desired trace from each segment
c then interpolate between

c first segment first

c determine if trace is before 1st trace in pic file 
c or after last trace in first segment 

         if ( tr .lt. traces(trndx) .or. tr .gt. traces(trndx2 - 1) ) 
     :        then
            start = float(nsamp) * dt_units       
            return
         endif

c if start1 is still zero then tr must be in segment
c bracket it and interpolate start1 time	

         if ( start1 .le. 1.e-5 ) then
            do j = trndx+1,trndx2-1
               if ( tr .le. traces(j) ) then
                  start1 = times(j-1) + ( ( times(j) - times(j-1) ) / 
     :                 (traces(j) - traces(j-1) ) * ( tr - traces(j-1))) 
                  goto 20
               endif
            enddo
         endif

c second segment 

c determine if trace is before 1st trace in pic file
c or after last trace in second segment 

 20      if ( tr .lt. traces(trndx2) .or. 
     :        tr .gt. traces(trndx2 + index(i+1,1) - 1 ) ) then
            start = float(nsamp) * dt_units       
            return
         endif

c if start2 is still zero then tr must be in segment
c bracket it and interpolate start2 time	

         if ( start2 .le. 1.e-5 ) then
            do j = trndx2+1, trndx2 + index(i+1,1) - 1
               if ( tr .le. traces(j) ) then
                  start2 = times(j-1) + ( (times(j) - times(j-1) ) /
     :                 ( traces(j) - traces(j-1) ) * 
     :                 ( tr - traces(j-1) ) ) 
                  goto 30
               endif
            enddo
         endif

c interpolate start time for current record and trace

 30      start = start1 + ( ( start2 - start1 ) / 
     :        ( index(i+1,2) - index(1,2) ) * ( rec - index(i,2) ) )

      ENDIF

      return
      end
