C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPick ( lu, index, records, traces, times, count, 
     :     nseg, mul, spinit, spincr, mtype, mnemonic, nsi, verbos ) 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c ----------------------------------------------------------------------
c	routine to read in mute control pick file from device lu 
c	correct for duplicate trace numbers 
c       correct for duplicate times
c	correct for first or last picks outside record boundaries
c       correct file for reverse pick order within record
c       correct record index as per command line input if required
c ----------------------------------------------------------------------

      integer lu,index(2*SZSMPM,2),npicks,i,count,mul,nseg
      integer spinit, spincr, pointer, nsi

      real   recnum,records(*),traces(*),times(*),oldrec,value
      character ajunk*1,key*10,name*20,mtype*(*),mnemonic*(*)

      logical verbos

c Variables passed from Main

c Integer
c
c     lu : logical unit connected to pick file
c     index : array to contain pick index information
c     nseg : number of segments in pick file
c     count : total number of picks in file (check this)
c     mul : time indices multiplier (to adjust for delta t on command line)
c     spinit : initial shot point from command line 
c     spincr : shot pint increment from command line
c
c Real
c
c     traces : array for segment trace values
c     times : array for segment time values
c
c Logical
c
c     verbos : verbose output flag

c Local Variables
c
c Integer
c
c     i : loop counter
c     npicks : number of picks in a given segment
c     pointer : pointer to traces and times arrays
c
c Real
c
c     recnum : record number of given segment
c     oldrec : record number of previously read segment element
c
c  Character
c
c     ajunk : used to find segment boundaries

c determine type of pickfile in use
       
      IF ( mtype .ne. 'diston' .and. mtype .ne. 'distoff' ) then

c using standard rec,trace,sample format pick file traces/record from pick file header 

         read(lu,'(51x,i5)') ntr

c initialize element and segmentcounters

         npicks = 0
         nseg = 1

c read segment header, need two reads to get past 1st header while still counting picks

         read(lu,'(a1)',end=20) ajunk

c for subsequent segments start at statement 1 

 1       read(lu,'(a1)',end=20) ajunk

c scan for next segment header while advancing counter
c record number of picks in segment in index(I,1)
c tag number of segments in variable nseg

         if(ajunk .ne. 'S') then
            npicks = npicks + 1
            goto 1
         else
            index(nseg,1) = npicks
            if (verbos) then
               write(LERR,*) ' segment number : ', nseg 
               write(LERR,*) ' number of picks : ', npicks 
            endif

c advance segment register and reset element counter

            nseg = nseg + 1
            npicks = 0

c start next segment

            goto 1
         endif

c have reached end of pick file assign number of picks for last segment

 20      index(nseg,1) = npicks
      
         if (verbos) then
            write(LERR,*) ' segment number : ', nseg 
            write(LERR,*) ' number of picks : ', npicks 
         endif

c now know total number of segments and number of picks in each
	
         rewind lu

c read and quality control each segment

         read(lu,'(a1)') ajunk

c reset array total element counter

         count = 1

c SEGMENT LOOP

         DO i = 1, nseg

c read past segment header

            read(lu,'(a1)') ajunk

c ELEMENT LOOP

            DO j = 1,index(i,1)


c if near trace stack pick file want to read recnum into traces
c else read traces into traces. Here not expecting to see more than
c one segment.  If more than one is present better kill it now.

               if(mtype.eq.'nearon'.or.mtype.eq.'nearoff'.or.
     :              ntr.eq.1)then
                  if(nseg.gt.1)then
                     write(LERR,*)' When using -Mnearon or -Mnearoff'
                     write(LERR,*)' or -Mon and muting post stack'
                     write(LERR,*)' pick file must have only 1 segment'
                     stop
                  endif
                  read(lu,50) traces(count), recnum, times(count)

c handle renumbering of records if requested remember in this mode traces = recs 

                  if(spinit.ne.-9999)then
                    traces(count)=float(spinit)+float(j-1)*float(spincr)
                  endif
               else
                  read(lu,50)recnum, traces(count), times(count)
 50               format(f12.6,2f13.6)
               endif

c adjust times if requested

               if(mul.gt.-9999)times(count) = times(count) * float(mul)

c QC TESTS
               IF(mtype.ne.'polyon'.and.mtype.ne.'polyoff'.and.mtype.ne.
     :              'nearon'.and.mtype.ne.'nearoff'.and.ntr.gt.1)then

c FIRST digitized point out of record
                
                  if(j.eq.2.and.oldrec.ne.recnum)then

c renumber trace entry on first pick element accordingly

                     if(traces(count-1).gt.traces(count))then
                        traces(count-1) = 1
                     elseif(traces(count-1).lt.traces(count))then
                        traces(count-1) = ntr
                     else
                        write(LERR,*)' something weird in pick file '
                        stop
                     endif
                  endif

c LAST digitized point out of record

                  if(j.eq.index(i,1).and.oldrec.ne.recnum)then
                     if(traces(count-1).gt.traces(count))then
                        traces(count) = ntr
                     elseif(traces(count-1).lt.traces(count))then
                        traces(count) = 1
                     else
                        write(LERR,*)' something weird in pick file '
                        stop
                     endif

c set recnum to oldrec

                     recnum = oldrec
                  endif

c increment indices

               ENDIF

               oldrec = recnum
               count = count + 1

c ELEMENT LOOP END

            ENDDO

c determine trace order and sort if necessary

            if(mtype.ne.'polyon'.and.mtype.ne.'polyoff')then
               pointer = count-index(i,1)
               if(traces(pointer).gt.traces(pointer+1))then
                  call sort(index(i,1),traces(pointer),times(pointer))
               endif

c handle duplicate picks in pick file

               do j = pointer+1,pointer+index(i,1)-1
                  if(traces(j).eq.traces(j-1).and.j.gt.pointer)then
                     traces(j) = traces(j-1) + 1.
                  endif
               enddo
            endif

c use initial record number if requested

            if(i.lt.2)then
               if(spinit.ne.-9999)recnum = float(spinit)
            endif

c use increment from command line if requested

            if(spincr.ne.-9999.and.i.gt.1)recnum=float(index(i-1,2)+
     :           spincr)

c load record number into index array

            index(i,2) = ifix(recnum)

c SEGMENT LOOP END

         ENDDO

c decrement count as it was started at 1

         count = count-1

c echo picks read to printout file

         pointer = 0
         do i = 1,nseg
            write(LERR,*)' Segment ',i,' for record',index(i,2)
            write(LERR,*)' Trace            Time'
            do j = 1,index(i,1)
               pointer = pointer + 1
               write(LERR,*)traces(pointer),times(pointer)
            enddo
         enddo
         return

      ELSE

c using new header key,value pickfile format 

c  need to define count,nseg,traces,times,index
c index[a,b] where a is recnum b is npicks

         count = 0
         nseg = 0

         DO while(1.eq.1)
            
            read(lu,'(a10,1x,f17.6)',end=200)key,value

C Get sample units 
           if (key.EQ.'UnitSmp') then
              if(mul.eq.-9999)mul = nint(value)
              if( mul .ne. nsi ) then
                 write(LER,*)' '
                 write(LER,*)' BDMUTE: The delta T of your dataset is'
                 write(LER,*)'         NOT equal to the units entry in '
                 write(LER,*)'         your XSD header file.  Your mute'
                 write(LER,*)'         start times will not be correct.'
                 write(LER,*)' WARNING '
                 write(LER,*)' '
              endif
           endif
        
C Increment counter for segment and reset pick counter.
C Get segment name.
           if (key.EQ.'Segment') then
              nseg=nseg+1
              read(lu,'(a10,1x,a20)',end=200)key,name
           endif

C Increment counter for pick.
           if (key.EQ.'Pick') then
              count=count+1
           endif

C Store the number of picks for that segment.
           if (key.EQ.'Picks') then
              index(nseg,1)=nint(value)
              if (verbos) then
                 write(LERR,*) ' segment number : ',nseg 
                 write(LERR,*) ' number of picks : ',index(nseg,1)
              endif
           endif
           
C Store the trace header record number for pick.
           if ( key .EQ. mnemonic ) then
              records(count) = value
           endif
           
C Store the signed trace distance for trace.
           if (key.EQ.'DstSgn') then
              traces(count)=value
              if (abs(value) .lt. 1.e-30 )then 
                 write(LERR,*)'BDMUTE: zero trace distance found in pick
     :file '
                 write(LERR,*)'WARNING'  
              endif   
           endif
           
C Store the sample value for pick.
           if (key.EQ.'Sample') then
              times(count)=value
           endif

        ENDDO           

 200    continue

c go through digitization and qc for faults unacceptable to bdmute algorithm

c initialize array pointer

        pointer = 0

c SEGMENT LOOP

        DO i = 1,nseg

c PICKS LOOP

           do j = 1,index(i,1)

c advance array pointer

              pointer = pointer + 1

c adjust pick times if requested

              if(mul.gt.-9999)times(pointer)=times(pointer)*float(mul)

c POLICEMEN

c FIRST digitized point outside record boundaries
                
              if(j.eq.2.and.records(pointer-1).ne.records(pointer))then

c flag illegal pick offset as 999999

                 traces(pointer-1)=999999.
                 write(LERR,*)'BDMUTE: Picks digitized outside record'
                 write(LERR,*)'        boundaries at record ',
     :                records(pointer)
                 write(LERR,*)'        These picks will be ignored with'
                 write(LERR,*)'        yielding unpredictable results.'      
                 write(LERR,*)'        Fix Picks and re-run if desired'
                 write(LERR,*)'WARNING'      
              endif

c LAST digitized point out of record

              if(j.eq.index(i,1).and.records(pointer-1).ne.
     :             records(pointer))then

c flag illegal pick offset as 999999

                 traces(pointer-1)=999999.

                 write(LERR,*)'BDMUTE: Picks digitized outside record'
                 write(LERR,*)'        boundaries at record ',
     :                records(pointer)
                 write(LERR,*)'        These picks will be ignored with'
                 write(LERR,*)'        yielding unpredictable results.'      
                 write(LERR,*)'        Fix Picks and re-run if desired'
                 write(LERR,*)'WARNING'      
              endif

c assign valid record number to index[i,2]

              if(abs(traces(pointer)).lt.999999.)index(i,2)=
     :             nint(records(pointer))
                       
c END PICKS LOOP

           enddo

c move pointer back to start of segment 

           pointer = pointer - index(i,1) + 1

c sort offsets into increasing order 

           call sort(index(i,1),traces(pointer),times(pointer))

c handle duplicate picks - since we are working with offsets 
c adding one foot or meter to the last value shouldn't cause
c any trouble with the resultant curve

           do j=pointer+1,pointer+index(i,1)-1
              if(traces(j).eq.traces(j-1).and.j.gt.pointer)then
                 traces(j)=traces(j-1)+1.
              endif
           enddo

c use initial record number override if requested

           if(i.lt.2)then
              if(spinit.ne.-9999)index(i,2)=spinit
           endif

c use record increment from command line if requested 

           if(spincr.ne.-9999.and.i.gt.1)index(i,2)=index(i-1,2)+spincr

c move pointer back to current position in arrays

           pointer = pointer + index(i,1) -1

c END SEGMENT LOOP

        ENDDO           
        
c now should have all pick segments in increasing offset order with flagged
c offsets at the max side (right side) and correct record numbers in index(i,2)slot
c also all times should be correct for any command line override dt.

c echo picks read to printout file

        pointer = 0
        do i = 1,nseg
           write(LERR,*)' Segment ',i,' for record',index(i,2)
           write(LERR,*)' Offset           Time'
           do j = 1,index(i,1)
              pointer = pointer + 1
              write(LERR,*)traces(pointer),times(pointer)
           enddo
        enddo
        return

      ENDIF

      end
