C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (nsamp,dt_units,ntrc,nrec, iform, ntap, otap, 
     :     pfile, mtype, ramp, mul, spinit, spincr, mvel, 
     :     mnemonic, NoExtrap, NoInterp, MinDistToMute, absolute )

#include <f77/iounit.h>
 
      integer     nsamp, ntrc, nrec, ramp, mul
      integer     spinit, spincr, length, MinDistToMute

      real        mvel,dt_units

      character   ntap*(*), otap*(*), pfile*(*), mtype*(*)
      character   mnemonic*(*)

      logical     NoExtrap, NoInterp, absolute
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' sample interval       =  ', dt_units
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*) ' format of data        =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name  =  ', otap(1:length)
      else
        write(LERR,*) ' output data set        =  stdout'
      endif
      length = lenth(pfile)
      write(LERR,*) ' XSD pick file name    =  ', pfile(1:length)
      write(LERR,*) ' mute type             =  ', mtype
      write(LERR,*) ' ramp length (ms)      =  ', ramp
      write(LERR,*) ' time multiplier (ms)  =  ', mul
      write(LERR,*) ' initial sp override   =  ', spinit
      write(LERR,*) ' sp increment override =  ', spincr
      write(LERR,*) ' mute velocity         =  ', mvel
      write(LERR,*) ' minimum distance to mute = ', MinDistToMute
      write(LERR,*)' '
      write(LERR,*)' indexing based on trace header mnemonic = ',
     :     mnemonic
      if ( NoExtrap ) write(LERR,*)
     :     ' no extrapolation beyond pickfile bounds'
      if ( NoInterp ) write(LERR,*)
     :     ' no interpolation between picks.'
      if ( absolute .and. ( mtype .eq. 'diston' .or. 
     :     mtype .eq. 'distoff' ) ) then
         write(LERR,*)' using abs(DstSgn) to control distance mute'
      endif
      write(LERR,*)' '
 
      return
      end



