C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ---------------------------BDNMO -------------------------------------
c
c Author>Paul G. A. Garossino (TRC:2F04:3192) 5/30/91
c
c bdnmo accesses both seismic amplitude and velocity sis trace files
c and either applies or removes normal moveout using
c the full nmo map or alternately the portion before or after the 
c last velocity cross-over in the nmo map.
c
c
c CHANGES:
c
c     June 16, 2001: removed all Numerical Recipe routines from this
c                    program in preparation for release with FreeUSP.
c                    Used the Naval Surface Warfare Center Public Math
c                    library spline routines instead.  Also replaced the
c                    Numerical Recipe heapsort with a generic heap sort
c                    from our utility library.  Performance is about the 
c                    same after all changes.
c     Garossino
c
c     May 1999: Fixed a bug that resulted in NAN's being generated when
c               the nmo map was checked more than once for duplicate
c               values.  In this case duplicate values were generated
c               rather than removed. 
c     Garossino
c
c     November 1996:  put in logic to allow use of 3D velocity cube
c                     without utoping to single trace records.  Prior
c                     to this date any 3D volume corrected with bdnmo
c                     would only correct bins up to input record number
c                     equal to nrecv.  After this point that velocity 
c                     would have been used to correct the rest of the
c                     volume.  This has been corrected needless to say.
c       Garossino
c
cTue May 23 14:47:49 1995  Paul G. A. Garossino  (zpgg07@gpss62)
c
c	* improved error messages for common cockups.  Echo'd 
c	  the important ones to the screen.
c
cWed Apr 12 11:31:06 1995  Paul G. A. Garossino  (zpgg07@gpss62)
c
c	* updated the code to properly handle header values
c	  using saver2, savelu etc.  Also added vmov stuff for
c	  velocity and data to use ITHWP1
c
cWed Oct 21 10:27:51 1992  Paul G. A. Garossino  (zpgg07 at gpss62)
c
c	* I have just added a hard zero onset sensor which does
c          not allow data generated to apease the spline 2nd derivative
c	  calculation from appearing on the output.  This would occur
c	  when a mute was applied that cut deep enough into the data
c	  to affect the data below the cross-over.  All code was 	
c	  added to bdsub.F and is everything with Onset or OnsetOld
c	  on that line.
c
cThu Jul 30 09:49:42 1992  Paul G. A. Garossino  (zpgg07 at gpss62)
c
c	*I have just finished a major re-write of the bdsub.F 
c	 subroutine.  I have added a policeman to determine
c	 if there are at least 4 samples going into the second
c	 derivative calculation associated with the spline interpolation
c	 routine.  I have also fixed the logic to determine which samples
c	 are associated with which parts of the nmo map.  It
c	 was being calculated incorrectly whenever the first defined
c	 sample was not sample 1.
c
c	 I have also upgraded the main routine bdnmo.F to use galloc
c	 and sisseek as well as flushed out the comments so that
c	 hopefully the next time this routine breaks anyone will be
c	 able to fix it. 
c
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
c
c ----- dimension standard USP variables -----
c

      integer     itr(SZLNHD),ntr(SZLNHD)
      integer     nsamp,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     luin,luout,luvel
      integer     nbytes,obytes,lbytes,lbyout
      integer     nvbytes,lvbytes
      integer     irs,ire,ns,ne
      integer     vrs,vre,vst,ved
      integer     argis,pipe,JJ,KK

      real        tri( SZSMPM )
      
      character  ntap*256,otap*256,name*7,vtap*256
      character  hdrwrd * 6

      logical    verbos

c ----- integer USP variables -----
c
c	itr()      : data trace plus header from rtape
c       ntr()      : velocity trace plus header from rtape 
c       itrh()     : trace headers for record
c       nsamp      : number of samples of input trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       ntrco      : output traces/record
c       nrec       : input number of records
c       nreco      : output number of records
c       iform      : format of data
c       nsampv     : number of samples of velocity trace
c       nsiv       : velocity sample interval
c       ntrcv      : velocity traces/record
c       nrecv      : number of velocity records
c       iformv     : format of velocity data
c       luin       : input device
c       luout      : output device
c       luvel      : velocity device
c       lbytes     : number of bytes in lineheader
c       nbytes     : number of input bytes when trace is read
c       lvbytes    : number of bytes in velocity lineheader
c       nvbytes    : number of input bytes when velocity trace is read
c       obytes     : number of bytes to output when processed trace is written
c       argis      : an int function returns 1 if element requested is there 0 if not
c       ist        : window start time (ms)
c       iend       : window end time (ms)
c       irs        : record start
c       ire        : record end
c       ns         : trace start
c       ne         : trace end
c       pipe       : pipe device
c       JJ,KK      : loop counters
c
c ----- real USP variables -----
c
c	tri()      : data trace time series 
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input data file name 
c       otap       : output file name
c       vtap       : input velocity file name 
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c
c ----- set up printout files -----
c

#include <f77/pid.h>

c
c ----- dimension program specific variables -----
c

      integer    vflag
      integer    i,kv,nn,luXY
      integer    DstSgn, ifmt_hdrwrd, l_hdrwrd, ln_hdrwrd
      integer    StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer    RecNum, ifmt_RecNum, l_RecNum, ln_RecNum
      integer    TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum

      integer    errcd1,errcd2,errcd3,errcd4,errcd5,abort

      real       v_trace,nmo_trace,rnum,work,t
      real       dt,dist,yp1,ypn,vscl,vel_const

      pointer     (wkadr1, v_trace(200000))
      pointer     (wkadr2, nmo_trace(200000))
      pointer     (wkadr3, rnum(200000))
      pointer     (wkadr4, work(200000))
      pointer     (wkadr5, t(200000))

      logical    stat, remove, reverse, top, bot, XY, debug, cvel

c
c ----- integer program variables -----
c
c     StaCor    : static value
c     vflag     : multiple velocity function switch
c     kv        : reverse velocity function counter
c     nn        : trace to output nmo-map for
c     luXY      : output nmo-map device
c     errcd1...5: used with galloc
c     abort     : used with galloc
c
c ----- real program variables -----
c
c     v_trace()    : velocity trace
c     nmo_trace()  : nmo corrected/removed trace
c     rnum()       : random number array 
c     work()       : work space
c     t()          : array of sample value reference 1 ... nsamp
c     yp1          : value of second derivative at sample 1
c     ypn          : value of second derivative at nsamp
c
c ----- logical program variables -----
c
c     stat   : flag for static application
c     remove : flag for nmo removal/application
c     reverse: flag for input velocity fcn in reverse order
c     top    : flag to use top of nmo map only
c     bot    : flag to use bottom of nmo map only
c     XY     : flag to output nmo-map
c----------------------------------------------------------------

c
c ----- initialize necessary variables -----
c

      data lbytes/0/
      datan bytes/0/
      dataname/'BDNMO'/
      data lvbytes/0/
      data nvbytes/0/
      data lbyout/0/
      data pipe/3/
      data vst/1/
      data ved/1/
      data abort/0/

c ----- use natural cubic spline -----
c    flags so that second derivative will be zero on each boundary
c
c ieee handler logic...turn on if looking for an IEEE exception
c       external function killit
c       ieeer = ieee_handler ('set','divide',killit)
c       if (ieeer .ne. 0)
c     1    print*,' couldn''t set exception handler'

      yp1 = 1.e+31
      ypn = 1.e+31

      top = .false.
      bot = .false.
      XY = .false.
      verbos = .false.

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c open printout files
 
#include <f77/open.h>
 
c read program parameters from command line card image file

      call cmdln(ntap,otap,vtap,ns,ne,irs,ire,vrs,vre,stat,remove,
     :    reverse,top,bot,nn,verbos,hdrwrd,vscl,debug,cvel,vel_const )

c
c ----- open input and output units -----
c     0 = default stdin
c     1 = default stdout
c

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c
c ----- if nn.gt.0 open xgraph input file and write header
c

      if(nn.gt.0) then
        
         luXY = 4
         open(luXY,file='bdnmo_fcn',status='unknown',err=990)
         write(luXY,*)'" trace ',nn
         
      endif

c
c ----- open velocity dataset -----
c
      IF (.not. cvel) THEN
      if (vtap .ne. ' ') then

         call getln(luvel,vtap,'r',-1)

      else

         write(LERR,*)'bdnmo assumed to be running inside IKP'

         if (reverse) then

            write(LERR,*)'velocity is in a pipe and -B option'
            write(LERR,*)'(reverse) option cannot be used.  If this'
            write(LERR,*)'option must be used -v[] with a disk file'
            go to 999

         endif

         call sisfdfit (luvel, pipe)

      endif

      if  (luvel .lt. 0)   then

         write(LERR,*)'Fatal: velocity file ',vtap,' not found.'
         write(LERR,*)' '
         stop

      endif
      ENDIF

c
c ----- read input lineheader -----
c

      call rtape(luin,itr,lbytes)

      if(lbytes .eq. 0) then
         write(LERR,*)'FATAL: no lineheader found on',ntap
         write(LERR,*)' '
         stop
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers 
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu( hdrwrd ,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c
c ----- save ususal lineheader values -----
c

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c
c ----- print historical line header to printout file -----
c

      call hlhprt (itr, lbytes, name, 6, LERR)

c
c ----- check compatibility of command line entries -----
c 

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c
c ----- malloc only space we're going to use -----
c

      item = ntrc * nsamp * SZSMPD

      call galloc(wkadr1,item,errcd1,abort)
      call galloc(wkadr2,item,errcd2,abort)
      call galloc(wkadr3,item,errcd3,abort)
      call galloc(wkadr4,item,errcd4,abort)
      call galloc(wkadr5,item,errcd5,abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 5*item,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 5*item,'  bytes'
         write(LER,*)' '
         go to 999

      else

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)  5*item,'  bytes'
         write(LERR,*)' '

      endif

c
c ----- modify line header for output -----
c
#include <f77/saveh.h>

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c
c ----- number output bytes -----
c

      obytes = SZTRHD + nsamp * SZSMPD

      call savhlh(itr,lbytes,lbyout)
      call wrtape(luout,itr,lbyout)

c
c ----- velocity data -----
c
      IF (.not. cvel) THEN

      vflag=1
      lvbytes=0

c read the velocity dataset line header

      call rtape(luvel,ntr,lvbytes)

      if(lvbytes .eq. 0) then
         write(LERR,*)'FATAL: no lineheader read on',vtap
         write(LERR,*)' '
         stop
      endif

      call saver(ntr, 'NumSmp', nsampv, LINHED)
      call saver(ntr, 'SmpInt', nsiv  , LINHED)
      call saver(ntr, 'NumTrc', ntrcv , LINHED)
      call saver(ntr, 'NumRec', nrecv , LINHED)
      call saver(ntr, 'Format', iformv, LINHED)

c
c ----- vflag=0 single velocity function -----
c       vflag=1 multiple velocity function

      if( nrecv .le. 1 .and. ntrcv .eq. 1 ) vflag=0

      if(nsampv .lt. nsamp) then
         write(LERR,*)' '
         write(LERR,*)'BDNMO: seismic -- velocity dataset mismatch'
         write(LERR,*)'       Number of samples in seismic dataset = ',
     :        nsamp
         write(LERR,*)'       Number of samples in velocity dataset = ',
     :        nsampv
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'BDNMO: seismic -- velocity dataset mismatch'
         write(LER,*)'       Number of samples in seismic dataset = ',
     :        nsamp
         write(LER,*)'       Number of samples in velocity dataset = ',
     :        nsampv
         write(LER,*)'FATAL'
         goto 999
      endif

      call cmdchk(vst,ved,vrs,vre,ntrcv,nrecv)

      ENDIF

c
c ----- printout -----
c

      call verbal(nsamp,nsi,ntrc,nrec,nrecv,iform,nsampv,nsiv,ntrcv,
     :     iformv,reverse,vflag,stat,remove,top,bot,vtap,ntap,otap,
     :     hdrwrd,vscl,cvel,vel_const)

c
c ----- handle velocity data -----
c
      IF (cvel) THEN

         do  ii = 1, nsamp
             v_trace (ii) = vel_const
         enddo
         nsampv = nsamp
         nrecv = 1
         ntrcv = 1
         vflag = 0

      ELSE

c check for multiple trace per record velocity dataset and reset vre 
c appropriately so that 3D data can be handled without utoping the
c velocity cube.  This should not affect 2D data as there should be 
c a single trace velocity gather in effect at that point. Even if there
c isn't then it should still allow 2D single record, multi-trace velocity
c datasets to be used with 2D lines.

      if ( .not.cvel .AND. ntrcv .gt. 1 ) then
         vre = ( vre - vrs + 1 ) * ntrcv
         if ( vrs .gt. 1 ) vrs = ( vrs - 1 ) * ntrcv + 1
         nrecv = nrecv * ntrcv
         ntrcv = 1
      endif

      nvbytes=1

c
c ----- multiple velocity functions -----
c

      if(vflag .eq. 1) then

         if(vrs .le. nrecv) then
            call recskp(1,vrs-1,luvel,ntrcv,ntr)
         else
            write(LERR,*)' start record to skip to exceeds number'
            write(LERR,*)' records on velocity file'
            write(LERR,*)' check velin run to make sure your velocity'
            write(LERR,*)' model covers the part of the data between'
            write(LERR,*)' records ',vrs,' and ', vre
            stop
         endif

c
c ----- single velocity function -----
c

      elseif(vflag .eq. 0) then

         nvbytes=0
         call rtape(luvel,ntr,nvbytes)
         if(nvbytes .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'BDNMO: No velocity data found after '
            write(LERR,*)'       lineheader in ',vtap,' check '
            write(LERR,*)'       velin run thoroughly.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'BDNMO: No velocity data found after '
            write(LER,*)'       lineheader in ',vtap,' check '
            write(LER,*)'       velin run thoroughly.'
            write(LER,*)'FATAL'
            goto 999
         endif

         call vsmul (ntr(ITHWP1),1,vscl,v_trace,1,nsampv)

         if(verbos) then
            write(LERR,*)'velocity'
            write(LERR,777)(v_trace(i),i=1,nsampv)
 777        format(10f8.2)
         endif

c
c ----- check for valid velocities -----
c

         call dotpr (v_trace,1,v_trace,1,vdot,nsampv)
         if (abs(vdot) .lt. 1.e-06) then
            write(LERR,*)' '
            write(LERR,*)'BDNMO: Velocity trace contains zeros'
            write(LERR,*)'       Check the velin step thoroughly'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'BDNMO: Velocity trace contains zeros'
            write(LER,*)'       Check the velin step thoroughly'
            write(LER,*)'FATAL '
            go to 999
         endif


      endif

c
c ----- read trace -----
c
c   when reading velocity traces make sure that if we run out of vel. traces
c   we use the last vel trace to the end of the line...
c

      kv = 0
      nvbytes=1

      ENDIF

c
c ----- compute sample interval in secs -----
c       take care of micro secs if necessary
c

         dt = real (nsi) * unitsc

c
c ----- generate random number array for spline routine -----
c       required when leading zeroes on trace data cause
c       ieee underflow errors in spline.
c

      call vrand(911,rnum,1,nsamp)

      do i=1,nsamp
         rnum(i)=rnum(i)*1.0e-21
         t(i) = float(i)
      enddo

c
c ----- BEGIN PROCESSING -----
c     skip unwanted records
c

      call recskp(1,irs-1,luin,ntrc,itr)

      DO 100 JJ = irs, ire

         if(vflag.eq.1.and.nvbytes.ne.0.and.JJ.le.vre)then

            nvbytes=0

c
c ----- read in reverse order ?
c
            
            if(reverse)then

               kv = kv + 1

               call skipt (luvel, ntrcv*(vre-kv), idummy)


            endif

c
c ----- read velocity data -----
c

            call rtape(luvel,ntr,nvbytes)
            if(nvbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'BDNMO: Premature EOF on Velocity Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL' 
               write(LER,*)' '
               write(LER,*)'BDNMO: Premature EOF on Velocity Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL' 
               goto 999
            endif
            call vsmul (ntr(ITHWP1),1,vscl,v_trace,1,nsampv)

            if(debug) then

               call saver2 ( ntr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER)
               call saver2 ( ntr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER)
               write (lerr,*) 'Reading Velocity Trace: RecNum ',RecNum,
     :              ' TrcNum ',TrcNum
            endif

c
c ----- check for valid data -----
c

            call dotpr (v_trace,1,v_trace,1,vdot,nsampv)

            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)' '
               write(LERR,*)'BDNMO: Velocity trace contains zeros'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'BDNMO: Velocity trace contains zeros'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif

            if(verbos) then
               write(LERR,*)'rec ',JJ,' velocity'
               write(LERR,777)(v_trace(i),i=1,nsampv)
            endif

         endif


c
c ----- skip to start trace -----
c

         call trcskp(jj,1,ns-1,luin,ntrc,itr)

         DO 99  KK = ns,ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of seismic dataset:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            call vmov(itr(ITHWP1),1,tri,1,nsamp)

            if ( debug ) then
               call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER)
               call saver2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER)
            endif


            call vclr(work,1,nsamp)

c
c ----- skip if trace is flagged dead ----- 
c
 
            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor,
     :           TRACEHEADER)
                
            IF ( StaCor .ne. 30000 ) THEN

c
c ----- get absolute value of trace distance from traceheader -----
c

               call saver2 ( itr, ifmt_hdrwrd, l_hdrwrd, ln_hdrwrd, 
     :              DstSgn, TRACEHEADER )
               dist = float(iabs(DstSgn))

               StaCor=StaCor/nsi
               if(.not.stat) StaCor=1
               if(StaCor .eq. 0) StaCor=1

               if(StaCor .lt. 0) then

                  StaCor=-StaCor
                  call vmov(tri(StaCor),1,work(1),1,nsamp)

               else

                  call vmov(tri(1),1,work(StaCor),1,nsamp)

               endif

c
c ----- set XY flag to true if trace is nn -------
c       this will enable the output of the xgraph moveout map
c       file bdnmo_fcn for this trace
c

               if(KK.eq.nn)XY = .true.

               if ( debug ) then
                  write (lerr,*) 'Operating on Data Trace: RecNum ',
     :                 RecNum,' TrcNum ',TrcNum
                  write (lerr,*) ' JJ ',JJ,' KK ',KK
                  write(lerr,*)' '
               endif

c debug
c               if ( kk .eq. 83 ) then
c                  write(lerr,*)'made it'
c               endif

               call bdsub(work,dt,nsamp,dist,v_trace,remove,nmo_trace,
     :              top,bot,rnum,XY,luXY,yp1,ypn,t)

            ELSE

               call vclr(nmo_trace,1,nsamp)


            ENDIF

            call vmov(nmo_trace(1),1,itr(ITHWP1),1,nsamp)
            call wrtape (luout,itr,obytes)

 99      CONTINUE
 
c
c ----- skip to end of record -----
c

         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 100  CONTINUE

c normal termination
  
      call lbclos ( luin )
      call lbclos ( luout )
      if (.not. cvel) call lbclos ( luvel )
      if(nn.gt.0)close(luXY)

      write(LERR,*)'end of bdnmo, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)' bdnmo: Normal Termination'
      stop

      
 990  continue

c
c ----- unable to open xgraph data output file -----
c

      write(LERR,*)' '
      write(LERR,*)'BDNMO: Unable to open bdnmo_fcn xgraph output file'
      write(LERR,*)'       Check that you have write permission in    '
      write(LERR,*)'       directory where you started this process.'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'BDNMO: Unable to open bdnmo_fcn xgraph output file'
      write(LER,*)'       Check that you have write permission in    '
      write(LER,*)'       directory where you started this process.'
      write(LER,*)'FATAL'
      stop

c
c ----- close data files -----
c

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      if (.not. cvel) call lbclos ( luvel )

      if(nn.gt.0)close(luXY)

      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' bdnmo: Abnormal Termination'

      stop
      end
