C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine zct(data,dt,nsamp,odata,mode,pol)
C 
C This routine measures the time, in seconds, between zero crossings
C of array data().
C
C 25 April 1994, R. O. Lindsay.
C
C data(*)  - input array of points
C dt       - input sample interval
C nsamp    - number of points in data(*)
C odata(*) - output square wave array containing times
C mode     - algorithm mode where,
C            0 = fast, an approximation adding up whole samples only
C            1 = normal, using linear interpolation between samples
C pol      - polarize time output with polarity of array data(*)
C            0 = do not polarize
C            1 = polarize
C
C
C Dimension variables
C
      real data(*),dt,odata(*)
      real t,tot,ot,nt
      integer nsamp,mode
      integer i,j,k,osign,nsign
C
C Preset the sign of the first data point.
C
      if(data(1).ge.0.0) then
          osign = 1
      else
          osign = -1
      endif
C
C If user selects "fast mode", m=0 then find the whole sample time
C sums.
C
      if(mode.eq.0) then
          j=1
          do 10 i=2,nsamp
              if(data(i).ge.0.0) then
                  nsign = 1
              else
                  nsign = -1
              endif
C
              if(osign.eq.nsign) then
                  goto 10
              else
                  osign = nsign
c                 t = float(i-j-1) * dt
                  t = float(i-j  ) * dt
                  do 20 k=j,i-1
                      odata(k) = t
   20             continue
                  j=i
              endif
   10     continue
      else
          ot = 0.0
          j=1
          do 30 i=2,nsamp
              if(data(i).ge.0.0) then
                  nsign = 1
              else
                  nsign = -1
              endif
              if(osign.eq.nsign) then
                  goto 30
              else
                  osign = nsign
                  tot = abs(data(i-1)) + abs(data(i))
c                 t = float(i-j-1) * dt
                  t = float(i-j  ) * dt
                  nt = dt * (abs(data(i-1)) / tot)
                  t = t + ot + nt
                  do 40 k=j,i-1
                      odata(k) = t
   40             continue
                  ot = dt - nt
                  j=i
              endif
   30     continue
      endif
C
C Polarize the output times, if requested.
C
      if(pol.ne.0) then
          do 100 i=1,nsamp
              if(data(i).lt.0.0) then
                  odata(i) = odata(i) * (-1.0)
              endif
  100     continue
      endif
C
C Return to calling object.
C
      return
      end
