C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do binning based on trace distance
c and stack within bins

      subroutine binsum (ngrp, nsamp, dist, xmax,
     2                   dx, spread, xtr, out, rept)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      
      real       xtr (*)
      real       out  (nsamp,ngrp)
      real       spread(*), rept(*)

c     write(LER,*)'dist= ',dist,dx,ngrp,nsamp
c     write(LER,*)(spread(ii),ii=1,ngrp)
c----
c   build input distance table,
c   find any bins that have multiple traces
c   in them
c----
          x  = dist
          do  jj = 1, ngrp
              x1 = spread (jj) - .5 * dx
              x2 = spread (jj) + .5 * dx
c-------------
c trace falls within jj_th bin
c count # trcs in each bin &
c stack within bin
c-------------
              if (x .ge. x1 .and. x .lt. x2) then
                  rept(jj) = rept(jj) + 1.0
                  do  ii = 1, nsamp
                      out (ii,jj) = out (ii,jj) + xtr(ii)
                  enddo
              endif
          enddo

      return
      end
