C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c********************************************************************c
c
c bkgrnd reads records of data, computes the average amplitude over 
c a large window of data for each trace, fits the averages to a 
c straight line, and removes the slope of that line from the data,
c making the assumption that the slope represents a background 
c gain (+ or -).
c********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
c-----
 
      integer pmax,mmax
      parameter (pmax=10)
      parameter (mmax=100)
      integer     itr ( SZLNHD )
      integer     lhed( 1500 )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne,iws,iwe
      
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1(1),trhdrs(1)
      real        trace(SZLNHD), numbers(SZLNHD),sig(SZLNHD)
      real        intercept,slope,desired_slope,computed_slope
c------

c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     stat
      real        tri ( SZLNHD )
      real        havg(1)
      integer     z(1)
      real        a ( 1 ), b ( SZSMPM ),ww(1)
      real        weight(1),tempo(1)
      character   ntap * 100, otap * 100, name*6
      logical     verbos, query, dead(1)
      integer     argis
      integer     abort
      pointer     (wkadr1, bigar1),(adrtrhdrs,trhdrs)
      pointer (adrdead,dead),(adra,a),(adrw,weight),(adrww,ww)
      pointer (pt,tempo),(ph,havg),(pz,z)
 
      equivalence ( itr(1), tri (1) ,b(1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'BKGRND'/
      data abort / 0 /
 

      ithw = ITHWP1 - 1
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 ).or.(argis('-H').gt.0)
      if ( query )then
            call help(ler)
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,irs,ire,iws,iwe,mode,desired_slope,verbos)

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'BKGRND: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsi,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LINEHEADER)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 6, LERR)

c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
c-----
      ns = 1
      ne = ntrc
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c---------------------------------------------------
c  malloc space we are going to use
c  note also ISZBYT is the 
c  size of an item in bytes
c--------------------------

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92


      ner = 0
      ier = 0
      abort1 = 0
      iget = ntrc * nsamp * ISZBYT
      call galloc (wkadr1, iget, ier, abort1)
      memsum=iget
      ner = ner + ier
      iget =ntrc*ISZBYT
      call galloc (adrdead, iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier
      iget = ntrc*ITRWRD*ISZBYT
      call galloc (adrtrhdrs, iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier
      iget = ntrc*nsamp*ISZBYT
      call galloc(adra, iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier
      iget = ntrc*ISZBYT
      call galloc(adrw, iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier
      iget = nsamp*ISZBYT
      call galloc(adrww, iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier
      call galloc(pt , iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier

      if (ner.ne.0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c---------------------------------------------------


c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      jtr=ne-ns+1
      call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecc,LINEHEADER)
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LINEHEADER)

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * ISZBYT
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary

      if (nsi .le. 32) then
         dt = float (nsi) /1000.
      else
         dt = float (nsi) /1000000.
         nsi = nsi/1000
      endif
      sr = dt * 1000.
      if(iws.lt.0)iws = 0
      if(iwe.eq.0)iwe = nsamp*nsi-nsi
      jws = iws
      jwe = iwe
      iws = iws/nsi+1
      iwe = iwe/nsi+1
      ndo = iwe-iws+1
      if(lwin.eq.0)then
        lwin = ndo
      else
        lwin = lwin/sr
      endif
      lwin = ((lwin-1)/2)*2+1
      if(lwin.gt.ndo)lwin=ndo
      xlap = ovlp
      ovlp = ovlp*.01
      if(ovlp.eq.0)ovlp=.5
      if(mode.gt.4)mode=0

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
       call verbal(nsamp, nsi, ntrc, nrec,
     :             mode, jws, jwe,ntap,otap,desired_slope)
      end if
      igap = 0
      nwin = 1
      iend=lwin
      istrt=1
c------------------------------------------
c  now allocate the work arrays for getavg         
c-----------------------------------------
      ner = 0
      ier = 0
      abort1 = 0
      iget = nwin*ntrc*ISZBYT
      call galloc(ph , iget, ier, abort1)
      memsum=memsum+iget
      ner = ner+ier
      call galloc(pz , iget, ier, abort1)
      memsum=memsum+iget
      ner = ner + ier

      if (ner.ne.0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
      endif
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
C     call recskp(1,irs-1,luin,ntrc,itr)
      if(irs.gt.1)then
       do i=1,irs-1
        do j=1,ntrc
         nit = 0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LER,*)'EOF encountered looking for record ',irs
          write(LERR,*)'EOF encountered looking for record ',irs
          call lbclos(luin)
          call lbclos(luout)
          stop
         endif
        end do
       end do
      end if

c-----
c     process desired data
c-----
      do jj = irs, ire
 
       do i=1,ntrc
        dead(i)=.false.
       end do
       do i=1,ntrc
        j=(i-1)*nsamp
        do kk=1,nsamp
         a(j+kk)=0.
        end do
       end do
       do kk = 1,ntrc
        nbytes = 0
        call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c------
        if(nbytes .eq. 0) then
         write(LERR,*)'End of file on input:'
         write(LERR,*)'  rec= ',jj,'  trace= ',kk
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif

c------
c     get some necessary trace header values.               
c------
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,stat,TRACEHEADER)
        if (stat .ge. 30000) then
          call vclr (tri(ITHWP1),1,nsamp)
          dead(kk)=.true.
        end if
c----------------------
c  pack data into array.  if the trace is dead,
c  the getavg routine will account for it.
c----------------------
        istrc = (kk-1)*nsamp
        call vmov (tri(ITHWP1),1, bigar1(istrc+1),1,nsamp)
        isthd = (kk-1)*ITRWRD
        call vmov(itr,1,trhdrs(isthd+1),1,ITRWRD)

       end do    
c-----------------------
c  here is the meat...
c----------------------
       ierr = 0
       call getavg (ntrc, nsamp, bigar1, a,mode,lwin,nwin,igap,
     :   havg, z, dead, iws, iwe, ierr)
       if(ierr.ne.0)then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate workspace for getavg'
        write(LERR,*)' '
        call lbclos ( luin )
        call lbclos ( luout )
        stop
       endif
c +===================================+
c | get the averages and do linear fit|
c +===================================+
       j=0
       do itrace=1,ntrc
        trace(itrace)=itrace
        sig(itrace)=1.
        numbers(itrace)=havg(itrace)
       end do
       mwt=0
       call fit ( trace, numbers, ntrc, sig, mwt, intercept,
     1        computed_slope, siga, sigb, chi2)
c +------------------------------+
c | remove the average decay and |
c | write output data            |
c +------------------------------+
        slope = desired_slope-computed_slope
       if(verbos)write(LER,*)
     : 'intercept = ',intercept,' slope = ',computed_slope
        do i=0,ntrc-1
         xi = i
         isthdr = i*ITRWRD+1
         ndx=i*nsamp
         do j=1,nsamp
          bx = bigar1(ndx+j)
          if(bx.ne.0.0)then
           xs=abs(bx)/bx
           b(ithw+j)=xs*(abs(bx)+xi*slope)
          else
           b(ithw+j)=0.
          end if
         end do
         isthdr = i*ITRWRD+1
         call vmov(trhdrs(isthdr),1,itr,1,ITRWRD)
         call wrtape(luout,itr,obytes)
        end do

      end do

      if(ire.lt.nrec)then
       write(LER,*)' Processing complete. Copying rest of data set'
      else
       write(LER,*)' Processing complete.'
      endif
      irs = ire+1
      do while (irs.lt.99999)
       do i=1,ntrc
        nit=0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
        call wrtape(luout,itr,nit)
       end do
       irs = irs+1
      end do
c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )

      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'bkgrnd computes an average amplitude decay for a record of   '
        write(LER,*)
     :'data and removes this average from each trace in the record.'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute bkgrnd by typing bkgrnd and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -s[ws]       (default = 0)        : analysis window start (ms)'
        write(LER,*)
     :' -e[we]   (default = end of trace) : analysis window end (ms)'
        write(LER,*)
     :' -md[md]      (default = 0)        : averaging mode'
        write(LER,*)
     :'                                     0 = AAA'
        write(LER,*)
     :'                                     1 = rms' 
        write(LER,*)
     :'                                     2 = GMAA'
        write(LER,*)
     :'                                     3 = median  '
        write(LER,*)
     :' -m[slope]    (default = 0.0)      : the desired change of ampl.'
        write(LER,*)
     :'                                     with offset (slope computed'
        write(LER,*)
     :'                                     as function of trace number'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   bkgrnd -N[ntap] -O[otap] -rs[irs] -re[ire] -s[ws] '
        write(LER,*)
     :' -e[we] -md[mode] -m[] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,iws,iwe,mode,
     :desired_slope,verbos)
c-----
c     get command arguments
c
c     ntap         - C*100    input file name
c     otap         - C*100    output file name
c     irs          - I*4      starting record index
c     ire          - I*4      ending record index
c     iws          - I*4      analysis window start time
c     iwe          - I*4      analysis window end time
c     mode         - I*4      average mode 
c                             (0=arith, 1=geometric, 2=harmonic)
c     desire_slope -  R*4 desired change in <amplitude> with trace no..
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     irs, ire,iws,iwe
      real        desired_slope
      integer     mode
      logical     verbos
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
       call argstr( '-N', ntap, ' ', ' ' )
       call argstr( '-O', otap, ' ', ' ' )
       call argi4 ( '-rs', irs ,   0  ,  0    )
       call argi4 ( '-re', ire ,   0  ,  0    )
       call argi4 ( '-md', mode,  0, 0 )
       call argi4 ( '-s', iws, 0, 0)
       call argi4 ( '-e', iwe, 0, 0)
       call argr4 ( '-m', desired_slope,0.0,0.0)
       verbos =   (argis('-V') .gt. 0)
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec,
     :                  mode, iws,iwe,ntap,otap,desired_slope)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec,ovlp
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' input data set name   =  ', ntap(1:30)
            write(LERR,*) ' output data set name  =  ', otap(1:30)
            if(mode.eq.0)then
             write(LERR,*)' averaging method      =  AAA'
            endif
            if(mode.eq.1)then
             write(LERR,*)' averaging method      =  RMS '
            endif
            if(mode.eq.2)then
             write(LERR,*)' averaging method      =  GMAA'
            endif
            if(mode.eq.3)then
             write(LERR,*)' averaging method      =  median'
            endif
            write(LERR,*) ' analysis window start = ',iws,' ms'
            write(LERR,*) ' analysis window end   = ',iwe,' ms'
            write(LERR,*) ' desired output slope  + ',desired_slope
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
