C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine kmeans(iclustasg, ncenters, centers, nclust, nparm, 
     1                  mparm, nvect, vect, kflag, ler, lerr)

      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c iclustasg 	=>      iclustasg(i) is cluster assignment for i-th 
c			feature vector contained in vect
c ncenters	=>      ncenters(i) is number of members contained in
c                       i-th cluster
c centers	=>      cluster centers 
c nclust 	=> 	Desired number of clusters
c nparm         =>  	Number of complex parameters per feature vector
c mparm		=>      Array dimension size in calling program for 
c                       vect and centers...mparm >= nparm
c nvect		=>      Number of feature vectors to be clustered
c vect		=>      Array containing feature vectors to be clustered
c kflag		=>	integer parameter that indicates wether the 
c			algorithm has converged or not
c kflag = 0		no vectors were reassigned indicating convergence
c kflag  = #		# of vectors reassigned
c ler		=>	standard error
c lerr		=>	usp log file
c-----------------------------------------------------------------------

      integer nclust, nparm, mparm, nvect, kflag, ler, lerr 
      integer iclustasg(nvect), ncenters(nclust)
      complex vect(mparm, nvect), 
     1        centers(mparm,nclust) 
      
      integer i, j, ic, ivect, iclust, iminc
      real d, dmin
      real*4 dist

c first reassign clusters

      kflag = 0 
      do ivect=1, nvect
         dmin=1.0e25  

c-----------------------------------------------------------------------
c calculate distance to each cluster

         do iclust=1, nclust
            d=dist(centers(1,iclust),vect(1,ivect),nparm)     
            if (d .lt. dmin) then
               dmin = d
               iminc = iclust
            end if
         enddo
         if (iclustasg(ivect) .ne. iminc) then
            kflag = kflag + 1
         endif
         iclustasg(ivect) = iminc
      enddo
      write(ler,'(a,i7)') 'CLUST3D: Number of reassignments = ', kflag
            
c-----------------------------------------------------------------------
c recompute cluster locations...first initialize to zero

      do j=1, nclust
         ncenters(j) = 0
         do i=1, nparm
            centers(i,j) = 0
         enddo
      enddo

c-----------------------------------------------------------------------
c sum up vectors in ic-th cluster 

      do j=1, nvect
         ic = iclustasg(j)
         ncenters(ic) = ncenters(ic) + 1
         do i=1, nparm
            centers(i,ic) = centers(i,ic) + vect(i,j)
         enddo
      enddo

c----------------------------------------------------------------------- 
c check if cluster is empty...if it is not -> normalize to get mean

      do j=1, nclust
         do i=1, nparm
             if (ncenters(j) .gt. 0) then
                centers(i,j) = centers(i,j) / ncenters(j)
             elseif (ncenters(j) .eq. 0 .and. i .eq. 1) then
                write(ler,'(a,i3,a)') 'CLUST3D: Warning that cluster ',
     1                j,' has 0 members'
             end if        
          enddo
      enddo
      
      return
      end

