C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cluster(iclustasgloc, iclustasg, ncenters, centers,
     1                   nclust, nparm, mparm, nvect, vect, sclustini,
     2                   seed, ler, lerr, range, sdelthresl, sdelthresu,
     3                   sdelini, maxcycle, kmthres, index, 
     4                   cputim, waltim, verbos)
   
      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c This routine does K-means clustering on complex vectors. It includes
c a subroutine to initialize cluster centers (subroutine clustinit), a
c subroutine that computes one iteration of the actual K-means algorithm
c (subroutine kmeans), and a subroutine that modifies clusters according
c to certain criteria.
c iclustasgloc 	=>      iclustasgloc(i) is the location of the vector  
c		        that corresponds to the i-th cluster assignment 
c                       given by iclustasg(i)
c iclustasg 	=>      iclustasg(i) is cluster assignment for i-th 
c			feature vector contained in vect
c ncenters	=>      ncenters(i) is number of members contained in
c                       i-th cluster
c centers	=>      cluster centers 
c nclust 	=> 	desired number of clusters
c nparm         =>  	number of complex parameters per feature vector
c mparm		=>      array dimension size in calling program for 
c                       vect and centers...mparm >= nparm
c nvect		=>      number of feature vectors to be clustered
c vect		=>      array containing feature vectors to be clustered
c sclustini	=>      integer parameter which selects cluster 
c 			initialization method used in subroutine clustini  
c sclustini=1  		initial cluster centers are first nclust 
c			vectors in vect
c sclustini=2  		randomly select nclust vectors from vect
c sclustini=3  		use "farthest neighbor" method
c sclustini=4		use "maxmin" method
c seed		=>	positive integer seed for random generator
c                       used in subroutine clustinit when sclustini=2 
c                       is selected
c ler		=>	standard error
c lerr		=>	usp log file
c range		=>	integer parameter that selects which clusters  
c                       are modified in subroutine clusdel
c                       (if they fall within the modification threshold
c                       specified by sdelthresl and sdelthresu).
c range = 0		do not modify any clusters
c range = 1	        cluster centers with less than or equal to
c 			sdelthresl members are modified according to the 
c			method specified by sdelini 	
c range = 2	        cluster centers with more than sdelthresl and less
c                       than sdelthresu members are modified according to  
c			the method specified by sdelini 	
c range = 3	        cluster centers with more than or equal to
c 			sdelthresu members are modified according to the 
c			method specified by sdelini 	
c sdelthresl	=> 	integer parameter which selects lower 
c                       modification threshold. 
c sdelthresu	=> 	integer parameter which selects upper 
c                       modification threshold.  
c sdelini	=>	integer parameter which selects modification 
c			method used in subroutine clusdel
c sdelini=1		deletes all vectors in clusters which have 
c			less than or equal to sdelthres members
c sdelini=2		deletes all vectors in clusters and clusters  
c			themselfes which have less than or equal to 
c                       sdelthres members
c sdelini=3		deletes clusters which have less than or equal to
c			sdelthres members, reduces # of clusters
c sdelini=4		relocate clusters which have less than or equal to
c			sdelthres members
c maxcycle		within the clust3dm routine we run throught a cycle
c                       which consist of clustering of the feature vectors
c                       followed by a modification of the feature vectors
c                       and/or clusters, respectively. maxcyle specifies how 
c                       many of these cycles will at most occur. 
c kmthres	=> 	integer parameter which selects convergence 
c			threshold used for each K-means cycle. 
c verbos		flag which determines if additional printout
c                       is desired for standard error (ler) and usp
c                       log file (lerr)
c-----------------------------------------------------------------------

      integer     nclust, nparm, mparm, nvect, sclustini
      integer     seed, ler, lerr, range, sdelthresl, sdelthresu
      integer     sdelini, maxcycle, kmthres, index(nclust) 
      integer     iclustasgloc(nvect),iclustasg(nvect), ncenters(nclust)     
      complex     vect(mparm,nvect), centers(mparm,nclust)  
      real        cputim(*), waltim(*)
      logical     verbos

      integer     i, j, iflag, kflag
      real        v2, vtot2, w2, wtot2

      call timstr(v2, w2)

c-----------------------------------------------------------------------
c Initialize cluster assignment location. The i-th cluster assignment
c location corresponds to the i-th live trace (running down trace, then
c records), i.e., iclustasg(i) contains the cluster assignment for the
c i-th live trace. 

      do i = 1, nvect
         iclustasgloc(i) = i
      enddo

c-----------------------------------------------------------------------
c Initialize cluster centers 
      
      call clustinit(nvect, nparm, mparm, vect, centers, nclust,
     1               sclustini, iclustasg, seed, ler, lerr)

c-----------------------------------------------------------------------
c K-means clustering 

      i = 1
      iflag = 1
      do while (iflag .gt. 0)     
         kflag = kmthres + 1 
         do while (kflag .gt. kmthres)
            call kmeans(iclustasg, ncenters, centers, nclust, nparm, 
     1                  mparm, nvect, vect, kflag, ler, lerr)

            write(ler,'(a, i7)')'CLUST3DM: Number of feature vectors cur
     1rently used ', nvect
            write(ler,10) (j,ncenters(j),j=1,nclust)
 10         format('CLUST3DM: Cluster populations:'
c    1      /<nclust>(1x,i2,':',i7,1x)) 
     1      /,9999(1x,i2,':',i7,1x)) 
         end do
         maxcycle = maxcycle - 1

c-----------------------------------------------------------------------
c Check the maximal cycles number 

         if (maxcycle .ne. 0) then

c-----------------------------------------------------------------------
c Optionally remove or relocate clusters

            write(lerr,10) (j,ncenters(j),j=1,nclust)

            call clusdel(iclustasgloc, iclustasg, ncenters, centers,
     1                   nclust, nparm, mparm, nvect, vect, iflag,
     2                   range, sdelthresl, sdelthresu,
     3                   sdelini, index, ler, lerr, verbos)
         else
            iflag = 0
         endif

      enddo

c ----------------------------------------------------------------------
c Output cluster centers and number of vectors assigned to each cluster 
c cluster after K-means algorithm was applied

      write(ler,30) (j,ncenters(j),j=1,nclust)
30    format('CLUST3DM: Final number of vectors assigned to clusters:'
c    1         / <nparm>(1x,i2,':',i7,3x))
     1         /,9999(1x,i2,':',i7,3x))

      write(lerr,30) (j,ncenters(j),j=1,nclust)

      write(lerr,45) (j,(centers(i,j),i=1,nparm),j=1,nclust)   
45    format('CLUST3DM: Final cluster centers:'/ (1x,i2,1x,
c    1<nparm>('('f9.4,1x,f9.4,')',1x)))
     1 9999('('f9.4,1x,f9.4,')',1x)))

      call timend(cputim(2), v2, vtot2, waltim(2), w2, wtot2)

      return
      end            

