/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "globs.h"

int 	verbose    		= 0;
int 	gw_hdr_skip    		= 0;
int	cartNumber 		= 0;
float	totalBytes		= 0L;
long	blockSize  		= 0;
char*	sampleDeviceName	= "/dev/rst0";
char	deviceName[1024]	= {"{none}"};

/* static int	defaultRead	=	1024 * 512; - caused EOT problems - JMW
*/
static int	defaultRead	=	1024 * 32;
static int	defaultWrite	=	1024 * 32;

FILE* mytty;

int tape	= -1;
int totape	= 1;

char* iobuffer	= 0;
long blen	= 0L;
long bout	= 0L;
int  inputEOF	= 0;
long bgood	= 0L;	/* number of bytes with data */

void flushMe()
{
    fflush(mytty);
}

void announce()
{
   fprintf(mytty, "Cram:  device     = \"%s\"\n", deviceName);
   fprintf(mytty, "       block size = %ld\n", blockSize);
   fprintf(mytty, "This will be cartridge number %d (from 1).\n", cartNumber);
/* - j.m.wade 3/23/94
   fprintf(mytty, "Bytes %s so far: %0.f\n", totape ? "written" : "read",
	   totalBytes);
*/
   flushMe();
}

void getFileName()
{
    char l[1024];

    if (totalBytes > 0)
      fprintf(mytty, "Bytes %s so far: %0.f\n", totape ? "written" : "read",
	   totalBytes);
    fprintf(mytty, "I need a device file name to %s.\n",
	    totape ? "write to" : "read from");
    fprintf(mytty, "Current device file name is:  %s\n", deviceName);
    fprintf(mytty, "An example of a file name is: %s\n", sampleDeviceName);
    if(totape)
	fprintf(mytty, "Enter a device file name to use here: ");
    else
	fprintf(mytty,
		"Enter a device file name to use here or <RETURN> to exit: ");
    flushMe();
    fgets(l, 1000, mytty);
    if(l[strlen(l) - 1] == '\n')
	l[strlen(l) - 1] = '\0';
    deviceName[0] = '\0';
    sscanf(l, "%s", deviceName);
}

int fileIsOk()
{
    struct stat ss;
    if(stat(deviceName, &ss) < 0) {
	fprintf(mytty, "\ncram: can't stat %s.\n\n", deviceName);
	flushMe();
	return 0;
    }
    if(!S_ISCHR(ss.st_mode)) {
	fprintf(mytty, "\ncram: %s is not a character special file (fool).\n\n",
		deviceName);
	flushMe();
	return 0;
    }
    tape = open(deviceName, totape ? O_WRONLY : O_RDONLY);
    if(tape < 0) {
	fprintf(mytty, "\ncram: couldn't open %s.\n\n", deviceName);
	flushMe();
	return 0;
    }
    return 1;
}
/*
**	keep trying until we have an open device or the user aborts.
*/
void setUpDrive()
{
    do {
	getFileName();
    } while( fileIsOk() == 0 );
    ++cartNumber;
    announce();
}

void finishDrive()
{
    if(tape >= 0) {
	fprintf(mytty, "** Closing %s\n", deviceName);
	close(tape);
	tape = -1;
    }
}

long getInput()
{
    long bytesIn;
    if(totape) {
	bytesIn = fread(iobuffer, 1, blockSize, stdin);
	if(verbose)
	    fprintf(stderr, "V: %ld in", bytesIn);
	if(bytesIn < blockSize) {
	    inputEOF = 1;
	    if(bytesIn < 1)
		bytesIn = 0;
	}
    } else {
	bytesIn = read(tape, iobuffer, blockSize);
	if(verbose)
	    fprintf(stderr, "V: %ld in", bytesIn);
	if(bytesIn < 1) {
	    inputEOF = 1;
	    bytesIn = 0;
	}
    }
    return bytesIn;
}

static void usage()
{
    fprintf(stderr, "cram usage:  function              default value\n");
    fprintf(stderr, "              -r read tape           write tape\n");
    fprintf(stderr, "              -v verbose operation      off\n");
    fprintf(stderr, "              -b block-size            32768\n");
    fprintf(stderr, "              -g header-skip ( USP )    off\n");
    fprintf(stderr, "\n");
}

int main( argc, argv)
int argc;
char*argv[];
{
    static char*	options = "grvb:";
    extern char* optarg;
    extern int optind;

    int c;
    while((c = getopt(argc, argv, options)) != -1)
	switch(c) {
	  case 'r':
	    totape = 0;
	    break;
	  case 'g':
	    ++gw_hdr_skip;
	    break;
	  case 'v':
	    ++verbose;
	    break;
	  case 'b':
	    blockSize = atol(optarg);
	    break;
	  default:
	    usage();
	    exit(1);
	    break;
	}

    if(blockSize == 0)
	    blockSize = totape ? defaultWrite : defaultRead;
	
    mytty = fopen("/dev/tty", "r+");

    return totape ? tapeout() : tapein();
}

