C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CROSSF(A,LA,B,LB,X,LX)

C---  convolve time series A with time series B
C---  and return result in X

      PARAMETER (MXPOW=16384,MXWRK=(5*MXPOW)/2)
      REAL A(LA), B(LB), X(LX)
      COMPLEX ZA(MXPOW), ZB(MXPOW)

      DATA LPOW /0/
      SAVE LPOW ! KEEP STATIC

C---  DETERMINE CORRECT POWER OF 2 FOR FFT'S
      LENGTH=LA+LB+1
      NPOW=2
1     CONTINUE
      NPOW=2*NPOW
      IF (NPOW .LT. LENGTH) GOTO 1
      NPOW=MIN(NPOW,MXPOw)

C---  CONVERT A TO COMPLEX W/IMAG=0
      DO 2 J = 1, LA
         ZA(J) = (CMPLX(A(J)))
2     CONTINUE
      DO 3 J = LA+1, NPOW
         ZA(J) = (0.,0.)
3     CONTINUE

C---  CONVERT TIME REVERSAL OF B TO COMPLEX
      K=1
      DO 4 J = 1, LB
         ZB(J) = (CMPLX(B(J)))
4     CONTINUE
      DO 5 J = LB+1, NPOW
         ZB(J) = (0.,0.)
5     CONTINUE

C---  IF NPOW CHANGES, REBUILD SIN/COS TABLE FOR FFT'S
c     IF (NPOW .NE. LPOW) CALL CFFT2(1,1,NPOW,ZA,TABLE,ZA)
      call cfftb (ZA, ZA, npow, +1)
      call cfftb (ZB, ZB, npow, +1)

C---  MULTIPLY IN FREQ DOMAIN AND DO INVERSE TRANSFORM
      DO 6 N = 1, NPOW
         ZA(N) = ZA(N)*ZB(N)
6     CONTINUE
      call cfftb (ZA, ZA, npow, -1)

C---  REMEMBER NPOW FOR NEXT CALL
      LPOW = NPOW

      SF = 1.0/NPOW
      DO 8 I = 1, LX
         X(I) = real(ZA(I))*SF
8     CONTINUE

      RETURN
      END
