C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine BuildCrossPlot ( nsampo, ntrco, xplot, nsamp, ntrc, 
     :     var1, var1_min, var1_max, var1_delta, 
     :     var2, var2_min, var2_max, var2_delta )

c variables passed from calling routine

      integer nsamp, ntrc, nsampo, ntrco

      real xplot(nsampo, ntrco)
      real var1 ( nsamp, ntrc), var2 ( nsamp, ntrc )

      real var1_min, var1_max, var1_delta
      real var2_min, var2_max, var2_delta 

c local variables

      integer i, j, var1_bin, var2_bin


      do i = 1, nsamp

         do j = 1, ntrc

            var1_bin = -1
            var2_bin = -1

            if ( var1(i,j) .ge. var1_min .and. 
     :           var1(i,j) .le. var1_max ) then
               var1_bin = int( ( var1(i,j) - var1_min ) / var1_delta )
            endif

            if ( var2(i,j) .ge. var2_min .and. 
     :           var2(i,j) .le. var2_max ) then
               var2_bin = int( ( var2(i,j) - var2_min ) / var2_delta )
            endif

c debug
c            if ( var1_bin .ge. (nsampo - 1) ) then
c               write(*,*)'made it'
c            endif
c debug
            if ( var1_bin .ge. 1 .and. 
     :           var1_bin .le. nsampo .and. 
     :           var2_bin .ge. 1 .and. 
     :           var2_bin .le. ntrco ) then
               xplot(var1_bin,var2_bin) = xplot(var1_bin,var2_bin) + 1

            endif
         enddo
      enddo

      return
      end
