C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     CROSSPLOT:  crossplot records from two datasets
c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer nsamp, nsi, ntrc, nrec, ntrco, nsampo, nreco
      integer irs, ire
      integer luout, nbytes, obytes
      integer argis, pipe

      integer  itr1( SZLNHD ), itr2( SZLNHD )

      character ntap1*256, ntap2*256, otap*256, name*9

      logical verbos

c variables used with dynamic memory allocation

      integer abort, errcd1, errcd2, errcd3
      integer xplot_size, var_size

      real var1, var2, xplot

      pointer ( mem_xplot,xplot(2) )
      pointer ( mem_var1,var1(2) )
      pointer ( mem_var2,var2(2) )

c declare local variables

      integer luin1, luin2, lbytes1, lbytes2, length
      integer nsamp2, nsi2, ntrc2, nrec2
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer tr_index

      real var1_min, var1_max, var1_delta
      real var2_min, var2_max, var2_delta

      logical need_limits1, need_limits2

c initialize variables
 
      data name /'CROSSPLOT'/
      data luin / 1 /
      data luout / 2 /
      data lbytes / 0 /
      data nbytes / 0 /
      data obytes / 0 /
      data pipe/3/
      data need_limits1 /.false./
      data need_limits2 /.false./

c  get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help ()
         stop
      endif

c  open printout file

#include <f77/open.h>

c  get command line parameters

      call cmdln ( ntap1, ntap2, otap, irs, ire, 
     :     var1_min, var1_max, var1_delta, 
     :     var2_min, var2_max, var2_delta, verbos )

c open dataset one 

      call getln (luin1, ntap1, 'r', 0 )

c open dataset two

      if ( ntap2 .eq. ' ') then
     
         write(LERR,*)' '
         write(LERR,*)'assumed to be running inside ikp'
         write(LERR,*)' '
         call sisfdfit (luin2, pipe)
      else
         call getln (luin2, ntap2, 'r', 0 )
      endif
      
      if (luin2 .lt. 0) then
         length = lenth(ntap2)
	 if (length .gt. 0) then
           write(LERR,*)ntap2(1:length),' not accessible'
	 else
           write(LERR,*) '-N2 dataset not accessible'
	 endif
         write(LERR,*)'check existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)'CROSSPLOT:'
	 if (length .gt. 0) then
           write(LER,*) ntap2(1:length),' not accessible'
	 else
           write(LER,*) '-N2 dataset not accessible'
	 endif
         write(LER,*)' check existence and rerun'
         write(LER,*)'FATAL'
         stop
      endif

c open output dataset

      call getln (luout, otap,  'w', 1 )

c read line header of dataset 1

      lbytes1 = 0
      length = lenth(ntap1)
      call rtape ( luin1, itr1, lbytes1 )
      if(lbytes1 .eq. 0) then
         write(LERR,*)'CROSSPLOT:'
	 if (length .gt. 0) then
           write(LERR,*)' no line header read on ',ntap1(1:length)
	 else
           write(LERR,*)' no line header read on stdin'
         endif
         write(LERR,*)' Check file & rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'CROSSPLOT:'
	 if (length .gt. 0) then
           write(LER,*)' no line header read on ',ntap1(1:length)
	 else
           write(LER,*)' no line header read on stdin'
         endif
         write(LER,*)' Check file & rerun'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      write(LERR,*)' '
      write(LERR,*)' Historical Line Header from ',ntap1(1:length)
      write(LERR,*)' '
      call hlhprt ( itr1, lbytes1, name, 9, LERR )

c read line header of dataset 2

      lbytes2 = 0
      length = lenth(ntap2)
      call rtape ( luin2, itr2, lbytes2 )
      if(lbytes2 .eq. 0) then
         write(LERR,*)'CROSSPLOT: '
	 if (length .gt. 0) then
           write(LERR,*)' no line header read on  ',ntap2(1:length)
	 else
           write(LERR,*)' no line header read on -N2 pipe'
         endif
         write(LERR,*)'Check file & rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'CROSSPLOT: '
	 if (length .gt. 0) then
           write(LER,*)' no line header read on  ',ntap2(1:length)
	 else
           write(LERR,*)' no line header read on -N2 pipe'
         endif
         write(LER,*)'Check file & rerun'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      write(LERR,*)' '
      write(LERR,*)' Historical Line Header from ',ntap2(1:length)
      write(LERR,*)' '
      call hlhprt ( itr2, lbytes2, name, 9, LERR )

c  save key header values

      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)

      call saver(itr2, 'NumSmp', nsamp2, LINHED)
      call saver(itr2, 'SmpInt', nsi2  , LINHED)
      call saver(itr2, 'NumTrc', ntrc2 , LINHED)
      call saver(itr2, 'NumRec', nrec2 , LINHED)

c build pointers to trace header data

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c policemen to check data compatibility

      if ( nsamp .ne. nsamp2 ) then
        write(LERR,*)'Both data sets must have same trace length'
        write(LERR,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2' 
        write(LERR,*)'FATAL'
        write(LER,*)' '
        write(LER ,*)'CROSSPLOT:'
        write(LER ,*)' Both data sets must have same trace length'
        write(LER,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2' 
        write(LER,*)'FATAL'
        write(LER,*)' '
        stop
      endif

      if ( nrec .ne. nrec2 ) then
         write(LERR,*)'number of records mismatch'
         write(LERR,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'CROSSPLOT:'
         write(LER ,*)' number of records mismatch'
         write(LER,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      if( ntrc .ne. ntrc2 ) then
         write(LERR,*)'number of traces mismatch'
         write(LERR,*)'# trcs DSN1 = ',ntrc,' DSN2= ',ntrc2
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'CROSSPLOT:'
         write(LER ,*)' number of traces mismatch'
         write(LER,*)'# trcs DSN1 = ',ntrc,' DSN2= ',ntrc2
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

c update number of output traces

      if ( var2_min .ne. -99999. .and.
     :     var2_max .ne. -99999. .and.
     :     var2_delta .ne. -99999. ) then
         ntrco = nint ( ( var2_max - var2_min ) / var2_delta )
      else
         need_limits2 = .true.
         ntrco = ntrc2
      endif

      call savew( itr1, 'NumTrc', ntrco, LINHED)

c update number of output samples 

      if ( var1_min .ne. -99999. .and.
     :     var1_max .ne. -99999. .and.
     :     var1_delta .ne. -99999. ) then
         nsampo = nint ( ( var1_max - var1_min ) / var1_delta )
      else
         nsampo = nsamp
         need_limits1 = .true.
      endif
         
      call savew( itr1, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo

c update number of output records

      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1
      call savew( itr1, 'NumRec', nreco, LINHED)

c  update historical line header

      call savhlh ( itr1, lbytes1, lbyout )

c write output line header 

      call wrtape ( luout, itr1, lbyout )

c echo key parameters to printout file

      call verbal ( ntap1, nrec, ntrc, nsamp, nsi, 
     :     ntap2, nrec2, ntrc2, nsamp2, nsi2, 
     :     otap, nreco, ntrco, nsampo, irs, ire,
     :     var1_min, var1_max, var1_delta, 
     :     var2_min, var2_max, var2_delta, verbos )

c dynamic memory allocation

      xplot_size = ntrco * nsampo
      var_size = nsamp * ntrc

      call galloc ( mem_xplot, xplot_size * SZSMPD, errcd1, abort)
      call galloc ( mem_var1, var_size * SZSMPD, errcd2, abort)
      call galloc ( mem_var2, var_size * SZSMPD, errcd3, abort)

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*var_size + xplot_size * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*var_size + xplot_size * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*var_size + xplot_size * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( xplot, 1, xplot_size )
      call vclr ( var1, 1, var_size )
      call vclr ( var2, 1, var_size )

c skip to start record

      call recskp ( 1, irs-1, luin1, ntrc, itr1 )
      call recskp ( 1, irs-1, luin2, ntrc, itr2 )

      DO JJ = irs, ire

c load the data to be cross plotted

         tr_index = 1 - nsamp

         DO KK = 1, ntrc
            
            tr_index = tr_index + nsamp

            nbytes = 0
            call rtape  ( luin1 , itr1, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on ',ntap1
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov (itr1(ITHWP1), 1, var1(tr_index), 1, nsamp)

            nbytes = 0
            call rtape  ( luin2 , itr2, nbytes )
            if (nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on ',ntap2
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov (itr2(ITHWP1), 1, var2(tr_index), 1, nsamp)

         ENDDO

c find data limits for this record if not specified by user

         if ( need_limits1 ) then
            call FindLimits( nsamp, ntrc, nsampo, 
     :           var1, var1_min, var1_max, var1_delta )
         endif

         if ( need_limits2 ) then
            call FindLimits( nsamp, ntrc, ntrco, 
     :           var2, var2_min, var2_max, var2_delta )
         endif

         if ( need_limits1 .or. need_limits2 ) then
            write(LERR,*) ' '
            write(LERR,*) ' Rec ',JJ
            write(LERR,*) ' min1 = ',var1_min,' max1 = ',var1_max,
     :           ' delta1 = ',var1_delta
            write(LERR,*) ' min2 = ',var2_min,' max2 = ',var2_max,
     :           ' delta2 = ',var2_delta
            write(LERR,*) ' '
         endif

c build the cross plot histogram

         call vclr ( xplot, 1, xplot_size )

         call BuildCrossPlot ( nsampo, ntrco, xplot, nsamp, ntrc, 
     :        var1, var1_min, var1_max, var1_delta, 
     :        var2, var2_min, var2_max, var2_delta )

c output cross plot record

         tr_index = 1 - nsampo

         DO KK = 1,ntrco

            tr_index = tr_index + nsampo

            call savew2 (itr1, ifmt_RecNum, l_RecNum, ln_RecNum, JJ, 
     :          TRACEHEADER )
            call savew2 (itr1, ifmt_TrcNum, l_TrcNum, ln_TrcNum, KK, 
     :          TRACEHEADER )
            
            call vmov ( xplot(tr_index), 1, itr1(ITHWP1), 1, nsampo )
            call wrtape ( luout, itr1, obytes )

         ENDDO

      ENDDO

      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout)
      
      write(LERR,*)' Normal Termination'
      write(LER,*)' crossplot:  Normal Termination'
      stop

 999  continue

      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout)
      
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' crossplot:  Abnormal Termination'
      stop

      end
