C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap1, nrec, ntrc, nsamp, nsi, 
     :     ntap2, nrec2, ntrc2, nsamp2, nsi2, 
     :     otap, nreco, ntrco, nsampo, irs, ire,
     :     var1_min, var1_max, var1_delta, 
     :     var2_min, var2_max, var2_delta, verbos )

#include <f77/iounit.h>

      integer    nrec, ntrc, nsamp, nsi
      integer    nrec2, ntrc2, nsamp2, nsi2
      integer    irs, ire, nreco, ntrco, nsampo

      character  ntap1*(*), ntap2*(*), otap*(*)

      real var1_min, var1_max, var1_delta
      real var2_min, var2_max, var2_delta

      logical    verbos

c local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap1)
      if (length .gt. 0) then
        write(LERR,*) ' -N1 data set name     =  ', ntap1(1:length)
      else
        write(LERR,*) ' -N1 data set          =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      length = lenth(ntap2)
      if (length .gt. 0) then
        write(LERR,*) ' -N2 data set name     =  ', ntap2(1:length)
      else
        write(LERR,*) ' -N2 data set          =  pipe'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp2
      write(LERR,*) ' traces per record     =  ', ntrc2
      write(LERR,*) ' number of records     =  ', nrec2
      write(LERR,*) ' sample interval       =  ', nsi2
      write(LERR,*)' '
      write(LERR,*)' Output Line Header Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name    =  ', otap(1:length)
      else
        write(LERR,*) ' output data set name    =  stdout'
      endif
      write(LERR,*) ' samples per trace     =  ', nsampo
      write(LERR,*) ' traces per record     =  ', ntrco
      write(LERR,*) ' number of records     =  ', nreco
      write(LERR,*) ' sample interval       =  ', nsi

      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*)' '
      write(LERR,*) ' min1                    =  ', var1_min
      write(LERR,*) ' max1                    =  ', var1_max
      write(LERR,*) ' delta1                  =  ', var1_delta
      write(LERR,*)' '
      write(LERR,*) ' min2                    =  ', var2_min
      write(LERR,*) ' max2                    =  ', var2_max
      write(LERR,*) ' delta2                  =  ', var2_delta

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
