C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  dafd
C
C**********************************************************************C
C
C dafd READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES A USER-SPECIFIED FILTER-AGC, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, DAGC, ODD
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include     <localsys.h>
#include <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

      parameter   (mmax = 100)

      INTEGER     itr(SZLNHD)
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LUOUT,LBYTES,NBYTES,obytes
      integer     argis, ordfft
      REAL        xtr( SZLNHD ), gain (SZLNHD), tapers(SZLNHD)
      REAL        amp( SZLNHD ), phz( SZLNHD ), str( SZLNHD )
      real        coefs(2,32), wrk1(3), wrk2(96), wn(SZLNHD)
      real        freqs(100), weights(100), filtf(SZLNHD,100)
      real        alfa(100)
      integer     ifreqs(100), jseq(100)

      complex     work1 (2*SZLNHD), work2 (2*SZLNHD)
      complex     czero

      complex     datac(SZLNHD), datacf(SZLNHD)
      real        datar(SZLNHD), datarf(SZLNHD)

      integer     lsm
      real        pwr, pi, amps, expo, fst
      CHARACTER   NAME * 4, ntap * 256, otap * 256, file * 256
      CHARACTER   ftap * 256
#include     <f77/pid.h>
      logical     verbos,query,expon,inverse,wt,flat,decib,mute
      logical     gauss, boost, rho
 
c     EQUIVALENCE ( ITR(129), xtr(1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      EQUIVALENCE ( datac (1), datar (1) )
      EQUIVALENCE ( datacf(1), datarf(1) )
      DATA NAME     /'DAFD'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      DATA  amps / 307.05 /
      data verbos/.false./

c-------------------------------------
c  online help section
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif
c-------------------------------------

c---------------------------------------
c  open printout file
#include  <f77/open.h>
c---------------------------------------

      fl = 0.
      fh = 0.
      czero = cmplx (0.,0.)
      pi = 3.14159265
      do  j = 1, 100
          jseq(j) = j
      enddo
C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,ftap,ist,iend,nstr,nend,nrst,nred,
     1               fl,fh,pwr,verbos,expon,inverse,mute,luf,
     2               wt,freqs,weights,nfs,flat,decib,file,lufile,
     3               gauss,boost,nf,lw,aa,bb,cc,alfa1,alfa2,
     4               rho, fst, lsm, expo,fm,pwr1)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )


      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'DAFD: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 

      CALL HLHprt    ( ITR, LBYTES, NAME, 4,        LERR )

c-------------------------------------
c  alter sample interval if desired

         dt = real (nsi) * unitsc

      IF (rho) THEN
         nu  = ordfft (nsamp)
         N2  = 2 ** nu
         N3  = N2 / 2 + 1
         N6  = 2 * N3
         fnq = .5 / dt
         delf = fnq / float(n3-1)

      ELSE
         nu  = ordfft (nsamp)
         N   = 2 ** nu
         N22 = N/2
         N21 = N/2 + 1
      ENDIF

c-------------------------------------

c-------------------------------------
c  verbos printout of header values
      if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec 
         write(LERR,*) ' Format of Data     =  ', iform
      endif
c-------------------------------------

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      call cmdchk ( nstr, nend, nrst, nred, ntrc, nrec )

      if(fh .eq. 0) fh=.5 /dt
      fnyq = .5/dt
      df   = fnyq / float(N22-1)

      obytes = SZTRHD + SZSMPD * nsamp

c----------------------------------------------------
c  adjust line header, historical header & write it
      call savhlh ( itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )
c----------------------------------------------------

c----------------------------------------------
c  compute post dafd filters
      norder = 4

      if (fl .gt. fh) then
         write(LERR,*)' Cannot have low cut filter > hi cut'
         write(LERR,*)' Check command line args, correct, & rerun'
         stop
      endif

      if (wt) then
         if (fl .lt. 0.) fl   = .9 * freqs(1)
         if (fh .lt. 0.) fh   =1.2 * freqs(nfs)
         if (fh .gt. fnyq) fh = .9 * fnyq
      else
         if (fl .lt. 0.) fl   = 5.0
         if (fh .lt. 0.) fh   = .75 * fnyq
         if (fh .gt. fnyq) fh = .75 * fnyq
      endif
         
      jfl = fl / df + 1
      jfh = fh / df + 1

      call bwcoef ( fl, fh, dt, coefs, xnorm, norder, ift)
      write(LERR,*)'f1= ',fl,' f2= ',fh,'  gain= ',xnorm

c---------------------------------------------------------------------
c        compute gain curve
c---------------------------------------------------------------------
      call vfill (1.0, gain, 1, n21)


c=====
      IF ( gauss ) THEN

          lwin = lw / nsi
c---------------------------------------------------------
c   compute powers of 2
c   compute gaussian center frequencies
c   ... and set up alpha parameter for gaussian filters
c
          nu = ordfft (nsamp)
          nspad = 2 ** nu
          n21 = nspad/2 + 1
          if(alfa2 .ne. 0.) alfa1=0.
          fnyq = 1./(2.*dt)
          df   = fnyq /float(n21-1)
          nper = 0
          do   ii=1,nf
             ww = fmap(real(ii),aa,bb,cc)
c            ww = fl + delf * float(ii-1)
             if(ww.ge.fl .and. ww.le.fh) then
                nper=nper+1
                wn(nper)=ww
                alfa(nper) = alfa1 + alfa2 * ww*ww
             endif
          enddo
          nf=nper
          write(LERR,*)'nspad= ',nspad,' nsampo= ',nsampo
          write(LERR,*)'nper= ',nper,' df= ',df,' fft length= ',n21

c----------------------------------------------------------
c  compute gaussian filters & store in a matrix

          call vclr (amp, 1, n21)
          DO   jf =  1, nper
             fup = 1.50 * wn(jf)
             flo = .50 * wn(jf)
             if (flo .lt. 1.) flo = 1.0
             if (fup .gt. .9*fnyq) fup = .9*fnyq
             do   i = 1, n21
                f = df * float(i-1)
                if(f.ge.flo .and. f.le.fup) then
                    fltwt = exp( -alfa(jf) *
     1                                 ( (f-wn(jf))/wn(jf) )**2 )
                    if (fltwt .lt. 1.e-10) fltwt = 1.e-10
                    filtf(i,jf) = fltwt
                    amp (i) = amp (i) + fltwt
                else
                    filtf(i,jf) = 0.
                endif
             enddo
777          format(/)
          ENDDO

          call vclr (phz, 1, n21)
          do  jf = 1, nper

              iff = wn (jf) / df + 1
              fscl = 1 / amp(iff)
              fup = 1.50 * wn(jf)
              flo = .50 * wn(jf)
              if (flo .lt. 1.) flo = 1.0
              if (fup .gt. .9*fnyq) fup = .9*fnyq
              do   i = 1, n21
                   f = df * float(i-1)
                   if(f.ge.flo .and. f.le.fup) then
                       filtf(i,jf) = fscl * filtf(i,jf)
                       phz (i) = phz (i) + filtf(i,jf)
                       if (luf .gt. 0) write(luf,*)f,filtf(i,jf)
                   else
                       filtf(i,jf) = 0.
                   endif
              enddo
             if (luf .gt. 0) write(luf,777)
          enddo

          if (luf .gt. 0) then
             do  i = 1, n21
                 f = df * float(i-1)
                 write(luf,*)f,phz(i)
             enddo
          endif

	

c=====
      ELSEIF (rho) THEN
c=====

         lsm = lsm / nsi

c=====
      ELSE
c=====

c++++++++
         IF ( .not. flat) THEN

c--------
         IF (wt) THEN
c--------

            write(LERR,*)'freq'
            write(LERR,*)(freqs(i),i=1,nfs)
            do  i = 1, nfs
                ifreqs(i)  = freqs(i) / df + 1
                freqs(i)   = ifreqs(i) - 1.0
                if (decib) then
                   weights(i) = 10. ** (weights(i)/20.)
                endif
            enddo

            call sort (ifreqs, jseq, nfs)

            do  j = 1, nfs
                xtr  (j) = freqs  (jseq(j))
                gain (j) = weights(jseq(j))
            enddo
            do  j = 1, nfs
                freqs  (j) = xtr  (j) 
                weights(j) = gain (j)
            enddo
            write(LERR,*)(ifreqs(i),i=1,nfs)
            write(LERR,*)'wt'
            write(LERR,*)(weights(i),i=1,nfs)
             
            do  i = 1, nfs-1

                wtl = weights(i)
                wth = weights(i+1)
                ffl = freqs(i)
                ffh = freqs(i+1)
                ifl = ifreqs(i)
                ifh = ifreqs(i+1)
                delf = (ffh - ffl)
             
                do  if = ifl, ifh-1
                    ff = if
                    gain(if) = wtl + (ff - ffl) * (wth - wtl) / delf
                enddo
                if (i .eq. (nfs-1)) then
                   gain(ifh) = wth
                endif

            enddo

            write(LERR,*)'Complete gain curve'
            do  i = 1, N21
                    write(LERR,*)'i= ',i,'  g= ',gain(i)
            enddo

            do  i = 1, ifl1

                k = ifhh+ifll - i
                fac = .5 * (1. + cos (pi* float(ifl1-i+1)/ifl1 ) )
                gain (i) = gain (i) * fac
                gain (k) = gain (k) * fac
            enddo
           

c--------
         ELSEIF (boost) THEN
c--------

            ifm = int( fm * float(N21) / fnyq)
            if (ifm .eq. 0) ifm = 1
            if (expon) then
 
               do 11 i = ifm, N21
                  x =  exp (float(i-ifm) * dt * pwr )
                  gain(i) = x
   11          continue
               if (ifm .gt. 1) then
                  do  i = 1, ifm-1
                      x =  exp (float(ifm-i) * dt * pwr1 )
                      gain(i) = x
                  enddo
               endif
 
            else
 
               do 10 i = ifm, N21
                  x = ( float(i-ifm) ) ** pwr
                  gain(i) = x + 1
   10          continue
               if (ifm .gt. 1) then
                  do  i = 1, ifm-1
                      x =  ( float(ifm-i) ) ** pwr
                      gain(i) = x + 1
                  enddo
               endif
 
            endif

c--------
         ENDIF
c--------

         if (inverse) call vrecip (gain, 1, gain, 1, N21)
         ENDIF
c++++++++

      ENDIF
c=====

      call vfill (1.0, tapers, 1, nsamp)
      ntp = .05 * nsamp

      do  15  i = 1, ntp

          fac = .5 * (1. + cos (pi*float(ntp-i+1)/ntp))
          tapers(i) = fac
          tapers(nsamp-i+1) = fac
15    continue

c----------------------------------------------
c  printout of modified header values etc
         write(LERR,*)
         write(LERR,*)' Line header values after default check '
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*)  ' Sample Interval (ms)=  ',dt
         write(LERR,*)  ' Freq Interval (Hz)  =  ',df

         IF (.not. flat .AND. .not. rho) THEN
         write(LERR,*)  ' Inverse gain curve?    ',inverse
         if (wt) then
            do i = 1, nfs
               write(LERR,*)  '  freq = ',freqs(i),ifreqs(i),
     1                        '  weight = ',weights(i)
            enddo
         elseif (gauss) then
         write(LERR,*)  ' agc of gaussian narrow band filters'
         do i = 1, nper
         write(LERR,*)'freq= ',wn(i),'   alpha= ',alfa(i)
         enddo
         else
         write(LERR,*)  ' Freq weighting about center frequency'
         write(LERR,*)  ' Exponent (incr freq)          =  ', pwr
         write(LERR,*)  ' Exponent (decr freq)          =  ', pwr1
         write(LERR,*)  ' Center frequency    =  ',fm
         if (boost) then
         if (expon) then
         write(LERR,*)  ' using exponential boost: exp(pwr*f)'
         else
         write(LERR,*)  ' using power function boost: f**pwr'
         endif
         endif
         write(LERR,*)  ' Gain Curve'
         write(LERR,*)  (gain(i),i=1,n21)
         endif
         ELSEIF (rho) THEN
         write(LERR,*)  ' rho filter option'
         write(LERR,*)  'Length of smoothing window = ',lsm,' (samps)'
         write(LERR,*)  'Exponent                   = ',expo
         write(LERR,*)  'First frequency            = ',fst
         write(LERR,*)  'Inverse gain curve?    ',inverse
         ELSE
         write(LERR,*)  ' Gain Curve'
         write(LERR,*)  (gain(i),i=1,n21)
         ENDIF

         write(LERR,*)  ' Taper'
         write(LERR,*)  (tapers(i),i=1,nsamp)
c----------------------------------------------

c--------------------------------------

C**********************************************************************C
C
C     READ TRACE, FILTER-AGC-SUM, WRITE TO OUTPUT FILE
C
C**********************************************************************C
      init = 1


      DO 100 JJ = 1, nrec

           DO 99 KK = 1, NTRC

               nbytes = 0
               call vclr (xtr, 1, N)
               CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic , TRACEHEADER)
 
               IF (JJ .ge. nrst .and. JJ .le. nred .AND.
     1             KK .ge. nstr .and. KK .le. nend) THEN

c------------------
c  detect mute zone
                  call detmut ( xtr, im, nsamp)

                  call vmul   (tapers, 1, xtr, 1, xtr, 1, nsamp)
                  call cvfill (czero, work1, 2, N)
                  call cvfill (czero, work2, 2, N)

                  if(istatic .ne. 30000) then

                     call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           irec , TRACEHEADER)

c------------------
c  determine trace
c  level; check for
c  dead trc
c  save live input
                     call dotpr (xtr, 1, xtr, 1, xmax, nsamp)
                     if (xmax .ne. 0.0) then
                           call vmov (xtr, 1, str, 1, nsamp)
                     else
                        go to 88
                     endif


                     IF ( gauss ) THEN

                        call cvfill (czero, datac, 1, nspad)
                        call vmov   (xtr, 1, datac, 1, nsamp)
                        call rfft   (datac, nspad, 1)
                        call rfftsc (datac, nspad, 3, 1)
                        do  jf = 1, nf
                            do  ii = 1, n21
                                datacf (ii) = filtf (ii,jf) * datac (ii)
                            enddo
                            call rfftsc (datacf, nspad, -3, 0)
                            call rfft   (datacf, nspad, -1)
                            call dagcab (datarf,gain,nsamp,lwin,amps)
                            do  ii = 1, nsamp
                                xtr (ii) = xtr (ii) + 
     1                                     datarf (ii) * gain (ii)
                            enddo
                            call cvfill (czero, datacf, 1, nspad)
                        enddo
                        call vclr   (xtr(nsamp), 1, nspad-nsamp+1)

                     ELSEIF (rho) THEN

                        call rhof (xtr, nsamp, n2, n3, n6, work1, delf,
     1                            expo, fst, lsm, ierr)
                        call vmov (work1, 1, xtr, 1, nsamp)

                     ELSE

                        call rfftb  (xtr, work1, N, +1)
                        call rfftsc (work1, N, 3, 1)
                        call cvabs  (work1, 2, amp, 1, n21)
                        call cvphas (work1, 2, phz, 1, n21)
                        IF (flat) THEN
                           do  i = 1, n21
                               amp(i) = 1.0
                           enddo
                        ELSE
                           do  i = 1, n21
                               amp(i) = amp(i) * gain (i)
                           enddo
                        ENDIF

                        call cvmexp (phz, 1, amp, 1, work2, 2, n21)

                        call rfftsc (work2, N, -3, 0)
                        call rffti  (work2, xtr, N)
                        call vclr   (xtr(nsamp), 1, N-nsamp+1)

                     ENDIF

                    call vclr (wrk1, 1, 3)
                    call vclr (wrk2, 1, 96)

                    call bwfilt ( xtr, xtr, wrk1, wrk2, coefs,
     1                            xnorm, norder, nsamp, init, 0)
                    init = 0
                    call vrvrs (xtr,  1, nsamp)
                    call bwfilt ( xtr, xtr, wrk1, wrk2, coefs,
     1                            xnorm, norder, nsamp, init, 0)
                    call vrvrs (xtr,  1, nsamp)


c------------------
c  restore trace
c  level
                    call scaleh (str, nsamp, xtr, lsm, ierr, LERR,
     1                           SZSMPD, 0, nsi, lwin, amps)
c------------------
c  reapply zone
                    if (.not. mute)
     1              call resmut (xtr, im, nsamp)

                  endif

               ENDIF
               call vmov (xtr, 1, lhed(ITHWP1),1, nsamp)

   88          continue

               call wrtape(luout,itr,nbytes)
 
   99      CONTINUE
           if(verbos) then
             write(LERR,*)'Finished DAFD on record  ',irec
           endif
  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END

c------------------------------------
c  online help section
c------------------------------------
      subroutine  help
#include  <f77/iounit.h>
                                                        
        write(LER,*)'Here Are the Command Line Parameters for DAFD'
        write(LER,*)'               -- local true amp dafd'
        write(LER,*)' '
        write(LER,*)'Input........................................(def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name          (stdin)'
        write(LER,*)'-O[otap]   -- output data set name        (stdout)'
        write(LER,*)'-ns[nstr]  -- start process trace #     (first tr)'
        write(LER,*)'-ne[netr]  -- end process trace #        (last tr)'
        write(LER,*)'-rs[nrst]  -- start process record     (first rec)'
        write(LER,*)'-re[nred]  -- end process record        (last rec)'
        write(LER,*)' '
        write(LER,*)'There are 3 boost modes:'
        write(LER,*)'1) power curve in frequency, or'
        write(LER,*)'2) frequency-weight pairs (see man page), or'
        write(LER,*)'3) flatten amplitude spectrum'
        write(LER,*)' '
        write(LER,*)'Mode 0:'
        write(LER,*)'              [ for ormsby comb see program dctvf]'
        write(LER,*)'-G         -- gaussian filter comb + agc/stack'
        write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)           ( 5 )'
        write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz)    (.7 Nyquist)'
        write(LER,*)'-nf[nf]    -- number freq bins              ( 25 )'
        write(LER,*)'-wl[lw]    -- length of agc window         ( 500 )'
        write(LER,*)'-ff[ftap]  -- opt output filter file name (ignore)'
        write(LER,*)'              [file is in xgraph format]'
        write(LER,*)' '
        write(LER,*)'Mode 1:'
        write(LER,*)'-exp[pwr]  -- increasing freq boost  (linear ramp)'
        write(LER,*)'-fxp[pwr1] -- decreasing freq boost         (flat)'
        write(LER,*)'-E         -- do exp(pwr*f)'
        write(LER,*)'-P         -- do f**pwr boost'
        write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)           ( 5 )'
        write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz)    (.7 Nyquist)'
        write(LER,*)'-fm[fm]    -- freq to hang boost             ( 0 )'
        write(LER,*)' '
        write(LER,*)'Mode 2:'
        write(LER,*)'-W         -- do designer boost'
        write(LER,*)'-D         -- weights in db'
        write(LER,*)'-wf[file]  -- file of freq-weight pairs, or...'
        write(LER,*)'              ...optional cmd line input...'
        write(LER,*)'-fr[freq]  -- frequency control point (Hz)'
        write(LER,*)'-wt[weight]-- amount to weight at above freq'
        write(LER,*)'-fr[freq]  -- frequency control point (Hz)'
        write(LER,*)'-wt[weight]-- amount to weight at above freq'
        write(LER,*)'          ...'
        write(LER,*)'          ...'
        write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)   ( .9 fr(1) )'
        write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz) (1.2 fr(last))'
        write(LER,*)' '
        write(LER,*)'Mode 3:'
        write(LER,*)'-F         -- if present flatten the ampl spectra'
        write(LER,*)'              between -fl[] and -fh[]'
        write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)           ( 2 )'
        write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz)    (.7 Nyquist)'
        write(LER,*)' '
        write(LER,*)'Mode 4:'
        write(LER,*)'-R         -- if present use rho filter method'
        write(LER,*)'              between -fl[] and -fh[]'
        write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)           ( 2 )'
        write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz)    (.7 Nyquist)'
        write(LER,*)'-sm[sm]    -- envelope smooth window ms      (200)'
        write(LER,*)'-sf[sf]    -- first frequency to use Hz        (0)'
        write(LER,*)'-ep[ep]    -- envelope power function        (1.8)'
        write(LER,*)' '
        write(LER,*)'-I         -- do inverse of modes 1, 2, or 4'
        write(LER,*)'-M         -- do not restore mute'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)'dafd -N[] -O[] -ns[] -ne[] -rs[] -re[] -fl[] -fh[]'
        write(LER,*)'   [ [ -G -wl[] -nf[] -ff[] ]'
        write(LER,*)'     [ -E -P -exp[] -fxp[] ] -fm[] ]'
        write(LER,*)'     [ -W -D [-wf[]] [-fr[] -wt[] ... -fr[] -wt[]]'
        write(LER,*)'     [ -F ] [-sm[] -sf[] -ep[]'
        write(LER,*)'   ]'
        write(LER,*)'   [ -I -M -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c    nstr   - I      start trace
c    nend   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c   fl, fh  - R      lo & hi cut freqs
c     exp   - R      exponent
c    expon  - L      exponential vs power
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ftap,ist,iend,nstr,nend,nrst,nred,
     1               fl,fh,pwr,verbos,expon,inverse,mute,luf,
     2               wt,freqs,weights,nfs,flat,decib,file,lufile,
     3               gauss,boost,nf,lw,aa,bb,cc,alfa1,alfa2,
     4               rho, fst, lsm, expo, fm, pwr1)
#include    <f77/iounit.h>
      character  ntap*(*), otap*(*), file*(*), ftap*(*)
      character  card * 80
      integer    ist,iend,nstr,nend,nrst,nred,lsm
      integer    argis
      real       pwr,fl,fh,aa,bb,cc,expo,fm
      real       freqs(*), weights(*)
      logical    verbos, expon, inverse, wt, flat, decib, mute
      logical    gauss, boost, power, rho

      call alloclun (lufile)

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argstr('-ff',ftap,' ',' ')
          call argstr('-wf',file,' ',' ')
          ist = 1
          iend = 0
          call argi4('-ns',nstr,0,0)
          call argi4('-ne',nend,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argr4('-fl',fl,5.,5.)
          call argr4('-fh',fh,-1.,-1.)
          call argi4('-nf',nf,25,25)
          call argi4('-wl',lw,500,500)

          call argr4('-aa',aa,5.,5.)
          call argr4('-bb',bb,4.,4.)
          call argr4('-cc',cc,-5.,-5.)
          call argr4('-a1',alfa1,50.27,50.27)
          call argr4('-a2',alfa2,.05,.05)

          call argi4('-sm',lsm,200,200)
          call argr4('-sf',fst,0.0,0.0)
          call argr4('-ep',expo,1.8,1.8)

          wt      = ( argis( '-W' ) .gt. 0 )
          IF (wt) THEN

             if (file(1:1) .eq. ' ') then

                do  i = 1, 100
                    call argr4 ('-fr',   freqs(i), -1., -1.)
                    if (freqs(i) .lt. 0) then
                       nfs = i - 1
                       go to 1
                    endif
                    call argr4 ('-wt', weights(i), 0., 0.)
                enddo

             else

                open (unit=lufile,file=file,status='old',iostat=ierr)
                if (ierr .ne. 0) then
                   write(LERR,*)'Could not open weights file ',file
                   write(LERR,*)'Check existence'
                   write(LER ,*)'Could not open weights file ',file
                   write(LER ,*)'Check existence'
                   stop
                endif
                rewind lufile
                do  j = 1, 10000
                    read (lufile, '(a80)', end = 10) card
                    nfs = j
                enddo
10              continue
                rewind lufile
                do  j = 1, nfs
                    read (lufile, '(a80)') card
                    call fsscnf (card,'%f %f',freqs(j),weights(j))
                enddo

             endif

          ENDIF
1         continue

          boost = .false.
          call argr4('-exp',pwr,0.,0.)
          call argr4('-fxp',pwr1,0.,0.)
          call argr4('-fm',fm,0.,0.)
          gauss   = ( argis( '-G' ) .gt. 0 )
          rho     = ( argis( '-R' ) .gt. 0 )
          power   = ( argis( '-P' ) .gt. 0 )
          expon   = ( argis( '-E' ) .gt. 0 )
          inverse = ( argis( '-I' ) .gt. 0 )
          flat    = ( argis( '-F' ) .gt. 0 )
          decib   = ( argis( '-D' ) .gt. 0 )
          mute    = ( argis( '-M' ) .gt. 0 )
          verbos  = ( argis( '-V' ) .gt. 0 )

          if (power .OR. expon) boost = .true.

          if (.not.flat .AND. .not.wt .AND. .not.boost 
     1        .AND. .not.rho) gauss = .true.

          IF ( gauss ) THEN

             if (nf .gt. 100) then
                write(LER,*)'WARNING in Gaussian option:'
                write(LER,*)'Cannot have number freqs > 100.'
                write(LER,*)'Reset to 100'
                nf = 100
             endif
             if (inverse) then
                write(LER,*)'dafd FATA ERROR for gaussian option:'
                write(LER,*)'Cannot use inverse -I operation'
                stop
             endif

             if (ftap(1:1) .ne. ' ') then
                call alloclun (luf)
                open (unit=luf,file=ftap,status='unknown',iostat=ierr)
                if (ierr .ne. 0) then
                write(LERR,*)'FATAL ERROR: gauss option:'
                write(LERR,*)'Could not open output filter file ',ftap
                write(LERR,*)'Check permissions'
                write(LER ,*)'FATAL ERROR: gauss option:'
                write(LER ,*)'Could not open output filter file ',ftap
                write(LER ,*)'Check permissions'
                stop
                endif
             else
                luf = -1
             endif

          ENDIF

          IF ( boost ) THEN

c         if (nf .gt. 100) then
c            write(LER,*)'WARNING in Gaussian option:'
c            write(LER,*)'Cannot have number freqs > 100. Reset to 100'
c         endif

          ELSE

          if (flat .and. wt) then
             write(LER,*)'dafd FATAL ERROR'
             write(LER,*)'Cannot have both flat and weight options'
             write(LER,*)'Choose one or the other and rerun'
             stop
          endif
          if (wt .and. nfs .lt. 2) then
             write(LER,*)'dafd FATAL ERROR'
             write(LER,*)'Must have at least 2 freq points to define'
             write(LER,*)'a straight line'
             stop
          endif
          if (flat .and. inverse) then
             write(LER,*)'dafd FATAL ERROR'
             write(LER,*)'Cannot restore from previously flattened'
             write(LER,*)'amplitude spectrum'
             stop
          endif
          if (rho .and. inverse) then
             if(expo .eq. 1.0) then
                write(LER,*)'dafd WARNING: rho inverse option--'
                write(LER,*)'exponent defaults to -1.0.  Make sure'
                write(LER,*)'forward run used default exponent (1.0)'
                expo = -1.0
             endif
             if (fst .eq. 0.0) then
                write(LER,*)'dafd WARNING: rho inverse option--'
                write(LER,*)'First frequency can not be 0.0. Will'
                write(LER,*)'reset to 1.0 Hz'
                fst = 1.0
             endif
          endif
          ENDIF

      return
      end
        function fmap(x,aa,bb,cc)
                real*4 fmap
                real*4 x
                real*4 aa,bb,cc
c-----
c       this general function defines the mapping between
c       array index I and the center frequency of the
c gaussian filter
c
c       changing this routine will change the frequency sampling
c       throughout the program
c-----
        fmap = aa + bb*x + cc*alog10(x)
        return
        end

