CC   ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DAGCSQ( A, G, N, LW, AMP )
C
C       where
C
C       A       Real input vector of input data trace.
C
C       G       Real output vector of gain trace.
C
C       N       Integer input number of elements in vectors A and G.
C
C       LW      Integer input length of window used to calculate gains.
C               LW must be odd.
C
C       AMP     Real input scalar that defines the desired level to maintain.
C
C
C  DESCRIPTION:
C
C       This routine computes a gain trace for a digital automatic gain
C       control. A window of length LW is moved through the data vector to
C       calculate the gain vector.
C
C       The elements of the vector are computed by:
C
C               G(i) = AMP / SQRT( SUM( A(j)**2 ) / LW )
C
C               where  SUM( A(j)**2 ) = the sum of of the squares of LW
C                      values of A centered about the i'th element of A.
C
C       Special calculations for the gain are done for the starting and
C       ending values.
C
C       If LW is not odd, the routine will return without updating G.
C
C
C  REFERENCES:
C
C       NONE
C
C
C  EXAMPLE:
C
C       CALL DAGCSQ( A, G, 10, 3, 15.0 )
C
C       INPUT OPERANDS:
C
C       A  =      0.0
C                10.0
C                20.0
C                10.0
C                 0.0
C               -10.0
C               -20.0
C               -10.0
C                 0.0
C                 9.0
C
C
C       OUTPUT OPERANDS:
C
C       G  =    2.12131929
C               1.16189492
C               1.06066000
C               1.16189492
C               1.83711672
C               1.16189492
C               1.06066000
C               1.16189492
C               1.93113422
C               2.35702085
C
C
C  SUBPROGRAMS:
C
C       INTRINSICS:     SQRT
C
C
C  HISTORY:
C       1) May 1988          P. G. Crose                          Original
C
C----------------------------------------------------------------------------
C
        SUBROUTINE DAGCSQ( A, G, N, LW, AMP )
C
        INTEGER N, LW
        REAL A(1), G(1), AMP
C
        REAL SUM
        REAL DUM1, DUM2
        INTEGER I, ISTA, ISTO, J, K, LWD2, LWD2P1, IFACT
	REAL TOLZ
        PARAMETER ( TOLZ = 1.0E-30 )
C
C----------------------------------------------------------------------------
C
C
c        SUM = 0.0001
c I can see no reason for this initialization of sum with some non-zero
c number.  I have taken this out, tested with several types of files
c and am releasing the updated version today.....Apr 8/96 - zpgg07

        SUM = 0.0
        LWD2 = LW/2
        ISTO = LWD2 + 1
        DO 1 I = 1, ISTO
            SUM = SUM + ( A(I)**2 )
  1     CONTINUE
        IF ( SUM .GT. TOLZ ) THEN
                G(1) =  AMP / SQRT( SUM / ISTO )
        ELSE
                G(1) = 0.0
        ENDIF
C
        DO 2 I = 2, ISTO
                J = LWD2 + I
                SUM = SUM + ( A( J )**2 )
                IF ( SUM .GT. TOLZ ) THEN
                    G(I) = AMP / SQRT( SUM / FLOAT(J) )
                ELSE
                    G(I) = 0.0
                ENDIF
  2     CONTINUE
C
        ISTA = ISTO + 1
        ISTO = N - LWD2
        LWD2P1 = LWD2 + 1
C
        DO 3 I = ISTA, ISTO
                J = I - LWD2P1
                K = I + LWD2
                DUM1 = A( K )**2
                DUM2 = A( J )**2
                SUM = SUM + ( DUM1 ) - ( DUM2 )
                    IF ( SUM .GT. TOLZ ) THEN
                        G(I) =  AMP / SQRT( SUM / FLOAT( LW ) )
                    ELSE
                        G(I) = 0.0
                    ENDIF
  3     CONTINUE
C
        ISTA = ISTO + 1
        IFACT = LW + ISTA - 1
C
        DO 4 I = ISTA, N
                J = I - LWD2P1
                SUM = SUM - ( A(J)**2 )
                IF ( SUM .GT. TOLZ ) THEN
                    G(I) = AMP / SQRT( SUM / FLOAT( IFACT - I ) )
                ELSE
                    G(I) = 0.0
                ENDIF
  4     CONTINUE
C
        RETURN
        END
