C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C   PROGRAM DATUM  -  EXTRAPOLATES RECEIVER WAVEFIELDS DOWN AND UP
C
C
c-----------------------------------------------------------------------
c     PARAMETER( NTRR   =250, NSAMP =1000 , jrays =180)
      PARAMETER( NTRR   =1000, jrays =180)
      PARAMETER( KMAX   =1000,   nzeta =1000)
c-----------------------------------------------------------------------
c
#include  <save_defs.h>
#include  <f77/iounit.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
c-----------------------------------------------------------------------
c
      REAL          DVDXZ (0:nzeta, Kmax)
c     REAL         c(1001,2500),data(3000)
      REAL         c,data(3000)
      pointer (caddr,c(1001,1))
      REAL        U    (0:3000 ), ZEROV( Kmax )
      REAL        ZETT (0:1000  ), TAU  (-jrays:jrays)
c     REAL        xxx  (-jrays:jrays, Kmax), ttt  (-jrays:jrays, Kmax)
      REAL        xxx,ttt
      pointer (xxxadr,xxx(-jrays:jrays,1))
      pointer (tttadr,ttt(-jrays:jrays,1))
      REAL        XP   (-jrays:jrays), SLOWX(-jrays:jrays)
      dimension   livray(-jrays:jrays), iloc(Kmax)
      REAL        P    (-jrays:jrays), SLOWZ(-jrays: jrays)
      REAL        V    ( Kmax  ), DVDX ( Kmax )
      REAL        SQRR (0:5000 ), UDATUM (0:3000,Kmax )
      INTEGER     LHED ( 3000  )
      INTEGER     ITR  ( 6128 ), IHEADR(128 , ntrr  )
      dimension   VZ(0:nzeta,Kmax), iflag(Kmax)
      CHARACTER * 2  arrr(10), arrs(10),   down, up
        character ntap * 120, otap * 120 ,jobname * 120 ,name * 5, grp*4
      character line*120
      character vtap * 120
C
      logical verbos, query, vdatum, post
      integer argis
      integer istatic,usgntd
      integer indx, pipe
      integer ierr,iabort
      pointer(indxpt,indx(SZSPRD,1))
c     EQUIVALENCE ( ITR(129), U   (1) )
c     EQUIVALENCE ( ITR(129), DATA(1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      COMMON/VBLOCK/DXGRID,DZGRID,NXGRID
      COMMON/PARAMS/  NREC,  NT, TMAX,
     :                FMAX, IREV,
     :                NZDATM, NXGRP, NRAY,
     :                DIPMAX, SINMAX, DIPFIL, jflag ,jxgrp0
      DATA  lu8 , lu10, LU44, LU55, LU77
     :    /   8 ,   10,   44,   55,   77  /
      DATA PI / 3.141592 /
      DATA name /'DATUM' /
      DATA pipe/3/
      DATA iabort / 0 /

C-----------------------------------------------------------------------
C
C      get online help
C
C-----------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
            call help()
            stop
      end if

c-----------------------------------------------------------------------
C
C      open printout file for output
C
C-----------------------------------------------------------------------
#include <f77/open.h>

c-----------------------------------------------------------------------
c
      call galloc(caddr,1001*250*SZSMPD,ierr,iabort)
      if (ierr .ne. 0) then
        write(LERR,10) 1001*250
        stop
      endif
c
      call galloc(xxxadr,(2*jrays+1)*kmax*SZSMPD,ierr,iabort)
      if (ierr .ne. 0) then
        write(LERR,10) (2*jrays+1)*kmax
        stop
      endif
c
      call galloc(tttadr,(2*jrays+1)*kmax*SZSMPD,ierr,iabort)
      if (ierr .ne. 0) then
        write(LERR,10) (2*jrays+1)*kmax
        stop
      endif
   10 format(' DATUM: memory allocation failed: attempted to get ',
     1     i7,' words ',/,' FATAL')

C
      call gcmdln (ntap, otap, ns, ne, irs, ire, tmax, tzero, vmute,
     :	fmax, nzdatm,  nray, ints, itaper, grpint,
     :	dipmax, dipfil, irev, jflag, jxgrp0, verbos,
     :	nxave,nzave,vtap,post,vdatum,geom)
c -					inserted 8/01/90 j.m.wade
c     vdatum = (argis('-VAR').gt.0)
C-----------------------------------------------------------------------
C
C      get logical unit numbers for input and output
C
C-----------------------------------------------------------------------
      call getln (luin,  ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
c
c - I assume this is supposed to be vtap rather than vmod  - j.m.wade 8/21/92
c     if (vmod .ne. ' ') then
c
      if (vtap .ne. ' ') then
          call getln (luin2, vtap, 'r', 0 )
      else
          write(LERR,*)'datumt5 assumed to be running inside IKP'
          call sisfdfit (luin2, pipe)
      endif
      if  (luin2 .lt. 0)   then
           write(LERR,*)'datumt5 error: velocity file -v not accessible'
      endif

C-----------------------------------------------------------------------
C
C      read lineheader and save key values
C
C-----------------------------------------------------------------------
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if (lbytes .eq. 0) then
            write(LOT, *)'DATUM: no header read from unit ', luin
            write(LOT, *)'FATAL'
            stop
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RfSrEl',ifmt_RfSrEl,l_RfSrEl,ln_RfSrEl,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)

      call savelh(itr,nsamp,nsi,ntrc,nrec,iform)
            call argi4('-a', nap2, ntrc, ntrc)
C-----------------------------------------------------------------------
C
C      verify command line parameters
C
C-----------------------------------------------------------------------
      call cmdchk ( ns, ne, irs, ire, ntrc, nrec )
c      write(33,*)' ns  ',ns,' ne  ', ne, ' irs  ', irs, ' ire  ', ire
C-----------------------------------------------------------------------
C
C      modify lineheader to agree with command line arguments
C
C-----------------------------------------------------------------------
      nrecc = ire -irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr = ne - ns + 1
      ntrace = jtr
      call savew(itr, 'NumTrc', jtr,   LINHED)
      call savhlh(itr, lbytes, lbyout )
      CALL WRTAPE ( LUOUT, ITR, lbyout                      )
C-----------------------------------------------------------------------
C
C     read velocity tape parameters
C
C-----------------------------------------------------------------------
      lbytes = 0
      call rtape(luin2,itr,lbytes)
      call saveh(itr,mzeta,lmax,mrec,dxgrid,dzgrid)
C-----------------------------------------------------------------------
C
C     set parameters
C
C-----------------------------------------------------------------------
      dipmax = pi * dipmax/180.
      sinmax = amin1( sin (dipmax), .9999)
      if (nray .gt. jrays) nray = jrays
      NRAY1      = NRAY + 1
      NTRCP1     = NTRACE + 1
      if(jflag .eq. 0) jflag = 1
      dt = float( nsi) / 1000.
      ntime = nsamp
      jmax = mrec * lmax
      nxgrid = jmax
      eps = 0.01 * grpint
      tmax = dt * float( nsamp - 1 )
      scale = 1.0 / dt
      if (itaper .gt. (ne - ns )/ 2 - 1 ) itaper = ( ne - ns)/ 2 + 1
C-----------------------------------------------------------------------
C
C     SET DIP LIMITS
C
      SINMAX = AMIN1(SIN(DIPMAX),.9999)
C-----------------------------------------------------------------------
C
C     COMPUTE SQUARE ROOT TABLE
C
      DO 20 JARG = 0,5000
        SQRR(JARG) = SQRT(JARG/5000.)
20    CONTINUE
C-----------------------------------------------------------------------
c
      call galloc(indxpt,SZSPRD*lmax*SZSMPD,ierr,iabort)
      if (ierr .ne. 0) then
        write(LOT,10) SZSPRD*lmax
        stop
      endif
C-----------------------------------------------------------------------
c     read velocity data
c
      do 1090 jj=1,mrec
        do 209 kk = 1,lmax
          nbytes = 0
          call rtape(luin2,itr,nbytes)
          call vmov (itr(ITHWP1), 1, U, 1, mzeta)
          if (vdatum) then 
c           indx(jj,kk) = itr(124) - 1
c           call saver(itr,'RfSrEl',indx(jj,kk),1)
            call saver2(lhed,ifmt_RfSrEl,l_RfSrEl, ln_RfSrEl,
     1                  irfsrel, TRACEHEADER)
            indx(jj,kk) = irfsrel - 1

            indx(jj,kk) = max(1,indx(jj,kk))
            indx(jj,kk) = min(indx(jj,kk),mzeta)
          endif
          call vmov(data,1,c(1,((jj-1)*ntrc)+kk),1,mzeta)
  209   continue
 1090 continue
c
c
      call smoot(c,mzeta,lmax,dxgrid,dzgrid,data,zett,vz,
     1     dvdxz,nxave,nzave,zerov,czero)
c
      if (vdatum) then
        do 1095 jj=1,mrec
          do 2090 kk=1,lmax
            ijk = ((jj-1)*lmax) + kk
            mm = indx(jj,kk) + 1
            nn = mzeta-mm
            call vclr(vz(mm,ijk),1,nn)
            call vclr(dvdxz(mm,ijk),1,nn)
 2090     continue
 1095   continue
      endif
C-----------------------------------------------------------------------
C
C     INITIALIZE NO/YES (0/1) FLAG WHICH TELLS WHETHER RAYS HAVE
C     BEEN COMPUTED FROM GROUP LOCATION JXGRP
C
C-----------------------------------------------------------------------
      DO 120 ii = 1, jmax
        IFLAG(ii) = 0
120   CONTINUE
C-----------------------------------------------------------------------
C
C     COMPUTE DIMENSIONLESS HORIZONTAL RAY PARAMETERS P =
C     SIN(EMERGENCE ANGLE) FOR LATERALLY AVERAGED VELOCITY MODEL.
C     THESE WILL BE CONVERTED TO HORIZONTAL
C     SLOWNESS (SLOWX = P/C(X,0) AT Z = 0).
C
C-----------------------------------------------------------------------
C
      xgrp = ints* grpint	
      CALL RAYS(NRAY1,CZERO,FMAX,DIPFIL,P,PMAX,xgrp,SINMAX)
C
C-----------------------------------------------------------------------
C
C      verbose listing of parameters
C
C-----------------------------------------------------------------------
      if (verbos) then
        call verbal(nsamp, nsi, ntrc, nrec, iform, grpint,
     :     ntap,otap,tmax,f1,f2,f3,f4,nzdatm,jmax,nray,dipmax,
     :     dipfil,irev,jflag,dxgrid,dzgrid,mzeta,vdatum,post,geom)
      end if
C-----------------------------------------------------------------------
C
C       skip unwanted records
C
       call recskp(1, irs - 1, luin, ntrc, itr)
C-----------------------------------------------------------------------
C
C-----START LOOP TO PROCESS GROUP LOCATIONS SEQUENTIALLY
C
      DO 450 IREC = irs, ire
        write (LERR, * )' PROCESSING RECORD' ,IREC
C-----------------------------------------------------------------------
C
C       INITIALIZE OUTPUT ARRAY UDATUM.
C
          DO 160 JXII = 1,jmax
            do 158 ii = 0, nsamp
                  udatum(ii,jxii) = 0.0
158            continue
160       CONTINUE
C-----------------------------------------------------------------------
C
C       BEGIN EXTRAPOLATION.
C       FIRST LOOP (OVER INPUT TRACES).
C
        DO 440 JX = ns,ne
C-----------------------------------------------------------------------
C
C         READ A TRACE.
C
          NBYTES = 0
          call vclr (u,1,nsamp)
          CALL RTAPE ( LUIN, ITR, NBYTES                 )
            if (nbytes .le. 0 ) then
                  write(LER,*) 'read EOF on record',jxii
                  write(LER,*) 'terminating job'
                      go to 9999
            end if
           call vmov (itr(ITHWP1), 1, data, 1, nsamp)
          CALL CHECKA ( nsamp, U )
c     istatic = itr(125)
c     isrc    = itr(109)
c     igi     = itr(118)
c     ipri    = itr(110)
c     igrpel  = itr(120)
c     isrcel  = itr(112)
      call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1            istatic, TRACEHEADER)
      call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1            isrc   , TRACEHEADER)
      call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1            igi    , TRACEHEADER)
      call saver2(lhed,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1            ipri   , TRACEHEADER)
      call saver2(lhed,ifmt_GrpElv,l_GrpElv, ln_GrpElv,
     1            igrpel , TRACEHEADER)
      call saver2(lhed,ifmt_SrPtEl,l_SrPtEl, ln_SrPtEl,
     1            isrcel , TRACEHEADER)
      call move(1,iheadr(1,jx),itr,SZTRHD)
 
	if (itaper .gt. 0) then
	   if (jx .le. itaper) then
	      wt = float(jx)/float(itaper)
	      call vsmul( u, 1, wt, u, 1, nsamp)
	   elseif (jx .gt.(ne-itaper) ) then
	      wt = float((ne+1-jx))/float(itaper)
	      call vsmul( u, 1, wt, u, 1, nsamp)
	   endif
	endif
c
	if (geom .ne. 0.) then
           write(lerr,*) 'geometrical spreading'
	   do 6565 ijk = 1, nsamp
              u(ijk) = u( ijk ) * (float( ijk ) ** geom)
6565	   continue
	endif
c
          IF ( IREV .EQ. 1 ) CALL VRVRS ( U, 1, NSAMP)
C-----------------------------------------------------------------------
C
C         FIND RECEIVER X-LOCATION (FOR MOVING RECEIVERS)
C
C-----------------------------------------------------------------------
c
c          ztrace and ndatm added by dew for surface elevation problem
c
       if (jflag .eq. 1) then
          jxr = igi -jxgrp0
          xtrace = (jxr ) * grpint
          ztrace = - igrpel
       else
          jxr = isrc/10 -jxgrp0
          xtrace = ( jxr) * grpint
          ztrace = - isrcel
       end if
c
       iloc(jx) = jxr
       if (jxr .lt. 1 ) go to 440
       if (istatic .eq. 30000 ) go to 440
c
c      write(lerr,*)'ri ',irec,' tr ',jx,' jxr ',jxr,' x ',xtrace
c	write(lerr,*)'iloc',iloc(jx),'jxgrp0',jxgrp0,'iflag',iflag(jxr)
c     if (xtrace .lt. 0.0 ) go to 440
c            ndatm = ztrace / dzgrid + 1
C-----------------------------------------------------------------------
C
C         COMPUTE RAYS FROM GROUP LOCATION X ONLY IF RAYS FROM X
C         HAVEN'T ALREADY BEEN COMPUTED.
C
C-----------------------------------------------------------------------
      if (iflag(jxr) .eq. 0 ) then
            X = XTRACE
C-----------------------------------------------------------------------
C
C           Compute x,t table for tracing rays thru model at gi location
c		jxr.
C
C-----------------------------------------------------------------------
            CALL timed
     1      (TAU, XP, ZETT, NRAY1, nzeta, jmax, SLOWZ, SLOWX, NTRCP1,
     2       PMAX, P, Vz, TMAX, X,
     3       DVDXz, ZEROV, SQRR, SINMAX, nzdatm, vdatum)
c
C-----------------------------------------------------------------------
C
C           Save RAY OFFSETS AND TRAVELTIMES
C
C-----------------------------------------------------------------------
      do 130 ii = -nray, nray
            xxx(ii,jxr) = xp(ii)
            ttt(ii,jxr) = tau(ii)
130      continue
         IFLAG(jxr) = 1
c        write(lerr,*) ' '
c        write(lerr,*)'  jxr  ',jxr,'  x  ',x,'iflag(jxr)',iflag(jxr)
c        write(lerr,9878)(xxx(jjj,jxr), ttt(jjj,jxr), jjj = -90,90)
9878   format(8f10.3)
      end if
C-----------------------------------------------------------------------
C
C         find live rays at depth jzeta
C
C-----------------------------------------------------------------------
c
	livmin = nray
        jxpp   = -nray
        do 390 jxp = -nray, nray
           if (ttt(jxp, jxr )  .gt. 0.) then
               livray(jxpp) = jxp
               jxpp = jxpp + 1
           end if
390     continue
c
        if (jxpp .ne. -nray) livmin = -nray
c
c      write(lerr,*) ' '
c      write(lerr,*) 'livmin=',livmin,' nray=',nray, ' jxpp=',jxpp
C-----------------------------------------------------------------------
C
C         Interpolate travel times at output trace locations
C
C-----------------------------------------------------------------------
      do 380 jxp = livmin+1, livmin+jxpp+nray-1
            x0 =  xxx(livray(jxp-1),jxr)
            x1 =  xxx(livray(jxp  ),jxr)
            t0 =  ttt(livray(jxp-1),jxr)
            t1 =  ttt(livray(jxp  ),jxr)
c
            IF (ABS(X0-X1) .LT. eps) THEN
               SLOPE = 0.
            ELSE
               SLOPE = (T1-T0)/(X1-X0)
            END IF
c
            XLEFT = AMIN1(X0,X1)
            XRGHT = AMAX1(X0,X1)
c
            JXLEFT = jxr + ( (XLEFT/GRPINT) + 0.5 )
            JXLEFT = MAX(jxr-nap2*ints, 1,     JXLEFT)
            JXLEFT = MAX( 1,     JXLEFT)
c
            JXRGHT = jxr + ( (XRGHT/GRPINT) + 0.5 )
            JXRGHT = MIN(JXRGHT, jxr+nap2*ints, jmax)
c
c      write(lerr,*)'jxr=', jxr, ' jxleft=',jxleft,' jxrght=', jxrght,
c    :		'jxp=',jxp
c      write(lerr,*)'x0=',x0,' x1=',x1, ' slope=',slope, ' t0=', t0
            DO 360 JXI = JXLEFT,JXRGHT
C-----------------------------------------------------------------------
C
C               ASSIGN TRAVELTIMES TO EACH OUTPUT TRACE LOCATION
C               BETWEEN XP(JXP) AND XP
C
                XI = JXI*GRPINT
                XXI0 = XI-(xtrace+X0)
C-----------------------------------------------------------------------
C
C               NEAREST NEIGHBOR TRAVELTIME ALONG TRACES.
C
                TIME = T0+SLOPE*XXI0
                IF ((TIME .GT. -.001) .AND. (TIME .LT. .5*TMAX)) then
                  if ( post ) then
                     TIME = SCALE*TIME*2.0
                  else
                     TIME = SCALE*TIME
                  endif
                  JT1 = int ( time + .5)
                  JT1 = MIN(JT1,nsamp)
c
c      write  (lerr,*) 'rec=',irec,' tr=',jx,' jxi=',jxi,' jt1=',jt1,
c    :          ' jxr=', jxr, ' jxleft=',jxleft,' jxrght=', jxrght,
c    :		' jxp=',jxp
c
                  DO 350 JT = 1,NTIME-JT1
                      TERM =  U(      JT1+JT)
                      UDATUM(JT, JXI) = UDATUM (JT, JXI ) + TERM
350               CONTINUE
                END IF
360           CONTINUE
C-----------------------------------------------------------------------
C
C         END LOOP OVER OUTPUT POINTS BETWEEN ACTIVE RAY ENDPOINTS
C
380       CONTINUE
C-----------------------------------------------------------------------
C
C       END LOOP OVER ACTIVE RAYS.
C
440     CONTINUE
C-----------------------------------------------------------------------
C
C       SCALE (RECORD CONSTANT) AND
C       WRITE OUT THE EXTRAPOLATED SECTION UDATUM
C
        AMAX = 0.
        DO 480 JXI = 1,NTRACE
           call vclr(u,1, nsamp)
           if (iloc(jxi) . gt. 0 .and. iloc(jxi) .le. jmax) then
              if (iheadr(125,jxi).eq. 30000) then
                 call vclr(udatum(0,iloc(jxi)), 1, nsamp+1 )
              endif
c
              mute = 0.5 + (tzero + 1000.*iheadr(117,jxi)/vmute) / nsi
              mute = min (mute, nsamp + 1)
              mute = max(mute,0)
c
              call vclr (udatum(0,iloc(jxi)), 1, mute )
              call maxmgv (udatum(1,iloc(jxi)),1,smax,nmxu,nsamp)
              if (smax .gt. amax) amax = smax
           endif
480     CONTINUE
C-----------------------------------------------------------------------
C
C       APPEND TRACE HEADERS AND WRITE OUT AN EXTRAPOLATED RECORD
C
        DO 540 JXI = 1,NTRACE
           call move(1,itr,iheadr(1,jxi),SZTRHD)
              if (iloc(jxi) .gt. 0 .and. iloc(jxi) .le. jmax) then
                 do 547 ii = 1, nsamp
                    u(ii) = (udatum(ii, iloc(jxi)))/(amax + 0.001)
547              continue
              else
                 call vclr(u,1,nsamp)
              endif
c
              IF ( IREV .EQ. 1 ) CALL VRVRS ( U, 1, NSAMP )
              call vmov   (U, 1, itr(ITHWP1), 1, nsamp)
              CALL WRTAPE ( luout, ITR, nbytes          )
540     CONTINUE
C
C     END LOOP OVER INPUT RECORDS
C
450   CONTINUE
C-----------------------------------------------------------------------
C
C     CLOSE INPUT AND OUTPUT FILES
C
C-----------------------------------------------------------------------
9999      continue
      CLOSE (UNIT=LU44,STATUS='KEEP')
c     PRINT*,'LU44 CLOSED'
      CLOSE (UNIT=LU55,STATUS='KEEP')
c     PRINT*,'LU55 CLOSED'
      CLOSE (UNIT=LU77,STATUS='KEEP')
c     PRINT*,'LU77 CLOSED'
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
C-----------------------------------------------------------------------
c
      SUBROUTINE RAYS(NRAY1,CZERO,FMAX,DIPFIL,P,PMAX,GRPINT,SINMAX)
C
C
      DIMENSION P(-180:180)
      DIMENSION PTEMP(-180:0)
      NRAY = NRAY1-1
C
C     THEORETICAL MAXIMUM HORIZONTAL RAY PARAMETER WHICH AVOIDS
C     USING SPATIALLY ALIASED REFLECTION DATA.
C
      PMAX = CZERO/(DIPFIL*FMAX*GRPINT)
c     PMAX = SINMAX
      PMAX = AMIN1(PMAX,.99)
c     write(33,*)'PMAX =',PMAX
C
C     EQUAL ANGULAR RAY SPACING
C
      DTHETA = ASIN(PMAX)/NRAY
 
      JP = 0
      P(0) = 0.
c     write(33,*)' JP,P',JP,P(JP)
C
C     RAY PARAMETERS
C
      DO 80 JP = 1,NRAY
        THETA = JP*DTHETA
        P(JP) = SIN(THETA)
80    CONTINUE
c       write(33,*)' JP,P',JP,P(JP)
c
c -- this was broken out of the loop to aid in vectorization - j.m.wade 02/27/90
      do 85 JP = 1,NRAY
        ptemp(-JP) = -P(JP)
85    CONTINUE
      call vmov(ptemp(-nray),1,p(-nray),1,nray)
      RETURN
      END
 
 
            subroutine timed
     1      (TAU, XP, ZETT, NRAY1, nzeta, jmax, SLOWZ, SLOWX, NTRCP1,
     2       PMAX, P, Vz, TMAX, X,
     3       DVDXz, ZEROV, SQRR, SINMAX, nzdatm, vdatum)
C
C     TRAVELTIME TABLE CALCULATION FOR KIRCHHOFF MIGRATION
C     USING A REFERENCE VELOCITY C(X,Z)
C
      DIMENSION ZETT(0:nzeta), XP(-180:180), TAU(-180:180)
      DIMENSION P(-180:180),SLOWZ(-180:180)
      DIMENSION SLOWX(-180:180)
      DIMENSION ZEROV(jmax )
c     DIMENSION V(0:NZETA,JMAX)
c     DIMENSION DVDX(0:NZETA,JMAX)
      DIMENSION SQRR(0:5000)
      dimension vz (0:nzeta,jmax )
      dimension dvdxz(0:nzeta,jmax )
      logical   vdatum
 
      COMMON/VBLOCK/DXGRID,DZGRID,NXGRID
C
C     BEGIN TRAVELTIME CALCULATIONS.
C     FIRST LOOP (OVER TRACE LOCATIONS).
C
 
      NTRACE = NTRCP1-1
      NRAY = NRAY1-1
C
C     FIX RECEIVER LOCATION X AND VELOCITY AT (X,O).
C
      JXGRID = X/DXGRID
      IF (JXGRID .LT. 1) JXGRID = 1
      IF (JXGRID .GT. NXGRID-1) JXGRID = NXGRID-1
      VZERO = ZEROV(JXGRID)
      if ( vdatum ) then
         if (vzero .eq. 0.) then
            print*,' **** TIMES:  zero velocities found'
            stop
         endif
      endif
C
C     COMPUTE SLOWNESSES FOR X FROM THE P'S
C     (HORIZONTAL SLOWNESS = P/C(0),
C     VERTICAL SLOWNESS = (SQRT(1-P**2))/C(0)).
C     INITIALIZE TAU AND RAY OFFSETS.
C
      DO 60 JXP = -nray, nray
        PP = P(JXP)
c -- use the variable vzero instead of array element so
c -- a register may be more likely to get used          - j m wade 03/15/90
c       SLOWX(JXP) = PP/ZEROV(JXGRID)
c       SLOWZ(JXP) = SQRT(1.-PP**2)/ZEROV(JXGRID)
        SLOWX(JXP) = PP/VZERO
        SLOWZ(JXP) = SQRT(1.-PP**2)/VZERO
c -- took this back out since it is done later on       - j m wade 03/15/90
c       XP(JXP) = 0.
c       TAU(JXP) = 0.
60    CONTINUE
      DELTAX = X-JXGRID*DXGRID
      VGRADX = DVDXz(0,JXGRID)
c -- got rid of temporary variable - no looping going on - j m wade 03/15/90
c     vzz = vz (0, jxgrid)
c     VZETA = vzz + DELTAX*VGRADX
      VZETA = vz (0, jxgrid) + DELTAX*VGRADX
c -- changed czero to vzero on S. Gray's suggestion  - W May 11/13/90
      PP = VZERO/VZETA
      PP = AMIN1(PP,PMAX)
C
C     SECOND LOOP (OVER HORIZONTAL RAY PARAMETERS).
C     RAY CALCULATIONS FOR A FIXED RAY AT ALL DEPTHS.
C
      DO 200 JXP = -NRAY,NRAY
        SZ = SLOWZ(JXP)
        SX = SLOWX(JXP)
        TAU(         JXP) = 0.
        XP(  JXP) = 0.
crej    TAUU = 0.
C
C       THIRD LOOP (OVER DEPTHS).
C
        DO 180 JZETA = 1 ,NZDATM
          ZETA = ZETT(JZETA)
          DZETA = ZETT(JZETA)-ZETT(JZETA-1)
 
 
crej took out all rejection code for speed 		- j.m.wade 03/15/90
crej      IF (TAUU .LT. -1.) THEN
C
C           TAUU < 0:
C           NO RAY CALCULATION
C
crej        TAUU = -10000.
crej        TAU(             JXP) = -10000.
crej      ELSE
C
C           POSSIBLE RAY CALCULATION
C
C
C           NO TRAVELTIME CALCULATIONS FOR SCATTERER LOCATIONS
C           OUTSIDE THE BOUNDARIES OF THE DEPTH SECTION
C           OR TRAVELTIMES > .5*TMAX
C
crej took out all rejection code for speed 		- j.m.wade 03/15/90
crej        IF  (TAUU .GT.     TMAX) THEN
crej          TAUU = -10000.
crej          TAU(             JXP) = -10000.
crej        ELSE
C
C             COMPUTE TRAVELTIME FROM (X,0) THROUGH (XP,ZETA-DZETA)
C             TO (XPXP,ZETA)
C             BY SOLVING THE EIKONAL EQUATION.
C             USE EQ. (13.5), P. 723 OF AKI AND RICHARDS.
C
              XPXP = X+XP(        JXP)
              SZ1 = 1./SZ
              ZZ = ZETT(JZETA-1)
C
C             THERE ARE VARIOUS WAYS TO OBTAIN A SMOOTHED ESTIMATE
C             FOR THE VELOCITY USED IN THE RAY CALCULATIONS.
C             ONE WHICH APPEARS TO WORK WELL IS TO SMOOTH
C             THE VELOCITY MODEL IN PROGRAM VSMOOTH
C             BEFORE PASSING THE VELOCITIES AND GRADIENTS
C             TO THE ARRAYS V AND DVDX.
C
C
C             INCREMENT IN TRAVELTIME AND HORIZONTAL RAY OFFSET.
C             CHANGE VELOCITY TO THAT OF APPROXIMATE RAY ENDPOINT
C             IN ORDER TO CALCULATE SLOWNESSES AT RAY ENDPOINT.
C
              DXP = DZETA*SX*SZ1
              JXGRID = (XPXP+DXP)/DXGRID
              JXGRID = MAX(2,JXGRID)
              JXGRID = MIN(JXGRID,NXGRID-2)
              DELTAX = XPXP+DXP-JXGRID*DXGRID
              VGRADX = DVDXz(JZETA,JXGRID)
c -- got rid of temporary variable 			- j m wade 03/15/90
c           vzz = vz ( jzeta, jxgrid )
c             VEL = Vzz + DELTAX*VGRADX
              VEL = vz ( jzeta, jxgrid ) + DELTAX*VGRADX
cchg          SLOW = 1./VEL				- d wagner 07/20/90
              SLOW = 1./(VEL + 1.E-10)
              DTAU = DZETA*SZ1*SLOW**2
C
C             HORIZONTAL SLOWNESS INCREMENT AT RAY
C             ENDPOINT IN TERMS OF LATERAL VELOCITY CHANGE.
C
              DSX = -DTAU*VGRADX*SLOW
              SX = SX+DSX
C
C             VERTICAL SLOWNESS SZ IN TERMS OF HORIZONTAL
C             SLOWNESS SX (SX**2+SZ**2 = 1/VEL**2 -- P. 723 OF
C             AKI AND RICHARDS).
C             IT IS PROBABLY MORE STABLE TO COMPUTE SZ THIS WAY
C             (DEPENDING ON SX) THAN TO COMPUTE IT INDEPENDENTLY
C             OF SX.
C
              VELSX = VEL*SX
              ARG = 1.-VELSX**2
c -- get rid of if statement - end result should be the same - j.m.wade 03/15/90
c             IF (ARG .LE. .000001) THEN
c               SZ = 0.
c             ELSE
              arg = max(arg,.000001)
CCC             SZ = SQRT(ARG)*SLOW
CCC             SZ = SQRT(ABS(ARG))*SLOW
C
C               SUBSTITUTE FOR SQRT USING TABLED ARRAY SQRR
C
                JARG = 5000.*ARG+.5
                SZ = SQRR(JARG)*SLOW
 
 
c             END IF
c -- added  first condition statement to loop	 - j.m.wade 07/20/90
c
              IF (VEL .LT. .001) then
                go to 200
              else IF ((SZ*VEL .LT. .0001) .OR.
     1            (ABS(SX)*VEL .GT. SINMAX)) THEN
C
C               TURNED RAY
C
crej            TAUU = -10000.
                TAU(             JXP) = -10000.
                go to 200
              ELSE
C
C               NON-TURNED RAY: COMPUTE SLOWNESSES AND TRAVELTIME
C               TO DEPTH ZETA
C
                ZZ = ZZ+DZETA
                XP(      JXP) = XP(        JXP)+DXP
crej            TAUU = TAUU+DTAU
                XX = X+XP(      JXP)
                JXGRID = XX/DXGRID
                JXGRID = MAX(2,JXGRID)
                JXGRID = MIN(JXGRID,NXGRID-2)
                DELTAX = XX-JXGRID*DXGRID
                VGRADX = DVDXz(JZETA,JXGRID)
c -- got rid of temporary variable 			- j m wade 03/15/90
c           vzz = vz (jzeta, jxgrid )
c               VEL = Vzz + DELTAX*VGRADX
                VEL = vz (jzeta, jxgrid ) + DELTAX*VGRADX
                TAU(             JXP) =
     1            TAU(               JXP)+DZETA*SZ1*SLOW/VEL
              END IF
crej        END IF
crej      END IF
180     CONTINUE
200   CONTINUE
C     PRINT*,'XP'
C     PRINT*, XP
C     PRINT*,'TAU'
C     PRINT*, TAU
      RETURN
      END
c -- commented this out, we're call mathadvantage's VRVRS routine instead
c -- j.m.wade 02/27/90
c
c     SUBROUTINE REVERS(N,X)
C
C     THIS SUBROUTINE REVERSES A VECTOR X
C
C     INPUTS ARE
C        N=LENGTH OF THE VECTOR X      INTEGER*4
C        X=THE VECTOR X, X(1),X(2),...,X(N)     REAL*4
C     OUTPUTS ARE
C        X=THE REVERSED VECTOR X, X(N),X(N-1),...,X(1)
C               REAL*4
C
c     DIMENSION X(*)
c     NN=N/2
c     DO 10 I=1,NN
c     J=N-I
c     TEMP=X(I)
c     X(I)=X(J+1)
c     X(J+1)=TEMP
c10   CONTINUE
c     RETURN
c     END
c
      SUBROUTINE CHECKA ( NX  , X )
      REAL    * 4 X ( * ), XMAX, XMIN
      INTEGER * 4 NX
      DATA  XMAX  ,   XMIN / 1.0e+15, 1.0e-15/
C*******************************************************************C
C                                                                   C
C  SUBROUTINE ARGUMENTS                                             C
C                                                                   C
C  X      = INPUT VECTOR                                            C
C  NX     = NUMBER OF SAMPLES/TRACE                                 C
C                                                                   C
C*******************************************************************C
      DO 10 I = 1, NX
        IF (ABS ( X (I) ) .LT. XMIN       ) THEN
            X ( I ) = 0.0
        ENDIF
        IF (ABS ( X (I) ) .GT. XMAX       ) THEN
            X ( I ) = 0.0
        ENDIF
10      continue
      RETURN
      END
c********************************************************************
c
      subroutine smoot(c,nzeta,lmax,dxgrid,dzgrid,data,zett,vv,
     1     dvdxz,nxave,nzave,zerov,czero)
c
C     Smooth a velocity tape and generate a
C     laterally averaging c(x,z) .
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
C**********************************************************************C
#include  <localsys.h>
#include  <f77/iounit.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
      real	DVDXZ (0:1000, *)
      real	VV(0:1000,*)
      real      zerov(*),czero
      REAL         vz(2500), DVDX(2500),vztemp(2500), zett(0:1001 )
      REAL         c(1001,2500),data(3000)
c
c    set local variables to number of cells in x and z directions
c
 	jmax = lmax
 	imax1 = nzeta
	zmax  = nzeta * dzgrid
	jxbias = 0
c
c    compute smoothed velocities at depth zeta =0
c
      JZETA = 0
      ZETA  = 0.
      TAU   = 0.
      ZETT(0) = 0.
C-----------------------------------------------------------------------
C
C     VELOCITY ROWS FOR DEPTH ZETA = 0.
C     AVERAGE HORIZONTALLY AND VERTICALLY FOR SMOOTH VELOCITY.
C
C-----------------------------------------------------------------------
	call vclr(vz,1,lmax)
	call vclr(vztemp,1,lmax)
	call vclr(dvdx,1,lmax)
	call vclr(zett,1,nzeta)
      IROW = 1
C-----------------------------------------------------------------------
C
C     VERTICAL SMOOTHING: AVERAGE VELOCITY OVER HORIZONTAL STRIPS,
C     EQUIVALENT TO A VERTICAL RUNNING AVERAGE.
C     THE NUMBER OF HORIZONTAL STRIPS IS HALF THAT USED FOR DEPTHS
C     > 0, AND THE MOST HEAVILY WEIGHTED STRIP IS
C     THE FIRST ROW OF THE VELOCITY MODEL.
C
C-----------------------------------------------------------------------
	istop = ( nzave + 1 ) / 2
      DO 80 JZAVE = 1,istop
C
C       NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
        IROW = 1
        DO 60 JXI = 1,JMAX
          JXII = JXI
c         JXII = JXI-JXBIAS
          JXII = MAX(1,JXII)
          JXII = MIN(JXII,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NZAVE+1)/2
          SUM = NSUM**2
          WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
          VZTEMP(JXI) = VZTEMP(JXI)+WGT*c(IROW,JXII)
60      CONTINUE
80    CONTINUE
      IROW = 2
      IROW = MAX(IROW,1)
      DO 90 JZAVE = (NZAVE+1)/2+1,NZAVE
C
C       NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
        IROW = MIN(IROW,IMAX1)
        DO 85 JXI = 1,JMAX
          JXII = JXI
c         JXII = JXI-JXBIAS
          JXII = MAX(1,JXII)
          JXII = MIN(JXII,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NZAVE+1)/2
          SUM = NSUM**2
          WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
          VZTEMP(JXI) = VZTEMP(JXI)+WGT*c(IROW,JXII)
85      CONTINUE
        IROW = IROW+1
90    CONTINUE
C-----------------------------------------------------------------------
C
C     HORIZONTAL SMOOTHING: HORIZONTAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
      CAVE = 0.
      DO 120 JXI = 1,JMAX
        DO 100 JXAVE = 1,NXAVE
          JNDEX = JXI+(NXAVE+1)/2-JXAVE
          JNDEX = MAX(1,JNDEX)
          JNDEX = MIN(JNDEX,JMAX-1)
C
C         TRIANGULAR TAPER FUNCTION
C
          NSUM = (NXAVE+1)/2
          SUM = NSUM**2
          WGT = ((NXAVE+1)/2-IABS((NXAVE+1)/2-JXAVE))/SUM
          Vz (jxi) = Vz(JXI)+WGT*(VZTEMP(JNDEX))
C
C         insert v(0) here for v(z) migration: vz(jxi) = ...
C         vz(jxi) = 1480. * 1.0077
C
100     CONTINUE
      call vmov(vz(1),1,zerov(1),1,jmax)
      call minv(vz(2),1,czero,indx,jmax-2)
        IF ((JXI .GT. 1) .AND. (JXI .LT. JMAX)) CAVE = CAVE+Vz (jxi)
120   CONTINUE
      CAVE = CAVE/(JMAX-2)
      TAU = TAU+2.*ZETA/Vz( (  JMAX+1 ) / 2 )
c     DZETA = 10.
      DZETA = dzgrid
      DVDX( 1) = 0.
      DVDX( JMAX) = 0.
      DO 140 JXI = 2,JMAX-1
        DVDX( JXI ) = ( Vz( JXI+1 )- Vz( JXI-1) ) / (2.*DXGRID)
140   CONTINUE
      do 1400 jxi=1,jmax
        dvdxz(0,jxi) = dvdx(jxi)
        vv(0,jxi) = vz(jxi)
 1400 continue
C-----------------------------------------------------------------------
C
C     COMPUTE SMOOTHED VELOCITIES AT DEPTHS ZETA > 0.
C
C-----------------------------------------------------------------------
c     DZETA = 10.
      DZETA = dzgrid
      JZETA = 0
      ZETA = 0.
105   FORMAT(5E12.2)
C-----------------------------------------------------------------------
C
C     next statement is branch for do loop.
C
C-----------------------------------------------------------------------
	do 919 iii = 1, nzeta
        JZETA = JZETA+1
        ZETA = ZETA+DZETA
        IF (ZETA .GE. ZMAX) ZETA = ZMAX+.0001
c       ZETT(JZETA+1) = ZETA
        ZETT(iii) = ZETT(iii - 1) + DZETA
C
C       VELOCITY ROWS FOR DEPTH ZETA.
C       AVERAGE HORIZONTALLY AND VERTICALLY FOR SMOOTH VELOCITY.
C
	call vclr(vz,1,lmax)
	call vclr(vztemp,1,lmax)
	call vclr(dvdx,1,lmax)
        IROW =    +INT(ZETA/DZGRID)-NZAVE/2
        IROW = MAX(IROW,1)
C-----------------------------------------------------------------------
C
C       VERTICAL SMOOTHING: AVERAGE VELOCITY OVER HORIZONTAL STRIPS,
C       EQUIVALENT TO A VERTICAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
        DO 300 JZAVE = 1,NZAVE
C
C         NOTE: IMAX1 = # OF DEPTHS IN THE VELOCITY MODEL.
C
          IROW = MIN(IROW,IMAX1)
          DO 280 JXI = 1,JMAX
            JXII = JXI
c           JXII = JXI-JXBIAS
            JXII = MAX(1,JXII)
            JXII = MIN(JXII,JMAX-1)
C
C           TRIANGULAR TAPER FUNCTION
C
            NSUM = (NZAVE+1)/2
            SUM = NSUM**2
            WGT = ((NZAVE+1)/2-IABS((NZAVE+1)/2-JZAVE))/SUM
            VZTEMP(JXI) = VZTEMP(JXI)+WGT*c(IROW,JXII)
280       CONTINUE
          IROW = IROW+1
300     CONTINUE
C-----------------------------------------------------------------------
C
C       HORIZONTAL SMOOTHING: HORIZONTAL RUNNING AVERAGE
C
C-----------------------------------------------------------------------
        CAVE = 0.
        DO 340 JXI = 1,JMAX
          DO 320 JXAVE = 1,NXAVE
            JNDEX = JXI+(NXAVE+1)/2-JXAVE
            JNDEX = MAX(1,JNDEX)
            JNDEX = MIN(JNDEX,JMAX-1)
C
C           TRIANGULAR TAPER FUNCTION
C
            NSUM = (NXAVE+1)/2
            SUM = NSUM**2
            WGT = ((NXAVE+1)/2-IABS((NXAVE+1)/2-JXAVE))/SUM
            vz( JXI ) = vz( JXI ) + WGT*(VZTEMP(JNDEX))
320       CONTINUE
          IF ((JXI .GT. 1) .AND. (JXI .LT. JMAX))
     :               CAVE = CAVE + Vz( JXI )
340     CONTINUE
        CAVE = CAVE/(JMAX-2)
        TAU = TAU + 2. * DZETA / Vz( ( JMAX+1 ) / 2 )
        DZETA = dzgrid
        DVDX(  1    ) = 0.
        DVDX(  JMAX ) = 0.
        DO 360 JXI = 2,JMAX-1
         dvdx ( jxi ) =  (vz ( JXI+1 ) - vz ( JXI-1 ) ) / ( 2.*DXGRID )
360     CONTINUE
      do 1405 jxi=1,jmax
        dvdxz(iii,jxi) = dvdx(jxi)
        vv(iii,jxi) = vz(jxi)
 1405 continue
919   continue
c     print *,'vsmooth done'
      return
      END
      subroutine help
#include <f77/iounit.h>
 
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'execute datum by typing datum and a list of program parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
       write(LER,*)
     :' -ns[ns]      (default = first)         : start trace number'
       write(LER,*)
     :' -ne[ne]      (default = last)         : end trace number'
       write(LER,*)
     :' -rs[irs]      (default = first)         : start record number'
       write(LER,*)
     :' -re[ire]      (default = last)         : end record number'
        write(LER,*)
        write(LER,*)
     :'usage:   datum -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] ',
     :' -re[ire] -V'
         write(LER,*)
     :'***************************************************************'
      return
 
      end
 
      subroutine gcmdln (ntap, otap, ns, ne, irs, ire, tmax,tzero,
     :     vmute, fmax, nzdatm,  nray, ints, itaper,
     :   grpint, dipmax, dipfil, irev, jflag, jxgrp0, verbos,
     :   nxave,nzave,vtap,post,vdatum,geom)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     vtap  - c*120     velocity file
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos  - L   verbose output or not
c     nxave - i*4 number of cells to smooth in x direction.
c     nzave - i*4 number of cells to smooth in z direction.
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), vtap*(*)
      integer *4 ns, ne, irs, ire
      logical verbos, shot, post, vdatum
      integer argis,nxave,nzave
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr ('-Vtap', vtap, ' ', ' ')
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4('-t0', tzero, 0.0, 0.0 )
            call argr4('-vm', vmute, 5000.0, 5000.0 )
            call argi4('-sx', nxave, 0, 0 )
            call argi4('-sz', nzave, 0, 0 )
            call argr4('-fmax', fmax, 30.0, 30.0)
            call argi4('-ndatum', nzdatm, 30 ,30)
            call argi4('-nray', nray, 45, 45)
            call argi4('-sl', ints, 1, 1)
            call argi4('-taper', itaper, 0, 0 )
	    call argr4('-grpint',grpint,0.0, 0.0)
            call argr4('-dipmax', dipmax, 90.0, 90.0)
            call argr4('-dipfil', dipfil, 2.0, 2.0 )
            call argi4('-irev', irev, 0, 0 )
            call argi4('-x0', jxgrp0, 0,  0   )
            call argr4('-gs', geom, 0.0, 0.0)
            shot = ( argis('-S') .gt. 0 )
            post = ( argis('-POST') .gt. 0 )
            vdatum = (argis('-VAR').gt.0)
            verbos = ( argis( '-V' ) .gt. 0 )
c
            if (shot) then
                  jflag = 2
            else
                  jflag = 1
            end if
c
      return
      end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, grp,
     :  ntap,otap,tmax,f1,f2,f3,f4,nzdatm,jmax,nray,
     :	dipmax,dipfil,irev,jflag,dxgrid,dzgrid,mzeta,vdatum,post,geom)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     intvl - I*4 group interval
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform
      character ntap*(*), otap*(*)
      logical vdatum, post
 
            write(LERR ,*)' '
            write(LERR ,*)' line header values after default check '
            write(LERR, *) ' # of samples/trace =  ', nsamp
            write(LERR ,*) ' sample interval    =  ', nsi
            write(LERR ,*) ' traces per record  =  ', ntrc
            write(LERR, *) ' records per line   =  ', nrec
            write(LERR ,*) ' format of data     =  ', iform
            write(LERR ,*)' '
            write(LERR ,*)' Program Rum Parameters '
            write(LERR ,*) ' group interval     =  ', grp
            write(LERR, *) ' maximum time       =  ', tmax
            write(LERR, *) ' f1, f2, f3, f4     =  ', f1, f2, f3, f4
            write(LERR, *) ' datum level (grid) =  ', nzdatm
            write(LERR, *) ' Number of rays     =  ', nray
            write(LERR, *) ' Maximum dip        =  ', dipmax
            write(LERR, *) ' Dip filter         =  ', dipfil
            write(LERR, *) ' Geom. Amp. Gain    =  ', geom
            write(LERR, *) ' Datum down(0),up(1)=  ', irev
            write(LERR, *) ' Datum rcvr(1),src(2)= ', jflag
            write(LERR ,*) ' input data         =  ', ntap
            write(LERR ,*) ' output data set    =  ', otap
            if (vdatum) then
               write(LERR ,*) ' Variable Datum Mode'
            endif
            if (post) then
               write(LERR ,*) ' Normal Incidence (After Stack) Case'
            endif
            write(LERR ,*)' '
            write(LERR ,*)' Velocity Model Parameters '
            write(LERR, *) ' Number of x grids  =  ', jmax
            write(LERR, *) ' Number of z grids  =  ', mzeta
            write(LERR, *) ' Cell X dimension   =  ', dxgrid
            write(LERR, *) ' Cell Z dimension   =  ', dzgrid
            write(LERR ,*)' '
            write(LERR ,*)' '
 
      return
      end
      subroutine savelh(itr,nsamp,nsi,ntrc,nrec,iform)
      character grp*4
      LINHED = 0
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c     call saver(itr, 'GrpIn0', intvl0, LINHED)
c     call saver(itr, 'GrpIn1', intvl1, LINHED)
c     call saver(itr, 'GrpIn2', intvl2, LINHED)
c     call saver(itr, 'GrpIn3', intvl3, LINHED)
c     grp(1:1) =  char ( intvl0 )
c     grp(2:2) =  char ( intvl1 )
c     grp(3:3) =  char ( intvl2 )
c     grp(4:4) =  char ( intvl3 )
c     read (  grp(1:4), fmt = '(i4)' ) intvl
c     read (  grp(1:4), fmt = '(r4)' ) grpint
c     GRPINT = intvl
      return
      end
      SUBROUTINE SAVEH ( ITR, NSAMP, NTRC, NREC, DX, DZ)
C**********************************************************************
C
C SAVE PARAMETERS FROM INPUT LINE HEADER
C
C**********************************************************************
C
C OUTPUT PARAMETERS
C
C     NSAMP = NUMBER OF SAMPLES / TRACE
C     NTRC  = NUMBER OF TRACES / RECORD
C     NREC  = NUMBER OF RECORDS/ JOB
C     dx    = interval between velocity traces
c     dz    = depth interval
c
C**********************************************************************
C
C DECLARE VARIABLES
C
C**********************************************************************
#include  <f77/sisdef.h>
      INTEGER * 2 ITR ( * )
          call saver(itr, 'NumSmp', nsamp, LINHED)
          call saver(itr, 'NumTrc', ntrc , LINHED)
          call saver(itr, 'NumRec', nrec , LINHED)
          call saver(itr, 'TmMsSl', nx   , LINHED)
          call saver(itr, 'TmSlIn', nz   , LINHED)
          dz    = float(nz)/1000.
          dx    = float(nx)/1000.
      RETURN
      END
