C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       BD_DET                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      BD_DETMUT  (X,IM,N,FLAG)                                        *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      IM      INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      FLAG    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine bd_detmut (x, im, n, flag)
 
c  routine to detect the first live sample going down a trace
c  or up a trace depending on the flag
 
c  x  - input data
c  n  - length of x
c im  - last zero sample from top
c       or first zero sample at bottom
c       flag = 0 do top
c       flag = 1 do bottom
 
      real     x(*)
      integer  im, n, flag
 
      im = 0
      if ( flag .eq. 0 ) then
 
         do  i = 1, n
            if (abs(x(i)) .eq. 0.) then
               im = im + 1
            else
               return
            endif
         enddo
 
      elseif ( flag .eq. 1 ) then
 
         do  i = n,1,-1
            if (abs(x(i)) .eq. 0.) then
               im = im + 1
            else
               if ( i .eq. n )then
                  im = n
               else
                  im = n - im + 1
               endif
               return
            endif
         enddo
 
      endif
 
      return
      end
