C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  this routine takes care of the case where we are rolling on to a trace
c  and we are always adding a sample

c  n     = # samples in current window
c  wnew  = new sample to be added
c  first = true if this is the first call
c  xmed  = median output
c  key   = original position of the sorted samples
c  w     = samples in last window
c  tmp1  = work array
c  tmp2  =   "
c  ley1  =   "
c  ley2  =   "
c---
      subroutine medon (n, wnew, first, xmed, key, w, 
     1                  tmp1, tmp2, ley1, ley2)

      real     w(n), tmp1(n), tmp2(n)
      integer  key(n), ley1(n), ley2(n)
      real     wnew, xmed
      integer  n, ii, i, ist
      logical  first

c---
c  if first call then fully sort the data
c---
      if (first) then
          call rsort (w, key, n)
          first = .false.
          go to 100
      endif

      n1 = n - 1

c---
c  find position of new sample; preserve position of old samples
c  less than this value
c---
      do  i = 1, n1
            if (wnew .lt. w(i)) then
               ist = i
               go to 5
            endif
      enddo

c---
c  if the new sample is larger than any of the old...
c---
      w (n) = wnew
      key (n) = n
      go to 100

5     continue

c---
c  ... else save the original window samples ordered after the new samples 
c   also put the new sample in its proper position and update that sample
c   of the position pointer
c---
      ii = 0
      do  i = ist, n1
          ii = ii + 1
          tmp1 (ii) = w (i)
          ley1 (ii) = key (i)
      enddo
      w (ist) = wnew
      key (ist) = n

c---
c  update the new window samples and position pointer
c---
      ii = 0
      do  i = ist, n1
          ii = ii + 1
          w (i+1) = tmp1 (ii)
          key (i+1) = ley1 (ii)
      enddo


100   continue

c---
c  compute median
c---
      if (mod(n,2) .eq. 0) then
         xmed = .5 * (w(n/2) + w(n/2+1))
      else
         xmed = w(n/2+1)
      endif

      return
      end   

  
