C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---
c  this routine implements the add-1-drop-1 strategy of median computation

c  n     = # samples in current window
c  wnew  = new sample to be added
c  first = true if this is the first call
c  xmed  = median output
c  key   = original position of the sorted samples
c  w     = samples in last window
c  tmp1  = work array
c  tmp2  =   "
c  ley1  =   "
c  ley2  =   "
c---

      subroutine medroll (n, wnew, first, xmed, key, w, 
     1                    tmp1, tmp2, ley1, ley2)

      real     w(n), tmp1(n), tmp2(n)
      integer  key(n), ley1(n), ley2(n)
      real     wnew, xmed
      integer  n, ii, i, ist
      logical  first

c---
c  if first call then fully sort the data
c---
      n1 = n - 1
      if (first) then
          call rsort (w, key, n)
          first = .false.
          go to 100
      endif

c---
c  store all the samples and positions of samples in the old window
c  that are greater than the first original sample (key position = 1)
c---
      ii = 0
      do i = 1, n
           if (key(i) .ne. 1) then
               ii = ii + 1
               tmp1 (ii) = w (i)
               ley1 (ii) = key (i)
           endif
      enddo
c---
c  find position of new sample; less than this position decrease the
c  old position markers by 1 (since the window has moved up by 1 samp)
c  At the position of the newest sample store the value and new
c  position (now the last position of the new window position)
c---
      do  i = 1, n1
            if (wnew .ge. tmp1(i)) then
               tmp2 (i) = tmp1 (i)
               ley2 (i) = ley1 (i) - 1
            else
               tmp2 (i) = wnew
               ley2 (i) = n
               ist = i
               go to 5
            endif
      enddo
c---
c  if the new sample sits at the end of the sorted array fix these values...
c---
      ist = n
      tmp2 (ist) = wnew
      ley2 (ist) = n
      go to 6

5     continue

c---
c  ... else store the old values above the new sample position
c---
      do  i = ist, n1
               tmp2 (i+1) = tmp1 (i)
               ley2 (i+1) = ley1 (i) - 1
      enddo

6     continue

c---
c  put the new vectors back into the final arrays
c---
      do  i = 1, n
            w (i) = tmp2 (i)
            key (i) = ley2 (i)
      enddo

100   continue

c---
c  compute median
c---
      if (mod(n,2) .eq. 0) then
         xmed = .5 * (w(n/2) + w(n/2+1))
      else
         xmed = w(n/2+1)
      endif

c     write(0,*)'****************************'
c     write(0,*)(w(i),i=1,n)
c     write(0,*)(key(i),i=1,n)
c     write(0,*)'xmed= ',xmed
c     write(0,*)'****************************'

      return
      end   

  
