C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  TIME VARYING AND FIXED FILTERING                          *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   KEN PEACOCK                        ORIGIN DATE: 87/03/11  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 87/03/20  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   REAL -                                                  *
C      TIMSTR -                                                        *
C      ARGSTR       -                                                  *
C      ARGR4        -                                                  *
C      ARGI4        -                                                  *
C      LBOPEN       -                                                  *
C      RTAPE        -                                                  *
C      SAVE         -                                                  *
C      HLH          -                                                  *
C      CONA  -                                                         *
C      FILTI -                                                         *
C      mfoldf -                                                        *
C      MCTVF  -                                                        *
C      WRTAPE       -                                                  *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IOPRT   ( OUTPUT SEQUENTIAL ) -                                 *
C      IOTERM  ( OUTPUT SEQUENTIAL ) -                                 *
C      LER     ( OUTPUT SEQUENTIAL ) -                                 *
C      21      ( INPUT  SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 5) -                                                 *
C      100      ( 1) -                                                 *
C      101      ( 1) -                                                 *
C      102      ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  K.J.MARFURT                   REVISION DATE: 03/15/87  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 87/03/20 ==================   *
C      TRACIN -                                                        *
C      TIMEND -                                                        *
C      IODATA  ( INPUT  SEQUENTIAL ) -                                 *
C      3  ( INPUT  SEQUENTIAL ) -                                      *
C      =BLANK=  ( 1) -                                                 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C***********************************************************************
C     PROGRAM SCTVF- TO APPLY TIME-VARIANT FILTER TO DATA.  3-12-85.    

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      PARAMETER (MXNT=SZLNHD, MXTR=SZSPRD, MAXFLT=100)
      PARAMETER ( LFMAX=301, MXBUF=MXNT+LFMAX+1,MXPT=10)
C
      INTEGER   ITR (SZLNHD)
      INTEGER   ARGIS

c------
c  static memory allocation
c     DIMENSION X(MXNT,MXTR),Y(MXNT,MXTR),XTR(MXNT),z(MXNT,MXTR)
c     DIMENSION work(MXNT,MXTR)
      DIMENSION xtr(MXNT)
c------
c  dynamic memory allocation
      real       x, y, z
      pointer    (wkadrx, x(1))
      pointer    (wkadry, y(1))
      pointer    (wkadrz, z(1))
c------
 
      real      amp
      DIMENSION F(MXNT)  
      DIMENSION G(LFMAX,MAXFLT),BUF(LFMAX),lg(MAXFLT),ish(MAXFLT)
C
      CHARACTER NTAP*255, OTAP*255, ffile*255, NAME*5
#include <f77/pid.h>
      LOGICAL   verbos,query,heap
C
      DATA NAME/'DCTVF'/, amp/307.5/
 
c---------------------------------------
c  get online help if necessary
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help ()
          stop
      endif
c---------------------------------------

c----------------------------------------
c  open printout file
#include <f77/open.h>
c----------------------------------------

C
C_______________________________________________________________________
C     READ CARD IMAGE INPUT CONTROL CARDS.
C     DB.........REJECTION LEVEL FOR  FILTER IN DB.                     
C     IMODE......FILTER MODE:                                           
C                  1 = HIGHCUT
C                  2 = LOW CUT
C     F1,F2......INVARIANT LOW CUT FILTER POINTS                        
C     F3,F4......INVARIANT HIGH CUT FILTER POINTS (INVARIANT MODE ONLY)
C_______________________________________________________________________
c
c------------------------------------------------------
c   get command line parameters
      call cmdln (ntap,otap,ffile,db,amp,lw,verbos)
c------------------------------------------------------
      if(verbos) write(LERR,*)' Program DCTVF Begins'
c------------------------------------------------------
c  open I/O file(pipes)
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
c------------------------------------------------------

c------------------------------------------------------
C  READ LINE HEADER
      lbytes=0
      CALL RTAPE (LUIN,ITR,LBYTES)
      if(lbytes .eq. 0) then
         write(LERR,*)'DCTVF: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
c------------------------------------------------------

c----------------------------------------
c   save key values from line header
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      CALL HLHprt(ITR,LBYTES,NAME,5, LERR)
c----------------------------------------
c   write header
      call savhlh ( itr, lbytes, lbyout )
      call wrtape(luout,itr,lbyout)
c----------------------------------------
          TDEL = nsi * unitsc
c-------------------------------------------
c   get frequencies from input file
      open(21,file=ffile)
      write(LERR,*) 'DAFD frequencies read',ffile
      lgmax = 0
      do 50 j=1,maxflt
         read(21,*,end=51) f1,f2,f3,f4
         write(LERR,*)'f1= ',f1,' f2= ',f2,' f3= ',f3,' f4= ',f4
         CALL FILTI(LFMAX,2,TDEL,40.,F1,F2,F3,F4,BUF,LG(j),G(1,j)) 
         if (LG(j) .gt. LFMAX) LG(j) = LFMAX
         ISH(j) = LG(j)/2     
         if (lg(j) .ge. lgmax) lgmax = lg(j)
   50 continue
   51 nfilt=j-1
      if(nfilt .eq. 0) then
         write(LERR,*)'No dafd frequencies read'
         write(LERR,*)'Check frequency file for existence & contents'
         stop
      endif
      if(nfilt .gt. 100) then
         write(LERR,*)'Too many dafd frequencies read'
         write(LERR,*)'Reduce number of filters in file'
         stop
      endif
      lw=lw/nsi
      amp=20.47*amp

c---------------------------------------------
c  verbos printout
        WRITE(LERR,*)' VALUES READ FROM LINE HEADER'
        write(LERR,*)' # samples/trace   =  ',nsamp
        write(LERR,*)' sample interval   =  ',nsi
        write(LERR,*)' traces/recod      =  ',ntrc
        write(LERR,*)' recorde/line      =  ',nrec
        write(LERR,*)' format of data    =  ',iform
        write(LERR,*)' db = ',db
        write(LERR,*)' scaling amplitude =  ',amp
        write(LERR,*)' scaling window    =  ',lw,'  (samples)'
        write(LERR,*)' max filter length =  ',lgmax
        write(LERR,*)' number of filters = ',nfilt

c----------------------------------------------------------------------
c  if no. tr/rec exceeds MXTR adjust the number traces read in at
c  one time 
c----------------------------------------------------------------------
      nrecs = nrec
      ntr = ntrc
C_______________________________________________________________________
C     READ IN RECORDS AND INITIALIZE SOME FILTER PARAMETERS
C_______________________________________________________________________
C$$
      lx=nsamp
      IF(LX .GT. MXNT) THEN
         WRITE(LERR,*) ' ERROR IN SCTVF.'
         WRITE(LERR,*) ' NO. OF SAMPLES LX =',LX,' EXCEEDS MXNT',MXNT
         STOP 101
      ENDIF
 
C_______________________________________________________________________
C     ECHO INPUT.
c_______________________________________________________________________
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap  = .true.
      itemx = lx
      itemy = (lx + lgmax)
      write(LERR,*)'itemx= ',itemx,' itemy= ',itemy

      call galloc (wkadrx, itemx*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkadrz, itemx*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      call galloc (wkadry, itemy*SZSMPD, errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemy*SZSMPD,'  bytes'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemx*SZSMPD,'  bytes'
         write(LER ,*) itemx*SZSMPD,'  bytes'
         write(LER ,*) itemy*SZSMPD,'  bytes'
         stop 666
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemx*SZSMPD,'  bytes'
         write(LERR,*) itemy*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif


C_______________________________________________________________________
C_______________________________________________________________________
C_______________________________________________________________________
C     PROCESS ALL THE TRACES.
C_______________________________________________________________________
c  do all records

      call vclr (x, 1, itemx)
      call vclr (y, 1, itemy)

      DO  100  JJ = 1,nrec


      DO   99  KK = 1,ntrc

         nbytes=0
         call rtape(luin,itr,nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
               call vclr (z, 1, nsamp)
               call saver2(itr,ifmt_StaCor,l_StaCor,
     1                     ln_StaCor, istatic, TRACEHEADER)

         IF ( istatic .ne. 30000 ) THEN
c
c work over all frequency bands ***********************************************
            do 71 jf=1,nfilt

               call vmov (xtr, 1, x, 1, lx)
               call fold (LG(jf), G(1,jf), LX, X, LO, Y)

               iyj = ish(jf)
               call vsmul (y(iyj+1), 1, tdel, x, 1, lx)

c       for each trace agc...
               call dagc(lx, lw, amp, x, f)

               call vma (f, 1, x, 1, z, 1, z, 1, lx)

   71       continue

         ENDIF
            
c
c  finish frequency loop ******************************************************
C     do output 
        call vmov (z, 1, itr(ITHWP1), 1, nsamp)

        call wrtape(luout,itr,nbytes)

   99 CONTINUE

         write(LERR,*)'Processed record  ',jj

  100 CONTINUE
C
  999 continue
      write(LERR,*)'DCTVF: end of file'
      call lbclos(luin)
      call lbclos(luout)
      STOP
      END

c-------------------------------
c  online help section
c-------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)'Here are the Command Line Parameters for DCTVF'
        write(LER,*)'       -- time (in)variant filter'
        write(LER,*)' '
        write(LER,*)'Input.......................................(def)'
        write(LER,*)'-N{} -- replace {} with input data set name(stdin)'
        write(LER,*)'-O{} -- output data set name (stdout)'
        write(LER,*)'-db{} - rejection level for filter in db (40)'
        WRITE(LER,*)'-a{} -- scaling amplitude for agc            (15%)'
        write(LER,*)'-w{} -- scaling window for agc            (500 ms)'
        write(LER,*)'-f{} -- name of file containing dafd frequencies'
        write(LER,*)'-V    - if present give verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      dctvf -N{} -O{} -db{} -a{} -w{} -f{} -V'
        write(LER,*)' '

      return
      end


c-----
c     get command arguments
c
c     ntap  - C*255  input file name
c     otap  - C*255  output file name
c     file  - C*255  frequency file
c      db   - R      rejection of filters
c     amp   - R      % scale (2047)
c      lw   - I      scaling window
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,file,db,amp,lw,verbos)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), file*(*)
      integer    argis,lw
      real       db,amp
      logical    verbos

          call argstr('-N',ntap,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argr4('-db',db,40.,40.)
          call argr4('-a',amp,15.,15.)
          call argi4('-w',lw,500,500)
          call argstr('-f',file,' ',' ')
          verbos = (argis('-V') .gt. 0)
          if(file .eq. ' ') then
             write(LERR,*)'No frequency file specified -- FATAL'
             stop
          endif

      return
      end
