C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward_dft(Record, Headers, Space, nsamp,
     :     ntrc, ist, iend, fmin, fmax, fint, nsi, 
     :     Num_Freqs,
     :     amp, faze, Out_Data,unit_scale, stable,t)
c
c     Subroutine to compute the forward DFT
c
c     Output is of the form amplitude and phase
c     The inverse transform converts the amplitude and
c     phase back into the Fourier components (complex domain).
c     This has been done so that the user can work with either
c     phase or ampltidue and get back to the correct form.
c
c     James M. Gridley, Greg Partyka
c     USP Team
c     Tulsa OK
c     Fall 1997
c
#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend,StaCor
      integer Headers(ITRWRD*ntrc)

      real Record(nsamp, ntrc), Space(nsamp,ntrc)
      real stable(SZLNHD),t(SZLNHD)

c local variables

      real amp(Num_Freqs,ntrc), faze(Num_Freqs,ntrc)
      real pie, radeg
      real fmin, fmax, fint, unit_scale
      real Out_Data(Num_Freqs*2,ntrc)

      complex csum
      
      integer Num_Freqs
c initialize variables


      pie = 4.0 * atan(1.0) 
      radeg = 180. / pie
      csum = (0., 0.)

      do i = 1, nsamp
         do j = 1, ntrc
            Space(i,j) = 0.0
         enddo
      enddo
      
c     process data
      
      hdr_index = 0
      
      DO j = 1, ntrc
         
c     define pointers to header words required by your routine
         
         call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :        TRACEHEADER )
         
c     get header value
         
         hdr_index = (j-1) * ITRWRD + 1 

         call saver2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER)
c     process live traces only
         
         if ( StaCor .ne. 30000 ) then
                       
c======================================================================
c     Calculate mean of trace and remove it
               
               tmean = 0.
               
               do i = 1, nsamp
                  Space(i,j) =   Record(i,j)*t(i)
                  tmean = tmean +  Space(i,j)
               enddo
               tmean = tmean / nsamp
               
               do i = 1,nsamp
                  Space(i,j) =   Space(i,j)  
     :                 - tmean

               enddo
c     Calculate the forward transform using the cis function
               csum = (0.,0.)
               do 100 k = 1, Num_Freqs
                  df = (k-1)*fint + fmin
                  
                  do 99 i = 1, nsamp
                     csum = (cmplx (
     :                    (cos(df*stable(i))),
     :                    -(sin(df*stable(i)))))
     :                    * (cmplx(Space(i,j),0.))
     :                    + csum
                     
 99               enddo
                  
c     Break down the complex sum into the real value representations
                  xr = real(csum)
                  xi = aimag(csum)
                  
c     Calculate the amplitude value 
               amp(k,j)=(sqrt(xr*xr + xi*xi))/nsamp
               Out_Data(k,j)=amp(k,j)
c     Calcute the phase value
               faze(k,j) = radeg*( atan2(xi,xr))
               Out_Data(k+Num_Freqs,j)=faze(k,j)
                
c     Reset the summation to zero
                csum=(0.,0.) 
               
 100        enddo
            
c     if trace is not live give the spectra all zeroes
         elseif (StaCor .eq. 30000) then
            do i=1,Num_Freqs
               amp(i,j)=0.
               faze(i+Num_Freqs,j)=0.
               Out_Data(k,j)=0.
               Out_Data(k+Num_Freqs,j)=0.
            enddo
         endif
         
      ENDDO

      return
      end
