C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  inverse_dft ( Record, Headers, 
     :     Space, nsamp, 
     :     ntrc, ist, iend, fmin, fmax, fint, 
     :     nsi, Num_Freqs,
     :     amp, faze, cdata, unit_scale, inv_stable,
     :     Out_Data)

c
c     Subroutine to compute the forward DFT
c
c     Input is of the form amplitude and phase
c     The inverse transform converts the amplitude and
c     phase back into the Fourier components (complex domain).
c     This has been done so that the user can work with either
c     phase or ampltidue and get back to the correct form.
c
c     James M. Gridley, Greg Partyka
c     USP Team
c     Tulsa OK
c     Fall 1997

#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend, nsi, StaCor
      integer Headers(ITRWRD*ntrc)

      real Record(Num_Freqs*2, ntrc), Space(Num_Freqs*2,ntrc) 

      real amp(Num_Freqs,ntrc), faze(Num_Freqs,ntrc)
      real inv_stable(SZLNHD), Out_Data(nsamp,ntrc)

      real pie, radeg, fmin, fmax, fint, unit_scale
      
      complex csum, cdata(SZLNHD*2)

c     local variables

      pie= 4.0 * atan(1.0) 
      radeg=180./pie
      csum = (0., 0.)
      
c     initialize variables
     
      
c     process data
      
      hdr_index = 0

      do j = 1, ntrc
         do i=1,Num_Freqs
            amp(i,j)=Record(i,j)
            faze(i,j)=Record(i+Num_Freqs,j)
         enddo
      enddo
      
      DO 400 j = 1, ntrc
       
c     define pointers to header words required by your routine
         
         call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :        TRACEHEADER )
         
c     get header value
         
         hdr_index = (j-1) * ITRWRD + 1 
         call saver2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER)
         
c     process live traces only
         
         if ( StaCor .ne. 30000 ) then
c======================================================================
c     Convert the amplitude and phase compoments into the Fourier
c     componets (complex domain)

            do 503 i = 1, Num_Freqs
               cdata(i)=(0.,0.)
               cdata(i) =  cmplx (
     :              amp(i,j) * nsamp *(cos (faze(i,j)/radeg)),
     :              amp(i,j) * nsamp *(sin (faze(i,j)/radeg)))
 503        enddo
c======================================================================
c     set csum initially to zero
            csum=(0.,0.)

c======================================================================
c     Set up the summation and perform

            do 501 k = 1, nsamp
              
               dt = (float(k-1)*(float(nsi)*unit_scale))
               do 502 i = 1, Num_Freqs

                  csum  = (cmplx(
     :                 (cos(inv_stable(i)*dt)),
     :                 (sin(inv_stable(i)*dt))))
     :                 * cdata(i) + csum
 502           enddo
                
               Out_Data(k,j) =  (real(csum))/(Num_Freqs) 
             
               csum=(0.,0.)
               
 501        enddo
c=======================================================================
         elseif(StaCor .eq. 30000) then
            do i = 1, nsamp
               Out_Data(i,j) = 0.
            enddo   
         endif
         
 400  ENDDO
      
      
      return
      end
