C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tapers (dt,dx,vel,zd,pct,epsilon,ntrc,nsamp,
     1                   nsmp4,ntrc4,nsmpe,ntrce,ntro,ift,ifx,d4,t4,
     2                   fh,maxdim,fac,tpt,tps,cop)

#include <f77/iounit.h>

      complex    cop(nsmpe,ntrce)
      real       tpt(*),tps(*)
      real       knz2, k2, knzw
      complex    wnz, czero
      integer    ntrc,nsamp,ntrc4,nsmp4,ntrce,nsmpe,ntro,ift,ifx
      real       dt,dx,zd,pct,epsilon,d4,t4,fh
      real       pi

      czero = cmplx (0.,0.)
      pi = 3.14159265

c       if (fh .eq. 0.) then
           fh = 0.5
c       endif
           
        ntpi = aint(.01*pct*nsamp/2)
        ntpj = aint(.01*pct*ntrc/2)
c       dw   = 2*pi/t4
        dw   = 4*pi/t4
c       dwn  = 2*pi/d4
        dwn  = 4 * pi/d4
        fac  = float(ifx) * float(ift)* (float(ntrc4 * nsmp4))
        r    = epsilon - 1.


c------------
c time taper
c------------
        do  140  i = 1, nsamp
           if(i .gt. ntpi) go to 141
             tpt(i) = (1 - cos( pi*(i-1)/ntpi ) )/2
             go to 140
141        if(i .gt. nsamp-ntpi) go to 142
             tpt(i) = 1.
             go to 140
142          tpt(i) = (1 - cos( pi*(nsamp-i)/ntpi ) )/2
140     continue

c------------
c space taper
c for now it's fixed
c to be the fully live spread length
c------------
        do  240  i = 1, ntrc
           if(i .gt. ntpj) go to 241
             tps(i) = (1 - cos( pi*(i-1)/ntpj ) )/2
             go to 240
241        if(i .gt. ntrc-ntpj) go to 242
             tps(i) = 1.
             go to 240
242          tps(i) = (1 - cos( pi*(ntrc-i)/ntpj ) )/2
240     continue

      write(LERR,*)' '
      write(LERR,*)'Time taper:'
      do  301  i = 1, nsamp, 8
          write(LERR,500)i,(tpt(i+ii-1),ii=1,8)
500       format(i5,5x,8f7.3)
301   continue
      write(LERR,*)' '
      write(LERR,*)'Space taper:'
      do  302  i = 1, ntrc, 8
          write(LERR,500)i,(tps(i+ii-1),ii=1,8)
302   continue
      


c*******************************************************************
c (1) compute deghost operator in w,wn domain interval (0,pi/dt),(0,pi,dx)
c     by oversampling with w increment dw/ift, wn increment dwn/ifx
c (2) taper operator at w Nyquist
c (3) fill out rest of w,wn domain by symmetry
c (4) transform to t,x domain and window
c (5) transform to w,wn domain with dw,dwn sampling
c*******************************************************************

        ntpi = aint(.01*pct*nsmpe/2)
        ntpj = aint(.01*pct*ntrce/2)
c       nsmpe21 = nsmpe/2 + 1
c       ntrce21 = ntrce/2 + 1
        nsmpe21 = nsmpe/2
        ntrce21 = ntrce/2

        DO  100  i = 1, nsmpe21

           w = fh*float(i-1)*dw/float(ift)
           if(i .ge. ntpi .AND. i .le. nsmpe/2-ntpi)then
              tpi = 1.
           elseif(i .gt. nsmpe/2-ntpi)then
              tpi = (1. - cos( pi*(nsmpe21-i)/float(ntpi) ) )/2.
           elseif(i .lt. ntpi)then
              tpi = (1. - cos( pi*(i-1)/float(ntpi) ) )/2.
           endif

           do 110  j = 1, ntrce21

              if(j .le. ntrce/2-ntpj)then
                 tpj = 1.
              else
                 tpj = (1. - cos( pi*(ntrce21-j)/float(ntpj) ) )/2.
              endif

              wnx  = fh*float(j-1)*dwn/float(ifx)
              k2   = (w/vel)**2

              IF (w .ne. 0.0) THEN
                 knz2 = wnx**2 - k2
                 knzw = sqrt ( abs(knz2) / k2 )
                 if(knz2 .gt. 0.)then
                    wnz = cmplx( sqrt( knz2 ), 0.)
                 elseif (knz2 .lt. 0.) then
                    wnz = cmplx( 0., sqrt( -knz2 ) )
                 else
                    wnz = czero
                    knzw = 0
                 endif
                 cop(i,j) = knzw * tpi * tpj /
     1                      ( cexp (wnz*zd) + r*cexp(-wnz*zd) )

              ELSE
                 cop(i,j) = czero
              ENDIF

                 cop(nsmpe-i+1,j)         = conjg( cop(i,j) )
                 cop(nsmpe-i+1,ntrce-j+1) = conjg( cop(i,j) )
                 cop(i,ntrce-j+1)         = cop(i,j)

110        continue

100     CONTINUE

         call cfft2d (cop, nsmpe, ntrce, -1)

        fac2 =  fac

        do  120  i = 1, nsmpe
            do  130  j = 1, ntrce
                cop(i,j) = cop(i,j) / fac2
130         continue
120     continue

         call cfft2d (cop, nsmpe, ntrce, +1)

      return
      end
