C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C********************************************************************   DIF00010
C
C     PROGRAM MODULE DIFFR
C
C**********************************************************************C
C
C DIFFERENTIATES TRACE DATA BY DESIGNING A DESCRETE OPERATOR WHICH IS
C CONVOLVED WITH INPUT TRACE DATA.
C THIS PROGRAM IS A MODIFIED VERSION OF KEN PEACOCK'S DIFR SUBROUTINE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c     INCLUDE 'IOUNIT.INC'
c     INCLUDE 'LHDRSZ.INC'
c     INCLUDE 'SISDEF.INC'
c     INCLUDE 'PID.INC'
C
      REAL        XTR  (SZLNHD), YTR(SZLNHD+513), F(513)
      INTEGER     IXTR (SZLNHD)
      INTEGER     LHED(SZLNHD)
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,  LBYOUT,LBYTE
#include <f77/pid.h>
      CHARACTER   NTAP * 256, OTAP * 256, NAME*5, ITYP*4
      LOGICAL     VERBOS, QUERY, irever, integ
      INTEGER     ARGIS, stacor, recnum
C
      EQUIVALENCE ( IXTR(  1), LHED(1) )
c     EQUIVALENCE ( IXTR(129), XTR(1) )
      DATA LBYTES / 0 /, NBYTES / 0 /, NAME/'DIFFR'/, LFM/512/
C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE CARD IMAGE FILE
      QUERY = ( ARGIS ( '-?' ) .GT. 0 )
      IF ( QUERY )THEN
            CALL HELP()
      STOP
      ENDIF
C     OPEN PRINTOUT FILES
c     INCLUDE 'OPEN.INC'
#include <f77/open.h>
      CALL GCMDLN(NTAP,OTAP,NS,NE,IRS,IRE,
     :            VERBOS,F2,DB,ITYP,NORD,irever,integ)
C
C     GET LOGICAL UNIT NUMBERS FOR INPUT AND OUTPUT
      CALL GETLN(LUIN , NTAP,'r', 0)
      CALL GETLN(LUOUT, OTAP,'w', 1)
C
C     READ LINE HEADER OF INPUT
C     SAVE CERTAIN PARAMETERS
C
      LBYTES = 0
c     CALL RTAPE4  ( LUIN, IXTR, LBYTE,  LBYTES)
      CALL RTAPE  ( LUIN, IXTR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(LOT,*)'DIFFR'
         WRITE(LOT,*)'FATAL'
         STOP
      ENDIF
      CALL SAVER(IXTR, 'NumSmp', NSAMP, LINHED)
      CALL SAVER(IXTR, 'SmpInt', NSI  , LINHED)
      CALL SAVER(IXTR, 'NumTrc', NTRC , LINHED)
      CALL SAVER(IXTR, 'NumRec', NREC , LINHED)
      CALL SAVER(IXTR, 'Format', IFORM, LINHED)
      call saver(IXTR, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(IXTR, 'UnitSc', unitsc, LINHED)
      endif

c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C
C     MODIFY LINE HEADER TO REFLECT ACTUAL NUMBER OF TRACES OUTPUT
      CALL CMDCHK(NS,NE,IRS,IRE,NTRC,NREC)
      call hlhprt (ixtr, lbytes, name, 5, LERR)
      NRECC=IRE - IRS+1
      CALL SAVEW(IXTR, 'NumRec', NRECC, LINHED)
      JTR=NE-NS+1
      CALL SAVEW(IXTR, 'NumTrc', JTR  , LINHED)
      CALL SAVHLH(IXTR,LBYTEs,LBYOUT)
      CALL WRTAPE ( LUOUT, IXTR, LBYOUT                 )
C
C     VERBOSE OUTPUT OF ALL PERTINENT INFORMATION BEFORE
      IF( VERBOS ) THEN
                CALL VERBAL(NSAMP, NSI, NTRC, NREC, IFORM,
     :                  NTAP,OTAP,F2,DB,ITYP,NORD,integ)
      END IF
C
C     SAMPLE INTERVAL IN SECONDS AND NYQUIST FREQUENCY

      tdel = real (nsi) * unitsc

      fnyq= 1.0 / (2. * tdel)
C
      if (.not.integ .AND. f2 .ge. fnyq) then
	 write (ler,*)
     :   '__________________________________________________'
	 write (ler,*)
     :   'THE UPPER FREQENCY SELECTED IS GREATER THAN OR'
	 write (ler,*)
     :   'EQUAL TO THE NYQUIST FREQUENCY.'
	 write (ler,*)
     :   '__________________________________________________'
         stop
      endif
C
c     CALL SKPREC(1,IRS-1,LUIN,NTRC,IXTR,LBYTES,NSAMP,IFORM)
      call recskp(1,irs-1,luin,ntrc,IXTR)
C
C     BEGIN PROCESSING
      IF (integ) THEN
               WRITE(LERR,*)'TRACE INTEGRATION BEGINS'
      ELSE
               WRITE(LERR,*)'TRACE DIFFERENTIATION BEGINS'
C
C     CALCULATES SPECIAL DIFFERENTIATION OPERATOR
               CALL DIFI(LFM,ITYP,TDEL,F2,DB,LF,F)        
C
               if ((lf .gt. lfm) .or. (lf .lt. 0)) then
	           write (ler,*)
     :             '__________________________________________________'
	           write (ler,*)
     :             'THE FILTER LENGTH REQUIRED TO ACHEIVE ',DB,'dB'
	           write (ler,*)
     :             'ACCURACY AT AN UPPER FREQUENCY OF ',f2,' HZ IS'
	           write (ler,*)
     :             'GREATER THAN THE MAXIMUM ALLOWED, ',LFM,' POINTS.'
	           write (ler,*)
     :             'GENERALLY THE UPPER FREQUENCY F2 SHOULD BE LESS'
	           write (ler,*)
     :             'THAN 95% OF NYQUIST.'
	           write (ler,*)
	           write (ler,*)
     :             'PLEASE LOWER THE UPPER FREQUENCY AND ACCURACY'
	           write (ler,*)
     :             '__________________________________________________'
                   stop
               endif
C
	       write (lerr,*) 'filter values'
	       write (lerr,*)  (f(i),i=1,lf)
      ENDIF
C
C     PROCESS DESIRED TRACE RECORDS
C     READ TRACE, CONVOLVE WITH DIFFERENTIATION FILTER, WRITE TRACE

      DO 1000 JJ = IRS, IRE
            DO 1001 KK=1, NTRC

                  NBYTES = 0
                  CALL RTAPE ( LUIN, IXTR, NBYTES)
                  IF(NBYTES .EQ. 0) THEN
                     WRITE(LERR,*)'END OF FILE ON INPUT:'
                     WRITE(LERR,*)'  REC= ',JJ,'  TRACE= ',KK
                     GO TO 9999
                  ENDIF
                  call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
c------
c     use previously derived pointers to trace header values
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  call vclr (ytr, 1, nsamp)
                  if (stacor .eq. 30000) then
                     call vclr (xtr, 1, nsamp)
                  endif


                  if (irever) then
                     call vrvrs (xtr,1,nsamp)
                  endif

                  IF (integ) THEN

                     sumi = 0.
                     do  i = 1, nsamp
                         sumi = sumi + xtr(i)
                         ytr(i) = sumi
                     enddo

                  ELSE

C                    CONVOLVES DIFFERENTATION FILTER WITH INPUT DATA ARRAY
C                    NORD TIMES TO PROVIDE THE APPROPRIATE ORDER DERIVATIVE

                     DO 1002 II = 1, NORD
                         CALL CONVL(NSAMP,XTR,LF,F,LY,YTR)                      
C
C                        APPLIES A 48 MS RAMP AT TRACE END TO REMOVE THE
C                        UNDESIRABLE EFFECT OF CONVOLVING THE DIFFERENTIATION
C                        FILTER OFF THE END OF THE TRACE
C
                         NRAMP = IFIX(0.048 / TDEL)
                         IST = NSAMP - NRAMP + 1

                         DO 1003 LL = IST,NSAMP
                             SCL = FLOAT(NSAMP-LL)/FLOAT(NRAMP)
                             YTR(LL) = YTR(LL) * SCL
 1003                    CONTINUE

 1002             CONTINUE
                                                                      
                  ENDIF

                  if (irever) then
                     call vrvrs (ytr,1,nsamp)
                  endif

                  call vmov (ytr, 1, lhed(ITHWP1), 1, nsamp)
                  CALL WRTAPE( LUOUT, ixtr, NBYTES)
 1001       CONTINUE

            IF(VERBOS) WRITE(LERR,*)'PROCESSED RECORD',recnum

 1000       CONTINUE
C
C     PROCESSING ENDS
C     CLOSE DATA FILES
 9999 CONTINUE
      CALL LBCLOS ( LUIN )
      CALL LBCLOS ( LUOUT )
      IF(VERBOS) THEN
            WRITE(LERR,*)'END OF DIFFR, PROCESSED',NREC,' RECORD(S)',
     :               ' WITH ',NTRC, ' TRACES'
      ENDIF
      stop
      END
C*********************************************************************
C
      SUBROUTINE HELP
C
c     INCLUDE 'IOUNIT.INC'
#include <f77/iounit.h>
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE DIFFR  ----  TRACE DIFFERENTIATION'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program DIFFR differentiates trace data by designing an operator'
      WRITE(LER,*)
     :'accurate to an input decibel level db at the upper frequency fu.'
      WRITE(LER,*)
     :'fu should be less than 0.95 of Nyquist. Either a Ross or'
      WRITE(LER,*)
     :'Bessel weighting is specified by the user. The operator is then'
      WRITE(LER,*)
     :'convolved with the input data traces to output the (nord) order'
      WRITE(LER,*)
     :'derivative specified by the user.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute DIFFR  by typing diffr followed by program parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]    (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]    (no default) : output data file name'
        WRITE(LER,*)
     :' -rs [IRE]    (1st rec)    : starting record number '
        WRITE(LER,*) 
     :' -re [IRE]    (last rec)   : final record number '
      WRITE(LER,*)
     :' -ityp [ITYP]   (BESS)     : Weighting Type       '
      WRITE(LER,*)
     :'                             BESS = Bessel Weighting'
      WRITE(LER,*)
     :'                             ROSS = Ross Weighting'
      WRITE(LER,*)
     :' -fu [fu]     ( 60 )       : Upper Frequency (Hz)  '
      WRITE(LER,*)
     :' -db [DB]     ( 40 )       : Accuracy critera (dB)      '
      WRITE(LER,*)
     :' -nord [NORD]  ( 1 )       : Order of the derivative to output'
      WRITE(LER,*)
     :' -I           ( no )       : running sum integration (overrides'
     :                         //' -nord option'
      WRITE(LER,*)
     :' -V [VERBOS]  ( no )       : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' diffr -N/home/data/ntap -O/home/data/otap -itypROSS -fu80 -db65'
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      RETURN
      END
C***********************************************************************
      SUBROUTINE GCMDLN(NTAP,OTAP,NS,NE,IRS,IRE,VERBOS,F2,DB,ITYP,NORD,
     :                  irever,integ)
C
C     GET COMMAND ARGUMENTS
C
C     NTAP  - C*120     INPUT FILE NAME
C     OTAP  - C*120     OUTPUT FILE NAME
C     NS    - I*4 STARTING TRACE INDEX
C     NE    - I*4 ENDING TRACE INDEX
C     IRS   - I*4 STARTING RECORD INDEX
C     IRE   - I*4 ENDING RECORD INDEX
C     VERBOS      - L   VERBOSE OUTPUT OR NOT
C
C***********************************************************************
C
#include <f77/iounit.h>
c     INCLUDE 'IOUNIT.INC'
      CHARACTER NTAP*(*), OTAP*(*), ITYP*(*)

      LOGICAL VERBOS, irever, integ
      INTEGER *4 NS, NE, IRS, IRE
      INTEGER ARGIS

            CALL ARGSTR( '-N', NTAP, ' ', ' ' )
            CALL ARGSTR( '-O', OTAP, ' ', ' ' )
            CALL ARGSTR( '-ityp', ITYP, 'BESS', 'BESS' )
            CALL ARGI4 ( '-ns', NS ,   0  ,  0    )
            CALL ARGI4 ( '-ne', NE ,   0  ,  0    )
            CALL ARGI4 ( '-rs', IRS ,   0  ,  0    )
            CALL ARGI4 ( '-re', IRE ,   0  ,  0    )
            CALL ARGR4 ( '-fu', F2 , 60.0  , 60.0   )
            CALL ARGR4 ( '-db', DB , 40.0  , 40.0   )
            CALL ARGI4 ( '-nord', NORD ,   1  ,  1    )
            VERBOS = ( ARGIS( '-V' ) .GT. 0 )
            irever = ( ARGIS( '-REV' ) .GT. 0 )
            integ  = ( ARGIS( '-I' ) .GT. 0 )
            if(integ) nord=-1
      RETURN
      END
C******************************************************************
      SUBROUTINE VERBAL(NSAMP, NSI, NTRC, NREC, IFORM,
     :                  NTAP,OTAP,F2,DB,ITYP,NORD,integ)
C
C     VERBOSE OUTPUT OF PROCESSING PARAMETERS
C
C     NSAMP - I*4 NUMBER OF SAMPLES IN TRACE
C     NSI   - I*4 SAMPLE INTERVAL IN MS
C     NTRC  - I*4 TRACES PER RECORD
C     NREC  - I*4 NUMBER OF RECORDS PER LINE
C     IFORM - I*4 FORMAT OF DATA
C     NTAP  - C*120     INPUT FILE NAME
C     OTAP  - C*120     OUTPUT FILE NAME
C
C****************************************************************
C
#include <f77/iounit.h>
c     INCLUDE 'IOUNIT.INC'
      INTEGER NSAMP, NSI, NTRC, NREC, IFORM
      logical integ
      CHARACTER NTAP*(*), OTAP*(*), ITYP*(*)
C
            WRITE(LERR,*)' '
            WRITE(LERR,*)' LINE HEADER VALUES AFTER DEFAULT CHECK '
            WRITE(LERR,*) ' # OF SAMPLES/TRACE........', NSAMP
            WRITE(LERR,*) ' SAMPLE INTERVAL...........', NSI
            WRITE(LERR,*) ' TRACES PER RECORD.........', NTRC
            WRITE(LERR,*) ' RECORDS PER LINE..........', NREC
            WRITE(LERR,*) ' FORMAT OF DATA............', IFORM
            WRITE(LERR,*) ' WEIGHTING TYPE............', ITYP
            WRITE(LERR,*) ' UPPER FREQUENCY (HZ).. ...', F2
            WRITE(LERR,*) ' ACCURACY CRITERIA.(dB)....', DB
            WRITE(LERR,*) ' ORDER OF THE DERIVATIVE...', NORD
            WRITE(LERR,*) ' INTEGRATE DATA?...........', integ
            WRITE(LERR,*) ' INPUT FILE................', NTAP
            WRITE(LERR,*) ' OUTPUT FILE...............', OTAP
            WRITE(LERR,*)' '
C
      RETURN
      END
c****************************************************************
      SUBROUTINE DIFI(LFM,ITYPE,TDEL,F2,DB,LF,F)
C                                                                      
C     A CONFIDENTIAL AMOCO SUBROUTINE.                                  
C             ADAPTED FROM KEM PEACOCKS DIFI PROGRAM                    
C                                                                      
C     SUBROUTINE DIFI CONSTRUCTS THE OPERATOR FOR THE DIFFERIENTATION   
C     FILTER.  OPERATOR LENGTH AND WEIGHT STRENGTH ARE COMPUTED BY THE  
C     SUBROUTINE.  EITHER ROSS OR BESSEL WEIGHTING MAY BE SPECIFIED.  
C                                                                      
C     INPUTS :                                                         
C                                                                      
C        LFM  =  MAXIMUM LENGTH TO ALLOW FOR OPERATOR, LFM ODD.         
C      ITYPE  =  TYPE OF WEIGHTING DESIRED, ROSS or BESS.    
C                ROSS EQ ROSS WEIGHTING
C                BESS EQ BESSEL WEIGHTING
C                DEFAULT IS BESSEL WEIGHTING
C       TDEL  =  SAMPLE INCREMENT IN SECONDS.                           
C         F2  =  UPPER FREQUENCY WHERE AMPLITUDE SPECTRUM WILL BE      
C                ACCURATE TO DB DECIBELS.                               
C         DB  =  ACCURACY FOR FILTER AMPLITUDE SPECTRUM, IN DB. THE    
C                RESULTING  FILTER HAS AN AMPLITUDE SPECTRUM THAT IS    
C                ACCURATE TO DB DECIBELS FROM 0 TO F2 HZ.               
C                                                                       
C     OUTPUTS :                                                         
C                                                                       
C         LF  =  LENGTH OF OPERATOR. (IF LF EQUALS LFM, THE CRITERIA    
C                COULD NOT BE MET IN LFM SAMPLES.)                      
C          F  =  THE OUTPUT OPERATOR.                                   
C                                                                       
C*******************************************************************    
C
      REAL F(1)                                             
      CHARACTER ITYPE*(*)
C
      IF ( ITYPE .EQ. 'ROSS' ) THEN
          EX = -.92862+.011011*DB**1.609                                    
          LF = (-.015032+.0094450*DB**1.433)/((1./(2.*TDEL)-F2)*TDEL)       
      ELSE                                                      
          EX = -4.3937+.95532*DB**.594                                      
          LF = (-.10844+.039068*DB**.980)/((1./(2.*TDEL)-F2)*TDEL)        
      ENDIF
C
      IF( EX .LT. 0. ) EX = 0.                                             
      LF = LF/2*2+1                                                    
C
C     IF THE FILTER LENGTH IS UNREASONABLE----RETURN                   
      IF ((LF .GT. LFM) .OR. (LF .LT. 0)) RETURN
C
      FACT = TDEL*TDEL                                                
      N = LF/2                                                        
      ISTA = N+2                                                      
      KFACT = 1-ISTA                                                   
      JFACT = LF+1                                                    
      SIGN = 1.                                                        
C
      DO 5 I=ISTA,LF                                                    
          AK = I+KFACT                                                     
          F(I) = -SIGN/(AK*FACT)                                          
          J = JFACT-I                                                     
          F(J) = -F(I)                                                 
          SIGN = -SIGN                                                 
5     CONTINUE
C
      F(ISTA-1) = 0.                                                   
      IF(EX.EQ.0.) RETURN                                         
C
      IF ( ITYPE .EQ. 'ROSS' ) THEN
C         ROSS WEIGHTING                                   
          DO 7 I=ISTA,LF                                                  
              AK = I+KFACT                                                  
              F(I) = F(I)*((1.-(AK/N)**2)**EX)                             
              J = JFACT-I                                                     
              F(J) = -F(I)                                                  
7         CONTINUE
      ELSE                                                     
C         BESSEL WEIGHTING.                                 
          DEN = 1.                                                         
          DS = 1.                                                          
          D = 0.                                                           
C
9         D = D+2.                                                       
          DS = DS*EX*EX/(D*D)                                             
          DEN = DEN+DS                                                 
          IF(DS.GT..2E-8*DEN) GO TO 9                                     
C
          DO 11 I=ISTA,LF                                                 
              AK = I+KFACT                                            
              EXX = EX*SQRT(1.-(AK/N)**2)                                   
              ANUM = 1.                                                    
              DS = 1.                                                   
              D = 0.                                                        
C
10            D = D+2.                                                          
              DS = DS*EXX*EXX/(D*D)                                         
              ANUM = ANUM+DS                                               
              IF(DS.GT..2E-8*ANUM) GO TO 10                                   
C
              F(I) = F(I)*ANUM/DEN                                         
              J = JFACT-I                                                  
              F(J) = -F(I)                                                 
11        CONTINUE
      ENDIF
C                                                                   
      RETURN                                                       
      END                                                            
C********************************************************************   CON00010
      SUBROUTINE CONVL(LX,X,LF,F,LY,Y)                                  CON00020
C                                                                       CON00030
C     A CONFIDENTIAL AMOCO SUBROUTINE.                                  CON00040
C                                                                       CON00050
C     SUBROUTINE CONVL CONVOLVES TWO INPUT DATA ARRAYS. THE OUTPUT      CON00060
C     ARRAY WILL BE THE SAME LENGTH AS THE PRIMARY INPUT DATA ARRAY.    CON00070
C     THE FILTER LENGTH MUST BE ODD.                                    CON00080
C                                                                       CON00090
C     INPUTS :                                                          CON00100
C                                                                       CON00110
C      X(LX) =  ONE DIMENSIONAL INPUT ARRAY WHICH CONTAINS THE          CON00120
C                PRIMARY DATA SERIES.                                   CON00130
C        LX  =  NUMBER OF SAMPLES IN X1                                 CON00140
C      F(LF) =  ONE DIMENSIONAL INPUT ARRAY WHICH CONTAINS THE          CON00150
C               FILTER WHICH WILL BE CONVOLED WITH X                    CON00160
C        LF  =  NUMBER OF SAMPLES IN F.                                 CON00170
C                                                                       CON00180
C     OUTPUTS :                                                         CON00190
C                                                                       CON00200
C      Y(LY)  =  OUTPUT ONE DIMENSIONAL ARRAY WHICH CONTIANS THE        CON00210
C                CONVOLVED RESULTS.                                     CON00220
C        LY   =  NUMBER OF SAMPLE POIUNTS IN Y                          CON00230
C                                                                       CON00240
C*******************************************************************    CON00250
      REAL X(1),Y(1),F(1)                                               CON00260
C                                                                       CON00270
      N=LF/2                                                            CON00280
      CALL FOLD(LX,X,LF,F,LY,Y)                                         CON00290
      DO 20 I=1,LX                                                      CON00300
          Y(I)=Y(I+N)                                                   CON00310
   20 CONTINUE                                                          CON00320
C                                                                       CON00330
      RETURN                                                            CON00340
      END                                                               CON00350
