/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <localsys.h>
#include <cu_defs.h>
#include <usp_headers.h>
#include <size_defs.h>
#include <slice.h>

main(argc,argv)
int argc;
char **argv;
{
	FILE *fdin,*fdout;
	int i,j,c;
	int verbos,force_piped_in,force_piped_out,kill_hlh,is_a_pipe();
	int hlh_entries,hlh_bytes;
	int bytes_read;
	char *header;
	long hdr_byte_count;
	char ntap[64],otap[64];
	void read_err(),write_err();
	long get_full_word(),get_half_word();
	void put_full_word(),put_half_word();
	void help();

	fprintf(stderr,"disco_fix:\n");

	if (argis("-?",&argc,argv) != 0) help();
	if (argis("-h",&argc,argv) != 0) help();
	verbos = argis("-V",&argc,argv);
	force_piped_in	= argis("-N!",&argc,argv);
	force_piped_out	= argis("-O!",&argc,argv);
	kill_hlh	= argis("-killhlh",&argc,argv);
	argstr("-N",ntap,"","",&argc,argv);
	argstr("-O",otap,"","",&argc,argv);

	if (strlen(ntap) != 0) {
	  if (verbos) fprintf(stderr,"input data set -  %s\n",ntap);
	  fdin = fopen(ntap,"r");
	  if (fdin == NULL) {
	    fprintf(stderr,"ERROR: unable to open input data set - ");
	    fprintf(stderr,"please check data set\n");
	    exit(100);
	    }
	  }
	else {
	  if (!force_piped_in && is_a_pipe(stdin)) {
	    fprintf(stderr,"ERROR: piped input not allowed\n");
	    exit(100);
	    }
	  else {
	    if (verbos) fprintf(stderr,"input data set -  stdin\n");
	    fdin = stdin;
	    }
	  }

	if (strlen(otap) != 0) {
	  if (verbos) fprintf(stderr,"output data set -  %s\n",otap);
	  fdout = fopen(otap,"w");
	  if (fdout == NULL) {
	    fprintf(stderr,"ERROR: unable to open output data set - ");
	    fprintf(stderr,"please verify permissions\n");
	    exit(100);
	    }
	  }
	else {
	  if (!force_piped_out && is_a_pipe(stdout)) {
	    fprintf(stderr,"ERROR: piped output not allowed\n");
	    exit(100);
	    }
	  else {
	    if (verbos) fprintf(stderr,"output data set -  stdout\n");
	    fdout = stdout;
	    }
	  }

	buffer.value = 0;
	if (fread(&buffer.fullword.value[0],SZGRWD,1,fdin) == 0) read_err();
	hdr_byte_count = buffer.value;

	header = (char *) malloc(hdr_byte_count);
	if (fread(header,hdr_byte_count,1,fdin) == 0) read_err();

/*
	hlh_entries = get_half_word(((IEEE_usp_line_header *)header)->HlhEnt);
	hlh_bytes = get_half_word(((IEEE_usp_line_header *)header)->HlhByt);
*/
	hlh_entries = get_half_word(header+1000);
	hlh_bytes = get_half_word(header+1002);

	if (verbos) {
	  fprintf(stderr,"\ninput:\n");
	  fprintf(stderr,"\t\tgreen word = %d\n",hdr_byte_count);
	  fprintf(stderr,"\t\tno. of HLH entries = %d\n",hlh_entries);
	  fprintf(stderr,"\t\tlength of HLH in bytes = %d\n",hlh_bytes);
	  if (kill_hlh)
	    fprintf(stderr,"\n\t\tHLH is being reset\n");
	  }

	if (kill_hlh) {
	  hlh_bytes = 12;
	  hlh_entries = 1;
	  put_half_word((header+1000),hlh_entries);
	  put_half_word((header+1002),hlh_bytes);
	  put_half_word((header+1004),(short)6);
	  strncpy((header+1006),"!RESET",6);
	  }

	hdr_byte_count = 1000+hlh_bytes;

	if (verbos) {
	  fprintf(stderr,"\noutput:\n");
	  fprintf(stderr,"\t\tgreen word = %d\n",hdr_byte_count);
	  fprintf(stderr,"\t\tno. of HLH entries = %d\n",hlh_entries);
	  fprintf(stderr,"\t\tlength of HLH in bytes = %d\n",hlh_bytes);
	  }

	buffer.value = hdr_byte_count;
	if (fwrite(buffer.fullword.value,SZGRWD,1,fdout) == 0) write_err();
	if (fwrite(header,hdr_byte_count,1,fdout) == 0) write_err();

/* the rest of the data goes out as is */

	header = (char *) realloc(header,BUFSIZ);

	while((bytes_read=fread(header,1,BUFSIZ,fdin)) != 0) {
	  bytes_read=fwrite(header,1,bytes_read,fdout);
      	  }

	fclose(fdin);
	fclose(fdout);
}
void read_err()
{
 	fprintf(stderr,
	  "ERROR: disco_fix - error reading input data\n");
	exit(100);
}

void write_err()
{
 	fprintf(stderr,
	  "ERROR: disco_fix - error writing output data\n");
	exit(100);
}
long get_full_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.fullword.value,source,SZDFWD);
	return(buffer.value);
}
long get_half_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.halfword.value,source,SZDHWD);
	return(buffer.value);
}
void put_full_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.fullword.value,SZDFWD);
	return;
}
void put_half_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.halfword.value,SZDHWD);
	return;
}
void help()
{
	fprintf(stderr,"Purpose: clean up dirty DISCO headers for USP\n");
	fprintf(stderr,"Usage: disco_fix [-N[ntap] | -N!] [-O[otap] | -O!] [-killhlh] [-V]\n");
	fprintf(stderr,"\t\t-N\t\tinput data set\n");
	fprintf(stderr,"\t\t-N!\t\taccept piped input (must be IEEE format)\n");
	fprintf(stderr,"\t\t-O\t\toutput data set\n");
	fprintf(stderr,"\t\t-O!\t\tuse piped output (must be IEEE format\n");
	fprintf(stderr,"\t\t-killhlh\treset Historical Line Header\n");
	fprintf(stderr,"\t\t-V\t\tverbose\n");
	exit(0);
}
