C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine binner ( nlive, nsamp, ntrc, ngrp, itrce_size, idist,
     :      xmod, itrce, idead, tabl1, tabl2, zz, iz, array, iflag, 
     :     verbos, ntrm, ntro, work1, work2, jdist, dx, JJ, 
     :     trhead_plus_tr_size, irec, itr_size, itr, xmod_size, ipos )

      implicit none

#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nlive, nsamp, ntrc, ngrp, itrce_size, itr_size, xmod_size
      integer ntrm, ntro, JJ, trhead_plus_tr_size, irec
      integer iflag

      integer  itrce(itrce_size), idead(itrce_size), itr(itr_size)
      integer  idist(ntrm)
      integer  iz(xmod_size)
      integer  jdist(ntrm)
      integer  ipos(ntro)

      real xmod(xmod_size), array(ntrm*nsamp)
      real tabl1(ntro), tabl2(ntro), zz(4*ntro)
      real work1(nsamp), work2(nsamp)
      real dx

      logical  verbos

c declare local variables

      integer j, istrc, ittrc, i, ic, ntrl, ntrl1

      real tmin1, tmin2, tmin

c initialize variables

      SAVE

      do j = 1, ntro
         istrc = (j-1) * trhead_plus_tr_size + 1
         ittrc = (j-1) * nsamp + 1
         call move (1, array(ittrc), idead(istrc+ITRWRD), 
     1        nsamp*SZSMPD)
      enddo

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)'Unbinned trace distances'
         write(LERR,100)(idist(i),i=1,ntro)
         write(LERR,*)'Binned trace distances'
         write(LERR,100)(jdist(i),i=1,ntro)
 100     format(10i8)
         write(LERR,*)' '
      endif

      ic = 0
      
      do  j = 1, ntro
         if (idist(j) .ne. -999999) then
            ic = ic + 1
            ipos  (ic) = j
            tabl1 (ic) = idist (j)
            tabl2 (ic) = jdist (j)
         endif
      enddo

      ntrl  = ic
      ntrl1 = ic + 1
      tmin1 = tabl1 (1)
      tmin2 = tabl2 (1)
      tmin  = abs ( amin1 (tmin1, tmin2) ) + 1.

      do  j = 1, ntrl
         tabl1 (j) = tabl1 (j) + tmin
         tabl2 (j) = tabl2 (j) + tmin
      enddo

      tabl2 (ntrl1) = tabl2 (ntrl) + dx

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)'Live Trace= ',ntrl
         write(LERR,*)'Table1:'
         write(LERR,101)(tabl1(i),i=1,ntrl)
         write(LERR,*)'Table2:'
         write(LERR,101)(tabl2(i),i=1,ntrl)
 101     format(10f8.0)
         write(LERR,*)' '
      endif

      DO  i = 1, nsamp

         call move ( 0, work1, 0, ntrl*SZSMPD )

         do  j = 1, ntrl
            ittrc = (ipos(j)-1) * nsamp + i
            work1 (j) = array (ittrc)
         enddo

         call move ( 0, work2, 0, ntrl*SZSMPD )
         call fcuint (tabl1, work1, ntrl, tabl2, work2, ntrl,
     1        iz, zz, iflag)

         iflag = 0

         do  j = 1, ntrl
            ittrc = (j-1) * nsamp + i
            array (ittrc) = work2 (j)
         enddo

      ENDDO

      do  j = 1, ntrl
         istrc = (ipos(j)-1) * trhead_plus_tr_size + 1
         ittrc = (j-1) * nsamp + 1

         call move (1, idead(istrc+ITRWRD), array(ittrc), 
     1        nsamp*SZSMPD)

         do  i = 1, trhead_plus_tr_size
            itr(i) = idead(istrc+i)
         enddo

         do  i = 1, trhead_plus_tr_size
            idead(istrc+i) = itr(i)
         enddo

         idist(j) = jdist(j)

      enddo

      return
      end
