C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dupdst (nlive, nsamp, ntrc, ntro, itrce_size, idist, 
     :     itrce, idead, trhead_plus_tr_size, work1, work2, iwork1 )

      implicit none

#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nlive, nsamp, ntro, itrce_size, trhead_plus_tr_size
      integer ntrc

      integer itrce(itrce_size)
      integer idead(itrce_size)
      integer idist(ntrc)
      integer iwork1(ntrc)

      real work1(nsamp)
      real work2(nsamp)

c declare local variables

      integer  dstlst, dstcur, k, j, istrc, nrep, i, idtrc

      logical  unique

      SAVE

c initialize variables 

      unique = .true.
      dstlst = idist (1)
      iwork1 (1) = idist (1)
      call move (1, idead(1), itrce(1),
     1     trhead_plus_tr_size*SZSMPD)

      k = 1
      
      do j = 2, nlive

         istrc = (j-1) * trhead_plus_tr_size + 1
         dstcur = idist (j)

         if (dstcur  .eq. dstlst) then
            unique = .false.
            nrep = nrep + 1
            call move (1, work1, itrce(istrc+ITRWRD),
     1           nsamp*SZSMPD)
            do  i = 1, nsamp
               work2 (i) = work2 (i) + work1 (i)
            enddo

            dstlst = dstcur
         else
            if (nrep .gt. 1) then
               do  i = 1, nsamp
                  work2 (i) = work2 (i) / float(nrep)
               enddo
            endif
            k = k + 1
            iwork1 (k) = idist (j)
            dstlst = idist (j)
            idtrc = (k-1) * trhead_plus_tr_size + 1
            call move (1, work2, itrce(istrc+ITRWRD),
     1           nsamp*SZSMPD)
            call move (1, idead(idtrc), itrce(istrc),
     1           trhead_plus_tr_size*SZSMPD)

            nrep = 1
            unique = .true.
         endif

         idtrc = (k-1) * trhead_plus_tr_size + 1

      enddo

      nlive = k
    
      do  j = 1, nlive
         istrc = (j-1) * trhead_plus_tr_size + 1
         idist (j) = iwork1 (j)
         call move (1, itrce(istrc), idead(istrc),
     1        trhead_plus_tr_size*SZSMPD)
      enddo

      do  j = nlive+1, ntro
         istrc = (j-1) * trhead_plus_tr_size

         do  i = 1, trhead_plus_tr_size
            itrce(istrc+i) = 0
            idead(istrc+i) = 0
         enddo
      enddo

      return
      end
