/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*SUPPRESS 594*/	/* get rid of Saber-C's "set but not used warning */
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <string.h>
#include <eventnames.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#include <sys/limits.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/Protocols.h>

#include "HelpObject.h"
#include "help_defs.h"
#include "dskutil_glob.h"
#include "dskutil_defs.h"
#include "tape_menu.h"
#include "dskutil.h"
#include "resources.h"

void subdir_accel();

XtActionsRec actionsTable[] = {
	{"SubDirAccel", (XtActionProc) subdir_accel}
	};

static char *defaultTranslations;

/* this is for debugging a problem with the message dialogs */
char dialog_name[10];
int dialog_number = 0;

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
/* XtEventHandler */ void show_debug_mode(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
  XButtonEvent *bev = (XButtonEvent *) call_data;
  if (debug_mode >= 2) fprintf(stderr,"-> show_debug_mode <-\n");
/*
  char keychar;
  if (XLookupString(kev,&keychar,1,NULL,NULL) != 0) {
    if (strncmp(&keychar,"d",1) == 0) XtManageChild(debug_but);
    }
*/
  if (bev->button == Button2) XtManageChild(debug_but);
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
/* XtCallbackProc */ void debug_set_state(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data;
  XmToggleButtonCallbackStruct *call_data;
{
  if (debug_mode >= 2) fprintf(stderr,"-> debug_set_state <-\n");
/*
  if (XmToggleButtonGetState(widget))
*/
  if (call_data->set) {
    debug_mode = (int) client_data;
    if (debug_mode) {
      if (debug_mode > 0)
	fprintf(stderr,"debug on: level %d\n",debug_mode);
      else
	debug_mode = 0;
      XtVaSetValues(print_lists_but,XmNsensitive,TRUE,NULL);
      XtManageChild(print_lists_but);
      }
    else {
      XtUnmanageChild(debug_but);
      XtUnmanageChild(print_lists_but);
      }
    }
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void release_grab(widget, client_data, call_data)
  Widget widget;
  XtPointer client_data;
  XtPointer call_data;
{
  Boolean *block_flag = (Boolean *)client_data;
  Widget info_dialog = XtParent(widget);
  if (debug_mode >= 2) fprintf(stderr,"-> release_grab <-\n");
  *block_flag = FALSE;
  if (debug_mode)
    fprintf(stderr,"Remove grab\n");
  XtRemoveGrab(info_dialog);
  XtRemoveCallback(widget, XmNokCallback,
	release_grab, (XtPointer)client_data);
  XtRemoveCallback(widget, XmNcancelCallback,
	release_grab, (XtPointer)client_data);
/*
  XtRemoveCallback(widget, XmNhelpCallback,
	release_grab, (XtPointer)client_data);
*/
  XuSet_Help_Shell(shell);
/*
  XtUnmanageChild(widget);
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void drop_dialog(widget, client_data, call_data)
  Widget widget;
  XtPointer client_data;
  XtPointer call_data;
{
  if (debug_mode >= 2) fprintf(stderr,"-> drop_dialog <-\n");
  if (debug_mode)
	fprintf(stderr," drop the info_dialog: widget = %08x\n",
		(Widget)client_data);

/* ATTENTION: This Destroy command should be uncommented at some point
   in the future. There is a bug in the Intrinsics which prevents me 
   from destroying these widgets. 		- j.m.wade
   (MIT was notified and admitted the bug.)
*/

  XtDestroyWidget((Widget)client_data);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void post_message(block_flag,parent,info_label,type,
	ok_button,ok_button_label,ok_callback,ok_data,
	cancel_button,cancel_button_label,cancel_callback,cancel_data,
	help_button,help_button_label,help_callback,help_data)
  Boolean block_flag;
  Widget parent;
  Boolean ok_button,cancel_button,help_button;
  char *info_label;
  char *ok_button_label,*cancel_button_label,*help_button_label;
  int type;
  XtCallbackProc ok_callback;
  XtPointer ok_data;
  XtCallbackProc cancel_callback;
  XtPointer cancel_data;
  XtCallbackProc help_callback;
  XtPointer help_data;
{
/*  Widget info_dialog = (Widget) XtMalloc(sizeof(Widget)); */
  Widget info_dialog;
  XmString msg_label = NULL;
  XmString ok_label = NULL;
  XmString cancel_label = NULL;
  XmString help_label = NULL;
  XEvent event;
  void tree();
  Position apply_x,apply_y;
  unsigned char default_child;
  Window root_window,child_window,virtual_window;
  Dimension default_child_width,default_child_height;
  int root_x,root_y,win_x,win_y;
  short new_x,new_y,wm_x,wm_y;
  unsigned int keys_buts;

  if (debug_mode >= 2) fprintf(stderr,"-> post_message <-> %s <-\n",info_label);

  parent = shell;

  nargs = 0;
  msg_label = XmStringCreateLtoR(info_label,XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Xarg[nargs],XmNmessageString,msg_label);	nargs++;
  XtSetArg(Xarg[nargs],XmNdialogType,type);		nargs++;
  XtSetArg(Xarg[nargs],XmNdefaultPosition, FALSE);	nargs++;
  XtSetArg(Xarg[nargs],XmNmessageAlignment,XmALIGNMENT_CENTER); nargs++;
  XtSetArg(Xarg[nargs],XmNautoUnmanage,TRUE);		nargs++;
  XtSetArg(Xarg[nargs],XmNmappedWhenManaged,TRUE);	nargs++;

/* come up with a unique name for the dialog for debugging */

  if (debug_mode) {
    sprintf(dialog_name,"info%05d",dialog_number++);

    if (block_flag) fprintf(stderr,"is set\n");
    else fprintf(stderr,"is not set\n");
    info_dialog = XmCreateMessageDialog(parent,dialog_name,Xarg,nargs);
    fprintf(stderr,
	"entering post_message: widget = %8x  name = %s  block_flag = %d\n",
		info_dialog,dialog_name,block_flag);

    }
  else {
    info_dialog = XmCreateMessageDialog(parent,"info",Xarg,nargs);
    }
  if ( block_flag ) {
    if (debug_mode)
      fprintf(stderr,"Add grab\n");

    XuSet_Help_Shell(info_dialog);
    XtAddGrab(XtParent(info_dialog), TRUE, FALSE);
    XtAddCallback(info_dialog, XmNokCallback,
	release_grab, (XtPointer)&block_flag);
    XtAddCallback(info_dialog, XmNcancelCallback,
	release_grab, (XtPointer)&block_flag);
    }
    
  XtAddCallback(info_dialog, XmNokCallback, drop_dialog,
	(XtPointer) info_dialog);
  XtAddCallback(info_dialog, XmNcancelCallback, drop_dialog,
	(XtPointer) info_dialog);

  if (ok_button ) {
    if (ok_button_label != NULL) {
      ok_label = XmStringCreate(ok_button_label,XmSTRING_DEFAULT_CHARSET);
      XtSetArg(Xarg[nargs],XmNokLabelString,ok_label);		nargs++;
      }
    if (ok_callback != NULL)
      XtAddCallback(info_dialog, XmNokCallback, ok_callback, (XtPointer)ok_data);
    XtManageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_OK_BUTTON));
    }
  else
    XtUnmanageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_OK_BUTTON));

  if (cancel_button ) {
    if (cancel_button_label != NULL) {
      cancel_label = XmStringCreate(cancel_button_label,
		XmSTRING_DEFAULT_CHARSET);
      XtSetArg(Xarg[nargs],XmNcancelLabelString,cancel_label);	nargs++;
      }
    if (cancel_callback != NULL) XtAddCallback(info_dialog, XmNcancelCallback,
  	cancel_callback, (XtPointer)cancel_data);
    XtManageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_CANCEL_BUTTON));
    }
  else
    XtUnmanageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_CANCEL_BUTTON));

  if (help_button ) {
    if (help_button_label != NULL) {
      help_label = XmStringCreate(help_button_label,XmSTRING_DEFAULT_CHARSET);
      XtSetArg(Xarg[nargs],XmNhelpLabelString,help_label);	nargs++;
      }
    if (help_callback != NULL) XtAddCallback(info_dialog, XmNhelpCallback,
	help_callback, (XtPointer)help_data);
    XtManageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_HELP_BUTTON));
    }
  else
    XtUnmanageChild(XmMessageBoxGetChild(info_dialog,XmDIALOG_HELP_BUTTON));

  XtSetValues(info_dialog,Xarg,nargs);

  if (msg_label != NULL)	XmStringFree(msg_label);
  if (ok_label != NULL)		XmStringFree(ok_label);
  if (cancel_label != NULL)	XmStringFree(cancel_label);
  if (help_label != NULL)	XmStringFree(help_label);

  XtManageChild(info_dialog);
  XtVaGetValues(info_dialog,
	XmNdefaultButtonType, &default_child,
	NULL);

  XtVaGetValues(XmMessageBoxGetChild(info_dialog,default_child),
	XmNx,		&apply_x,
	XmNy,		&apply_y,
	XmNwidth,	&default_child_width,
	XmNheight,	&default_child_height,
	NULL);

  XtUnmanageChild(info_dialog);

/* if a virtual window manager is running, root window isn't good enough */

  virtual_window = GetVRoot(XtDisplay(shell),DefaultScreen(XtDisplay(shell)));

  XQueryPointer(XtDisplay(shell),virtual_window,&root_window,&child_window,
	&root_x,&root_y,&win_x,&win_y,&keys_buts);

  if (debug_mode) {
	fprintf(stderr,"apply_x = %d, apply_y = %d\n",apply_x,apply_y);
	fprintf(stderr,"root_x = %d, root_y = %d\n",root_x,root_y);
	fprintf(stderr,"win_x = %d, win_y = %d\n",win_x,win_y);
	}

  XtTranslateCoords(info_dialog,apply_x,apply_y,&wm_x,&wm_y);

  if (debug_mode) fprintf(stderr,"wm_x = %d, wm_y = %d\n",wm_x,wm_y);

  new_x = win_x - apply_x - (default_child_width / 2);
  new_y = win_y - apply_y - (default_child_height / 2);
  if (debug_mode) fprintf(stderr,"new_x = %d, new_y = %d\n",new_x,new_y);

  XtVaSetValues(info_dialog,
	XmNx,	(Position) new_x,
	XmNy,	(Position) new_y,
	XmNmappedWhenManaged,	TRUE,
	NULL);
  XtManageChild(info_dialog);
  if (debug_mode >= 2) tree(info_dialog,0);

  if (debug_mode) {
  fprintf(stderr,"before loop in post_message: block_flag ");
  if (block_flag) fprintf(stderr,"is set\n");
  else fprintf(stderr,"is not set\n");
  }

  XSync(XtDisplay(info_dialog),FALSE);

  while (block_flag || XtAppPending(app_con) ) {
    XtAppNextEvent(app_con,&event);
    if (debug_mode >= 3) fprintf(stderr,"post: event type = %s  window = %8x\n",
		event_names[event.type],event.xany.window);
    XtDispatchEvent(&event);
    }
  XFlush(XtDisplay(info_dialog));
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void pd_activate(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
  if (debug_mode >= 2) fprintf(stderr,"-> pd_activate <-\n");
/*
	XtCallCallbacks((Widget) client_data,XmNcascadingCallback, NULL);
*/
	XtCallActionProc((Widget) client_data, "DoSelect",
		((XmPushButtonCallbackStruct *)call_data)->event, NULL, 0);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void wm_exit(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
  if (debug_mode >= 2) fprintf(stderr,"-> wm_exit <-\n");
	XtCallCallbacks((Widget) client_data, XmNactivateCallback, NULL);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void bye_bye(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	void bail_out();
  if (debug_mode >= 2) fprintf(stderr,"-> bye_bye <-\n");
        post_message(TRUE, widget,
		"Are you sure?",
		XmDIALOG_QUESTION,
		TRUE,"Confirm",(XtCallbackProc) bail_out,(XtPointer) 0,
		TRUE,"Cancel",NULL,NULL,
		FALSE,NULL,NULL,NULL);

}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void bail_out(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	exit((long)client_data);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void malloc_failure(size_of_malloc)
unsigned int size_of_malloc;
{
	void process_files();

  if (debug_mode >= 2) fprintf(stderr,"-> malloc_failure <-\n");
	fprintf(stderr,"Attempt to allocate %d bytes caused program abortion\n",		size_of_malloc);
          post_message(TRUE,shell,
		"Storage buffer error;\nexiting program;\nplease restart",
		XmDIALOG_ERROR,
		TRUE,NULL,(XtCallbackProc) bail_out,(XtPointer) 1,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "Buffer.help");
}
	
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void confirm_processing(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
/*
	void save_processed_files();
*/

  if (debug_mode >= 2) fprintf(stderr,"-> confirm_processing <-\n");
        post_message(TRUE,shell,
          "Are you sure?",
	  XmDIALOG_QUESTION,
	  TRUE,"Yes",(XtCallbackProc) process_files, client_data,
	  TRUE,"No",NULL,NULL,
	  TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "Conf_Proc.help");
}

/*
	This subroutine is generally triggered by a response to 
	a dialog which asks the user if we need to reenter some
	data via a popup  menu
*/
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void pop_archival_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	callback_info *tape_info = (callback_info *) client_data;
  if (debug_mode >= 2) fprintf(stderr,"-> pop_archival_menu <-\n");
	XtCallCallbacks(*(tape_info->widgets+TRIGGER_WIDGET),
		XmNactivateCallback,tape_info);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void process_files(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	Boolean processing_directories = FALSE;
	Boolean use_K_option = FALSE;
	Boolean dir_mode_set = FALSE;
	Boolean bad_perms;
	int num_items,status = 0;
	int sel_list_ptr;
	int file_string_length = 0;
	int process_cmd_length = 0;
	int total_byte_count = 0;
	int indx,indx2;
	char *get_suffix();
	char *file_string = NULL,*process_cmd = NULL;
	file_list_item **processed_list;
/*
	int num_processed_items;
*/
	file_list_item *selected_list_entry,*processed_list_entry;
	struct stat file_stat;
/*	FILE *cmd_pipe; */
	Boolean delete_flag;
	Boolean parse_tar_files();
	void delete_sorted_list_item();
	void delete_selected_list_item();
	void post_output(),remove_archived_files(),skip_dir();
	void set_false(),set_true();
	Boolean bld_cmd_line(),get_file_info();
	int item_count;

  if (debug_mode >= 2) fprintf(stderr,"-> process_files <-\n");

/*
	if (widget != 0) processing_directories = (Boolean) client_data; */

	XtVaGetValues(lists[1],XmNitemCount,&num_items,NULL);

	if (num_items == 0) {
	  post_message(FALSE,shell,
		"No items have been selected",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "No_Items.help");
	  return;
	  }

	XMapRaised(XtDisplay(widget),busy_win);
	XFlush(XtDisplay(widget));

/*
	process_cmd = XtMalloc(process_cmd_length*sizeof(char));
	strcpy(process_cmd,"");
*/
	bld_cmd_line(&process_cmd,&process_cmd_length,"");

	if ((mode == ARCHIVAL) && ((archival_mode == IBM_ARCHIVAL_TAPE) || 
		(archival_mode == CRAY_ARCHIVAL_TAPE))) {
	  strcpy(process_cmd,
	    "xcat -busy -label 'Reserving Tape Drives' +am -tr -e restape 20");
	  if (debug_mode) {
	    fprintf(stderr,"%s\n",process_cmd);
	    status = 0;
	    }
	  else
	    status = system(process_cmd);

	  if (status != 0) {
	    post_message(FALSE,shell,"Unable to reserve tape drive",
		XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "No_Tape.help");
	    free_cmd_line(&process_cmd,&process_cmd_length);
	    XUnmapWindow(XtDisplay(widget),busy_win);
	    return;
	    }
	  strcpy(process_cmd,"");
	  }

/*
	file_string = XtMalloc(file_string_length*sizeof(char));
	strcpy(file_string,"");
*/

	processed_list = 
	  (file_list_item **) XtMalloc(num_items*sizeof(file_list_item *));

	sel_list_ptr = 0;

	for (indx=0; indx<num_items; indx++) {
	  if (debug_mode >= 2)
	    fprintf(stderr,"indx = %d, sel_list_ptr  = %d, file = %s\n",indx,
		sel_list_ptr,(*(selected_list+indx))->name);
	  if (!get_file_info((*(selected_list+indx))->name,&file_stat)) {
/*
	    cant_process((*(selected_list+indx))->name);
*/
	    sel_list_ptr++;
	    }
	  else {

      bad_perms = FALSE;
/*
    We have to check to see if the file can be deleted without an override.
    I'd like to fork the process and set up some kind of ttys to handle
    answering the questions, but I haven't figured out how. - joe

	    if (mode == DELETION) {
	      bad_perms = TRUE;
	      if (getuid() == file_stat.st_uid) {
	        if ((file_stat.st_mode & S_IWUSR ) != 0)
		  bad_perms = FALSE;
		}
	      else if ((file_stat.st_mode & S_IWOTH) != 0)
	        bad_perms = FALSE;
	      else {
	        for (indx2=0; indx2<num_groups; indx2++) {
		  if (file_stat.st_gid == group_ids[indx2]) {
	      	    if ((file_stat.st_mode & S_IWGRP ) != 0)
		     bad_perms = FALSE;
		    }
		  }
		}
	      }
*/

	    if (debug_mode >= 2) fprintf(stderr,"%s - %d bytes\n",
		  (*(selected_list+indx))->name,file_stat.st_size);
#ifdef SGISYSTEM
	    if (file_stat.st_size > 0x7fffffff) {
		use_K_option = TRUE;
		}
#endif
/*	    if ((file_stat.st_mode & S_IFDIR ) != 0) { */
	    if ((file_stat.st_mode & S_IFMT) == S_IFDIR ) {
	      if ( !dir_mode_set ) {
		post_message(TRUE,shell,
		  "Selection(s) contain a directory;\nprocess all contents?",
		  XmDIALOG_QUESTION,
		  TRUE,"Yes",(XtCallbackProc) set_true,&processing_directories,
		  TRUE,"No",(XtCallbackProc) set_false,&processing_directories,
		  FALSE,NULL,NULL,NULL);
		dir_mode_set = TRUE;
		}
	      }

/*	    if (((file_stat.st_mode & S_IFDIR ) != 0) &&  */
	    if (((file_stat.st_mode & S_IFMT) == S_IFDIR ) &&
		( !processing_directories )) {
	      skip_dir((*(selected_list+indx))->name);
	      sel_list_ptr++;
	      }
	    else if (bad_perms) {
	      char *new_msg;
	      char *dirt = "Unable to process ";
	      char *dirt2 = "; bad permissions";
	      new_msg = (char *) XtMalloc((strlen(dirt) + strlen(dirt2) +
		strlen((*(selected_list+indx))->name) + 2) * sizeof(char));
/*
	      sprintf(new_msg,"Unable to process %s;\n bad permissions",
		(*(selected_list+indx))->name);
*/
	      strcpy(new_msg,dirt);
	      strcat(new_msg,(*(selected_list+indx))->name);
	      strcat(new_msg,dirt2);

	      post_message(TRUE,shell,new_msg,
		  XmDIALOG_ERROR,
		  TRUE,NULL,NULL,NULL,
		  FALSE,NULL,NULL,NULL,
		  TRUE,NULL,(XtCallbackProc) XuHelper,(XtPointer) "Bad_Perms.help");
	      sel_list_ptr++;
	      }
	    else if ( bld_cmd_line(&file_string,&file_string_length,
		(*(selected_list+indx))->name)) {
	      total_byte_count += file_stat.st_size;
	      *(processed_list+indx-sel_list_ptr) =
			*(selected_list+indx);
	      }
	    else {
	      post_message(TRUE,shell,"Error processing files",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "Prc_Err.help");
	      sel_list_ptr++;
	      }
	    }
	  }

	num_processed_items = num_items - sel_list_ptr;

#ifdef SGISYSTEM
	if ( use_K_option ) {
	  post_message(TRUE,shell,"Files over 2 Gb in list, use -K option?",
		XmDIALOG_QUESTION,
		TRUE,"Yes",(XtCallbackProc) set_true, &use_K_option,
		TRUE,"No",(XtCallbackProc) set_false, &use_K_option,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "SGI_K_Option.help");
	  }
#endif

	if (debug_mode >= 2) {
	  fprintf(stderr,"num_processed_items = %d\n",num_processed_items);
/*
	  fprintf(stderr,"file_string = %s\n",file_string);
*/
	  }

	if (num_processed_items == 0) {
	  post_message(TRUE,shell,"Unable to process any items",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  XtFree((char *)processed_list);
	  free_cmd_line(&file_string,&file_string_length);
	  free_cmd_line(&process_cmd,&process_cmd_length);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  return;
	  }

	if (debug_mode >= 2) {
	  if (processing_directories)
	    fprintf(stderr,"process_files: processing directories\n");
	  else
	    fprintf(stderr,"process_files: bypassing directories\n");
	  }

	delete_flag = FALSE;
	status = 0;

	switch(mode) {
	  case DELETION:
/*
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,"/bin/rm");
*/
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
		"\"rm\" -r -f");
	    if (processing_directories)
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"-r");
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			file_string);
	    break;
	  case ARCHIVAL:
/*
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
   "xcat -busy -xrm '*automap: FALSE' -C Dskutil -name 'archived files' -stl 'terminate processing' -display ");
*/
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
		"xcat -busy +am -C Dskutil -name 'archived files'");
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
		"-stl 'terminate processing' -display ");
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
	 	display_string);
	    status += bld_cmd_line(&process_cmd,&process_cmd_length," -e ");
	    switch (archival_mode) {
	      case TAR_ARCHIVAL_TAPE:
		if (strlen(arch_parms[archival_mode].dataset_name) != 0) {
		  if (strlen(arch_parms[archival_mode].device_blocksize) != 0) {
		    if ( use_K_option )
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvbfK");
		    else
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvbf");
		    strcat(process_cmd,
			arch_parms[archival_mode].device_blocksize);
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].device_blocksize_option);
		    }
		  else {
		    if ( use_K_option )
		     status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvfK");
		    else
		     status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvf");
		    }
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].dataset_name);
		  }
		else {
		  if (strlen(arch_parms[archival_mode].device_blocksize) != 0) {
		    if ( use_K_option )
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvbK");
		    else
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvb");
		    strcat(process_cmd,
			arch_parms[archival_mode].device_blocksize);
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].device_blocksize_option);
		    }
		  else {
		    if ( use_K_option )
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvK");
		    else
		      status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cv");
		    }
		  }
		delete_flag = arch_parms[archival_mode].remove_archive_files;
		status = parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);
		break;
	      case TAR_ARCHIVAL_FILE:
		if ( use_K_option )
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvfK");
		else
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvf");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].dataset_name);
		delete_flag = arch_parms[archival_mode].remove_archive_files;
		status = parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);
		break;
	      case CRAY_ARCHIVAL_TAPE:
/*
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"tar cvf -");
		status = parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"| resb | writetape");
*/ 
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"cd");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			current_dir);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,";");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"d2t");
		if (dsn_exists) 
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"-d");
		else 
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"-D");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].dataset_name);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"-E");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].expiration_date);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"-Q");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].max_no_of_tapes);
/*
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			file_string);
*/
		status +=  parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);
		delete_flag = arch_parms[archival_mode].remove_archive_files;
		break;
	      case IBM_ARCHIVAL_TAPE:
		if (dsn_exists)
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"writetape -d");
		else
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"writetape -D");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].dataset_name);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"-E");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].expiration_date);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,"-Q");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].max_no_of_tapes);
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"-WS cs2i -RS i2cs -F");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].record_format);
		delete_flag = arch_parms[archival_mode].remove_archive_files;
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			file_string);
/*
		status += parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);
*/
		break;
    	      case TAR_REMOTE_DEVICE:
/*
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"echo 'NOT YET IMPLEMENTED'");
*/

		if (strlen(arch_parms[archival_mode].transfer_blocksize) == 0) {
		  if ( use_K_option )
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"'tar cvfK -");
		  else
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"'tar cvf -");
		  }
		else {
		  if ( use_K_option )
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"'tar cvfbK -");
		  else
		    status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"'tar cvfb -");
/*
		  strcat(process_cmd,
			arch_parms[archival_mode].transfer_blocksize);
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].transfer_blocksize_option);
*/
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].transfer_blocksize);
		  }

		status = parse_tar_files(&process_cmd,&process_cmd_length,
			processed_list,&num_processed_items);

#if defined(HPUXSYSTEM) || defined(CRAYSYSTEM)
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"| remsh");
#else
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"| rsh");
#endif
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].machine_name);
/*
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"\' dd of=");
*/
		strcat(process_cmd,"dd of=");
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].dataset_name);

		if (strlen(arch_parms[archival_mode].transfer_blocksize) != 0) {
		  strcat(process_cmd,"ibs=");
		  strcat(process_cmd,
			arch_parms[archival_mode].device_blocksize);
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,"b");
		  }
		if (strlen(arch_parms[archival_mode].device_blocksize) != 0) {
/*
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			" bs=");
*/
		  strcat(process_cmd,"obs=");
		  strcat(process_cmd,
			arch_parms[archival_mode].device_blocksize);
		  status += bld_cmd_line(&process_cmd,&process_cmd_length,
			arch_parms[archival_mode].device_blocksize_option);
		  }
		status += bld_cmd_line(&process_cmd,&process_cmd_length,
			"'");
/*
		fprintf(stderr,"process_cmd = >>%s<<\n",process_cmd);
*/
		delete_flag = arch_parms[archival_mode].remove_archive_files;
		break;

	      }
/*
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,"'");
	    status += bld_cmd_line(&process_cmd,&process_cmd_length,
	 " |& xcat -xrm '*automap: FALSE' -C Dskutil -name 'process results'");
*/
	    }

	if (!status) {
	  post_message(TRUE,shell,
		"Error constructing archive\ncommand; aborting",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "ArCon_Err.help");
	  XtFree((char *)processed_list);
	  XtFree(file_string);
	  XtFree(process_cmd);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  return;
	  }
	
	XFlush(XtDisplay(shell));

	if (debug_mode) {
	  status = 0;
	  fprintf(stderr,"%s\n",process_cmd);
	  }
	else {
	  status = system(process_cmd);
	  }

	if (status) {
/*
	  fprintf(stderr,"%s: status code = %d\n",process_cmd,status);
*/
	  post_message(TRUE,shell,
		"Processing error occurred;\nplease check files",
		XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper, (XtPointer) "Prc_Err.help");
	  }
	else {
	  if (delete_flag) {
	    XFlush(XtDisplay(shell));
	    strcpy(process_cmd,"");
/*
	    bld_cmd_line(&process_cmd,&process_cmd_length,"/bin/rm -r");
*/
	    bld_cmd_line(&process_cmd,&process_cmd_length,"\"rm\" -r -f");
	    bld_cmd_line(&process_cmd,&process_cmd_length,file_string);
	    post_message(TRUE,shell,"Do you still want to remove files?",
		XmDIALOG_MESSAGE,
		TRUE,NULL,(XtCallbackProc)remove_archived_files,
			(XtPointer)process_cmd,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
		}

 	  if (debug_mode)
	    fprintf(stderr,"processed list: \n");

	  if (debug_mode) {
	    char *marked_file = NULL;
	    XmStringTable item_table;
	    for (indx=0; indx<num_processed_items; indx++) {
	      processed_list_entry = *(processed_list+indx);
		fprintf(stderr,"%d %d %d %s\n",
		  processed_list_entry->orig_pos,
		  processed_list_entry->current_pos,
		  processed_list_entry->selected,processed_list_entry->name);
	      }
	    fprintf(stderr,"selected items: \n");
	    XtVaGetValues(lists[1],XmNitems,&item_table,
				XmNitemCount,&indx2,
				NULL);
	    for (indx=0; indx<indx2; indx++) {
	      XmStringGetLtoR(item_table[indx],
		XmSTRING_DEFAULT_CHARSET,&marked_file);
	      fprintf(stderr,"position %d ; string = %s\n",
		indx,marked_file);
	      XtFree(marked_file);
	      }
	    }

	  processed_files = (char **)
		malloc(num_processed_items*sizeof(char *));

	  for (indx=0; indx<num_processed_items; indx++) {
	    processed_list_entry = *(processed_list+indx);
	    if (debug_mode)
 	     fprintf(stderr,"%d %d %d %s\n",
		processed_list_entry->orig_pos,
		processed_list_entry->current_pos,
		processed_list_entry->selected,processed_list_entry->name);

	    processed_files[indx] = (char *)
		malloc((strlen(processed_list_entry->name)+1)*sizeof(char));
	    strcpy(processed_files[indx],processed_list_entry->name);

	    indx2 = 0;
	    do {
	      selected_list_entry = *(selected_list+indx2++);
	      }
	    while ( selected_list_entry != processed_list_entry );

	    if (debug_mode) {
	      char *marked_file = NULL;
	      XmStringTable item_table;
	      XtVaGetValues(lists[1],XmNitems,&item_table,NULL);
	      XmStringGetLtoR(item_table[indx2-1],
		XmSTRING_DEFAULT_CHARSET,&marked_file);
	      fprintf(stderr,"delete position %d ; string = %s\n",
		indx2,marked_file);
	      XtFree(marked_file);
	      }

/* this is a kludge to get around a bug in the list widget */

	    XtVaGetValues(lists[1],XmNitemCount, &item_count, NULL);
	    if (item_count == 1)
	      XmListDeleteAllItems(lists[1]);
	    else
	      XmListDeletePos(lists[1],indx2);

	    delete_selected_list_item(selected_list,num_items,indx2);
	    num_selected_items--;

	    processed_list_entry->selected =
		-processed_list_entry->selected;

/*
	    delete_sorted_list_item(sorted_list,num_list_items,
		processed_list_entry->orig_pos);
	    num_list_items--;
*/

	    }
	  }

	if ((mode == ARCHIVAL) && ((archival_mode == IBM_ARCHIVAL_TAPE) || 
		(archival_mode == CRAY_ARCHIVAL_TAPE))) {
	  strcpy(process_cmd,"restape 0");
	  if (debug_mode)
	    fprintf(stderr,"%s\n",process_cmd);
	  else
	    status = system(process_cmd);
	  }

	XtFree(file_string);
	XtFree(process_cmd);
	XUnmapWindow(XtDisplay(widget),busy_win);

}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void verify_directory(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	Boolean *flag = (Boolean *)client_data;
  if (debug_mode >= 2) fprintf(stderr,"-> verify_directory <-\n");
	*flag = TRUE;
	if (debug_mode)
	  fprintf(stderr,"verified directory handling\n");
/*
        XtRemoveCallback(info_dialog, XmNokCallback,
		verify_directory, (XtPointer)client_data);
*/
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void remove_file(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	void c_label();
	XmString label;

  if (debug_mode >= 2) fprintf(stderr,"-> remove_file <-\n");

	mode = DELETION;
	label = XmStringCreate("Files to be deleted:",
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(list2_label,XmNlabelString,label,NULL);
	XmStringFree(label);

	label = XmStringCreate("Delete",
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(apply_but,
			XmNlabelString,		label,
			NULL);
	XmStringFree(label);

	c_label(XtParent(apply_but),apply_but,NULL);
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void subdir_accel(widget, call_data, params, num_params)
     Widget widget;
     XtPointer call_data;
     String *params;
     int*num_params;
{
	Widget button;
	int i;
	if (debug_mode >= 2) {
	  fprintf(stderr,"subdir_accel: widget = %d\n",widget);
	  fprintf(stderr,"              params = ",widget);
	  for(i=0; i<*num_params; i++) {
	    if (i>0) fprintf(stderr,", ");
	    fprintf(stderr,"%s ",params[i]);
	    }
	  fprintf(stderr,"\n");
	  }
	sscanf(params[0],"%d",&button);
	XtCallCallbacks(button,XmNactivateCallback,NULL);
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void goto_parent(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int i;
	char *new_path_dir;

	if (debug_mode >= 2)
	  fprintf(stderr,"-> goto_parent <-\n");

	for ( i=strlen(current_dir); i >= 0; i--)
	  if (strncmp(current_dir+i,"/",1) == 0) {
	    new_path_dir = (char *) XtMalloc((i+1) * sizeof(char));
	    if (new_path_dir == NULL)
		malloc_failure((i+1) * sizeof(char));
	    strncpy(new_path_dir,current_dir,i);
	    new_path_dir[i] = '\0';
	    XtVaSetValues(*(Widget *)client_data,XmNvalue,new_path_dir,NULL);
	    free(new_path_dir);
	    break;
	    }

	XtCallCallbacks(*(Widget *)client_data,XmNactivateCallback,NULL);
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void goto_subdir(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	XmString *dir_string;
	char *marked_file = NULL;
	char *new_dir,*new_path_dir;
	char *filter;
	int new_length;
	int item_count;
	Boolean check_dir_stat();
	void sort_list();
	void reset_filter();

	if (debug_mode >= 2)
	  fprintf(stderr,"goto_subdir: current_dir = %s\n",current_dir);

	XtVaGetValues(lists[0],XmNselectedItemCount,&item_count,NULL);
	if (item_count == 0) {
	  post_message(FALSE,shell,
		"No directory specified",XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,(XtPointer) "SubDir.help");
	  }
	else if (item_count > 1) {
	  post_message(FALSE,shell,
		"Only one directory may be specified",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  }
	else {
	  XtVaGetValues(lists[0],XmNselectedItems,&dir_string,NULL);
	  XmStringGetLtoR(*dir_string,XmSTRING_DEFAULT_CHARSET,&marked_file);
	  new_dir = get_suffix(marked_file," ");

	  if (strlen(filter = XmTextGetString(filter_text)) != 0) {
	    post_message(TRUE,shell,
		"Do you want to retain the filter?",
		XmDIALOG_QUESTION,
		TRUE,"Retain",NULL,NULL,
		TRUE,"Reset",(char *)reset_filter,(char *)filter_text,
		FALSE,NULL,NULL,NULL);
	    }
	  XtFree(filter);

/*  XmStringFree(dir_string); definite no-no */

	  if (strncmp(new_dir,"/",1) != 0) {
	    new_length = strlen(new_dir) + strlen(current_dir) + 2;
	    new_path_dir = (char *) XtMalloc(new_length * sizeof(char));
	    if (new_path_dir == NULL)
		malloc_failure(new_length * sizeof(char));
	    strcpy(new_path_dir,current_dir);
	    strcat(new_path_dir,"/");
	    strcat(new_path_dir,new_dir);
	    XtVaSetValues(*(Widget *)client_data,XmNvalue,new_path_dir,NULL);
	    free(new_path_dir);
	    }
	  else
	    XtVaSetValues(*(Widget *)client_data,XmNvalue,new_dir,NULL);

	  XtFree(marked_file);
/*
	  sort_list(widget,NULL,NULL);
*/
	  XtCallCallbacks(*(Widget *)client_data,XmNactivateCallback,NULL);
	  }
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void change_filter(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	void sort_list();

  if (debug_mode >= 2) fprintf(stderr,"-> change_filter <-\n");

	XtVaGetValues(*(Widget *)widget,XmNvalue,&file_filter,NULL);
	sort_list(widget,NULL,NULL);

}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void use_absolute_path(widget, client_data, call_data)
Widget widget;
XtPointer client_data,call_data;
{
	((tape_parameters *)client_data)->full_path_names = TRUE;
}


/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void use_full_path(widget, client_data, call_data)
Widget widget;
XtPointer client_data,call_data;
{
	arch_parms[archival_mode].full_path_names = TRUE;
/* this is the next step
	XmToggleButtonSetState(
	  arch_parms[archival_mode].menu_info->widgets+FULL_PATH_TOGGLE,
	  arch_parms[archival_mode].full_path_names,TRUE);
*/
	return;
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void restore_current_dir(widget, client_data, call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XtVaSetValues((Widget)client_data,XmNvalue,current_dir,NULL);
	return;
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void reset_filter(widget, client_data, call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XmTextSetString((Widget)client_data,NULL);
	return;
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void change_dir(text_widget, client_data, call_data)
     Widget text_widget;
     XtPointer client_data;
     XtPointer call_data;
{
	char *new_dir;
	void sort_list();
/*	Boolean check_dir_stat(); */

  if (debug_mode >= 2) fprintf(stderr,"-> change_dir <-\n");

#ifdef CRAYSYSTEM
	if ((mode == ARCHIVAL) && !arch_parms[archival_mode].full_path_names) {
	  post_message(TRUE,shell,
		"Relative path names have been specified for tar file;\noption unavailable on multi-directory\ntar files. Proceed with full path names?",
		XmDIALOG_WARNING,
	 	TRUE,NULL,use_full_path,NULL,
		TRUE,NULL,restore_current_dir,text_widget,
		TRUE,NULL,NULL,NULL);
	  }
#endif

	XtVaGetValues(text_widget,XmNvalue,&new_dir,NULL);

	if (debug_mode >= 2)
	  fprintf(stderr,"change_dir: current_dir = %s new_dir = %s\n",
		current_dir,new_dir);

		/* We may not have even changed directories */

	if ( current_dir == new_dir ) return;

	if (check_dir_stat(new_dir)) {
	  current_dir = new_dir;
	  sort_list(text_widget,NULL,NULL);
	  }

}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void sort_list(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int indx,num_items;
	int pos_ptr,active_pos_ptr;
	int selected_indx = 0;
	int status = 0;
	XmString *list_items,*selected_list_items;
	XmString *list_item,*selected_list_item;
	Dimension width;
	int charbuf;
	FILE *file_list,*file_list_copy;
	char *filename;
/*	char *trailer; */
	char *command;
	char *new_dir;
	int cmd_size = 8192;
	file_list_item *list_entry;
	file_list_item *old_sorted_list;
	file_list_item **old_selected_list;
	int old_num_selected_items;
	int num_searched_items = 0;
	char *time_string1;
	char *time_string2;
	FILE *find_em;
	char *find_em_cmd;
	char *findfilename;
	void set_false(),set_true();

  if (debug_mode >= 2) fprintf(stderr,"-> sort_list <-\n");

	XMapRaised(XtDisplay(widget),busy_win);
	XFlush(XtDisplay(widget));

	command = (char *) XtMalloc(cmd_size * sizeof(char));
/*
	XtVaGetValues(lists[1],XmNitemCount,&num_selected_items, NULL);
*/

	XtVaGetValues(filter_text,XmNvalue,&file_filter,NULL);
	XtVaGetValues(list1_text_label,XmNvalue,&new_dir,NULL);

	if (strcmp(new_dir,current_dir) != 0) {
#ifdef CRAYSYSTEM
	  if ((mode == ARCHIVAL) &&
		!arch_parms[archival_mode].full_path_names) {
	    post_message(TRUE,list1_text_label,
		"Relative path names unavailable on multi-directory\ntar files. Full path names must be used ",
		XmDIALOG_WARNING,
	 	TRUE,NULL,set_true,&(arch_parms[archival_mode].full_path_names),
		TRUE,NULL,restore_current_dir,list1_text_label,
		TRUE,NULL,NULL,NULL);
	    XtVaGetValues(list1_text_label,XmNvalue,&new_dir,NULL);
	    }
#endif

/* If we changed directory, check the new one */

	  if (check_dir_stat(new_dir)) {
	    current_dir = new_dir;
	    }
	  else {

/*  We keep going in case the filter or options were changed */

	    XtVaSetValues(list1_text_label,XmNvalue,current_dir,NULL);
	    }
	  }

	strcpy(command,"\"ls\" ");
/*
fprintf(stderr,"extra ls  options - %s\n",ls_options);
*/
	strcat(command,ls_options);
	strcat(command," ");
	if ( strlen(find_options) == 0 ) {
	  if ((int) strlen(file_filter) > 0) {
	    if (strcmp(current_dir,"/") != 0) strcat(command,current_dir);
	    strcat(command,"/");
	    strcat(command,file_filter);
	    strcat(command," ");
	    }
	  else {
	    if (hidden_files) {
	      if (strcmp(current_dir,"/") != 0) strcat(command,current_dir);
	      strcat(command,"/.* ");
	      }
	    if (strcmp(current_dir,"/") != 0) strcat(command,current_dir);
	    strcat(command,"/* ");
	    }
	  }
	else {
	  if ((time_string1 = strstr(find_options,"xtime")) != NULL) {
	    if (strchr(ls_options,'c') != NULL)
	      *time_string1 = 'c';
	    else if (strchr(ls_options,'u') != NULL)
	      *time_string1 = 'a';
	    else
	      *time_string1 = 'm';
	    }
/*
   we could have both a lower and upper time limits
*/
	  if ((time_string2 = strstr(find_options,"xtime")) != NULL) {
	    if (strchr(ls_options,'c') != NULL)
	      *time_string2 = 'c';
	    else if (strchr(ls_options,'u') != NULL)
	      *time_string2 = 'a';
	    else 
	      *time_string2 = 'm';
	    }

	  find_em_cmd = (char *) XtMalloc(cmd_size * sizeof(char));
	  findfilename = (char *) XtMalloc(256 * sizeof(char));

	  strcpy(find_em_cmd,"\"find\" ");
	  if (strcmp(current_dir,"/") != 0) {
	    strcat(find_em_cmd,current_dir);
	    strcat(find_em_cmd,"/* ");
	    }
	  else
	    strcat(find_em_cmd,"* ");

	  strcat(find_em_cmd,find_options);
/*
   we have to set this back to 'x' so we can find it next time
   if the time to show changes modes...
*/
	  if (time_string1 != NULL) *time_string1 = 'x';
	  if (time_string2 != NULL) *time_string2 = 'x';

	  if ((int)strlen(file_filter) > 0) {
	    strcat(find_em_cmd,"-name '");
	    strcat(find_em_cmd,file_filter);
	    strcat(find_em_cmd,"' ");
	    }
	  strcat(find_em_cmd,"-print ");

	  if (debug_mode)
	    fprintf(stderr,"find cmd: %s\n",find_em_cmd);

	  find_em = popen(find_em_cmd,"r");

	  while (( findfilename = fgets(findfilename,256,find_em)) != NULL) {
/*
	    fprintf(stderr,"found file: %s",findfilename);
*/
	    findfilename[strlen(findfilename)-1 ] = '\0';
	    num_searched_items++;
	    bld_cmd_line(&command,&cmd_size,findfilename);
	    }
	  status = pclose(find_em);
	  if ( status != 0) {
	    post_message(FALSE,shell,
		"Error encountered building file list",XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	    XUnmapWindow(XtDisplay(widget),busy_win);
	    XtFree(command);
	    return;
	    }
	  XtFree(find_em_cmd);
	  XtFree(findfilename);
/*
	  fprintf(stderr,"cmd length after adding find stuff = %d\n",cmd_size);
*/
	  }

	for (indx=0; indx<num_selected_items; indx++) {
	  bld_cmd_line(&command,&cmd_size,(*(selected_list+indx))->name);
	  }

	bld_cmd_line(&command,&cmd_size,
		"| grep -v 'total [0-9]*[0-9]$' | sort -mu");
/*	trailer = command + strlen(command); */
	if (sort_command != NULL) {
/*
fprintf(stderr,"extra sort options - %s\n",sort_command);
*/
	  bld_cmd_line(&command,&cmd_size,sort_command);
	  }

	if (debug_mode)
	  fprintf(stderr,"%s\n",command);
	file_list = popen(command,"r");

	if ( file_list == NULL) {
	  post_message(FALSE,shell,
		"Error encountered building file list",XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  XtFree(command);
	  return;
	  }

	file_list_copy = tmpfile();

	if ( file_list_copy == NULL) {
	  post_message(FALSE,shell,
		"Error encountered building file list",XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  XtFree(command);
	  return;
	  }

	num_list_items = 0;
	while (( charbuf = getc(file_list)) != EOF) {
	  if (charbuf == '\n') num_list_items++;
	  putc(charbuf,file_list_copy);
	  }
	status =  pclose(file_list);
	if (( status != 0 ) || ( num_list_items < num_searched_items )) {
	  post_message(FALSE,shell,
		"Error encountered building file list",XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  XtFree(command);
	  return;
	  }
	rewind(file_list_copy);

	XtVaGetValues(lists[0],XmNitemCount,&num_items,NULL);
/*	trailer = ""; */
/*
	bld_cmd_line(&command,&cmd_size,"| wc -l");
	wc_command = popen(command,"r");
	fscanf(wc_command,"%d",&num_list_items);
*/

	if (num_list_items <= num_selected_items) {
	  post_message(TRUE,shell,
		"No files in current directory match\nthe active filter",
		XmDIALOG_INFORMATION,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
/*   we may be leaking memory here..........................
     ...or maybe not; if we get out here and leave the lists alone.
	  free(sorted_list);
	  free(selected_list);
*/
/* 92202 - see if we can go on through and get an empty list -
   optimally I'd like to post a dialog box here to revert to the previous
   filter and directory settings or continue with the blank list 
	  XtFree(command);
	  XUnmapWindow(XtDisplay(widget),busy_win);
	  return;
*/
	  }


/*
	if ( num_list_items != 0 ) XmListDeleteAllItems(lists[0]);
	if ( num_selected_items != 0 ) XmListDeleteAllItems(lists[1]);
*/
	XmListDeleteAllItems(lists[0]);
	XmListDeleteAllItems(lists[1]);

	old_sorted_list = sorted_list;
	sorted_list = (file_list_item *)
		XtMalloc(num_list_items*sizeof(file_list_item));
	if (sorted_list == NULL)
		malloc_failure(num_list_items*sizeof(file_list_item));

	old_selected_list = selected_list;
	selected_list = (file_list_item **)
		XtMalloc(num_list_items*sizeof(file_list_item *));
	if (selected_list == NULL)
		malloc_failure(num_list_items*sizeof(file_list_item *));

	list_items = (XmString *) XtMalloc(num_list_items*sizeof(XmString));
	selected_list_items = (XmString *)
		XtMalloc(num_selected_items*sizeof(XmString));
	list_item = list_items;
	selected_list_item = selected_list_items;

	pos_ptr = 1;
	active_pos_ptr = 1;
	old_num_selected_items = num_selected_items;
	num_selected_items = 0;
	list_entry = sorted_list;
	while ( fgets(entry,256,file_list_copy) != NULL) {
	  list_entry->selected = FALSE;
	  entry_length = strlen(entry);
	  entry[entry_length-1] = '\0';
	  filename = get_suffix(entry," ");
/*
 - look through the old list and put the selected items into the new list.
   ( they MUST go into the list in the order they are in the list widget)
*/
	  for (indx = 0; indx < old_num_selected_items; indx++) {
	    if (strcmp((*(old_selected_list+indx))->name,filename) == 0) {
	      list_entry->orig_pos = pos_ptr++;
	      list_entry->current_pos = active_pos_ptr;
	      list_entry->selected = TRUE;
	      list_entry->name =
	          (char *) XtMalloc((strlen(filename)+1)*sizeof(char));
	      if (list_entry->name == NULL) 
		malloc_failure((strlen(filename)+1)*sizeof(char));
	      strcpy(list_entry->name,filename);
/* import list debug
	      fprintf(stderr,"allocate string ->%s<- address = %08x\n",
	        list_entry->name,list_entry->name);
*/
	      *(selected_list+selected_indx++) = list_entry;
	      *(selected_list_item++) = 
		XmStringCreateLtoR(entry,XmSTRING_DEFAULT_CHARSET);
	      num_selected_items++;
	      break;
	      }
	    }
	  if ( !list_entry->selected ) {
	    *(list_item++) = XmStringCreateLtoR(entry,XmSTRING_DEFAULT_CHARSET);
	    list_entry->orig_pos = pos_ptr++;
	    list_entry->current_pos = active_pos_ptr++;
	    list_entry->name =
	        (char *) XtMalloc((strlen(filename)+1)*sizeof(char));
	    if (list_entry->name == NULL)
		malloc_failure((strlen(filename)+1)*sizeof(char));
	    strcpy(list_entry->name,filename);
/* import list debug
	    fprintf(stderr,"allocate string ->%s<- address = %08x\n",
	      list_entry->name,list_entry->name);
*/
	    }
	  list_entry++;
	  };

	fclose(file_list_copy);

	if (debug_mode >= 1) {
	  char *marked_file = NULL;
	  fprintf(stderr,"new file list:\n");
	  for (indx = 0, list_item = list_items;
	     indx < (num_list_items-num_selected_items); indx++, list_item++) {
	    XmStringGetLtoR(*list_item,XmSTRING_DEFAULT_CHARSET,&marked_file);
	    fprintf(stderr,"%s\n",marked_file);
	    XtFree(marked_file);
	    }
	  }

/* 	Unmanaged the widgets to overcome geometry management problems in 
	Motif (currently 1.1), especially when height of list_form is close
	to the screen height
*/

/*
	XtUnmanageChild(lists[0]);
	XtUnmanageChild(lists[1]);
*/

	if (num_list_items > num_selected_items)
	  XtVaSetValues(lists[0], XmNitems,list_items,
		XmNitemCount,(int)(num_list_items-num_selected_items),NULL);

/* this may be a little too zealous */
	for (indx = 0, list_item = list_items;
		indx < (num_list_items-num_selected_items); indx++, list_item++)
	  XmStringFree(*list_item);
	XtFree((char *)list_items);

/*
	if (debug_mode >= 0) {
	  char *marked_file = NULL;
	  fprintf(stderr,"sort_list: num_selected_items = %d\n",
		num_selected_items);
	  fprintf(stderr,"sort_list: selected list:\n");
	  for (indx = 0; indx < num_selected_items; indx++)
	    fprintf(stderr,"%s\n",(*(selected_list+indx))->name);
	  fprintf(stderr,"sort_list: selected list items:\n");
	  for (indx = 0, list_item = selected_list_items;
	     indx < num_selected_items; indx++, list_item++) {
	    XmStringGetLtoR(*list_item,XmSTRING_DEFAULT_CHARSET,&marked_file);
	    fprintf(stderr,"%s\n",marked_file);
	    XtFree(marked_file);
	    }
	  }
*/

	if (old_num_selected_items != num_selected_items)
	  post_message(TRUE,shell,
		"Unable to retrieve all selected items\nprobable cause - files deleted",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	XtVaSetValues(lists[1],XmNitems,selected_list_items,
				XmNitemCount,num_selected_items,NULL);

/* this may be a little too zealous */
	for (indx = 0, selected_list_item = selected_list_items;
		indx < num_selected_items; indx++, selected_list_item++)
	  XmStringFree(*selected_list_item);
	XtFree((char *)selected_list_items);

/*		free the old character strings and structures	*/

	for (indx = 0; indx < num_items; indx++) {
/* import list debug 
	  fprintf(stderr,"free string ->%s<- address = %08x\n",
	    (old_sorted_list+indx)->name,(old_sorted_list+indx)->name);
*/
	  free((old_sorted_list+indx)->name);
	  }

	XtFree((char *)old_sorted_list);
	XtFree((char *)old_selected_list);
	XtFree(command);

	XtManageChild(lists[0]);
	XtManageChild(lists[1]);
	XmUpdateDisplay(list_form);
	XtMapWidget(shell);
	XUnmapWindow(XtDisplay(widget),busy_win);

	if (debug_mode) {
	  XtVaGetValues(lists[0],XmNwidth,&width,NULL);
	  fprintf(stderr,"width of lists[0] = %d\n",width);
	  }
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void print_item(item)
file_list_item *item;
{
/* see if we can delete this from the structure
	fprintf(stderr,"\nstring\t= %08x\n",item->string);
*/
	fprintf(stderr,"orig_pos\t= %d\n",item->orig_pos);
	fprintf(stderr,"current_pos\t= %d\n",item->current_pos);
	fprintf(stderr,"selected\t= %d\n",item->selected);
	fprintf(stderr,"name\t= %s\n\n",item->name);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void de_select_item(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int indx;
	file_list_item *list_entry;
	void delete_selected_list_item();

	XmListCallbackStruct *list_cb = (XmListCallbackStruct *) call_data;

  if (debug_mode >= 2) fprintf(stderr,"-> de_select_item <-\n");

	list_entry = *(selected_list+list_cb->item_position-1);

	if (debug_mode) {
	  fprintf(stderr,"De-selected Item:\n");
	  fprintf(stderr,"%d %d %d %s\n",list_entry->orig_pos,list_entry->current_pos,
		list_entry->selected,list_entry->name);
	  }

	list_entry->selected = FALSE;
	XmListAddItem(lists[0], list_cb->item, list_entry->current_pos);

/* this is a kludge to get around a bug in the list widget */

	if (num_selected_items == 1)
	  XmListDeleteAllItems(lists[1]);
	else 
	  XmListDeletePos(lists[1], list_cb->item_position);

	delete_selected_list_item(selected_list,
		num_selected_items,list_cb->item_position);
	num_selected_items--;

	for (indx = list_entry->orig_pos, list_entry++;
		  indx < num_list_items; indx++, list_entry++) {
	  list_entry->current_pos++;
	  }
}

/* get_selection is called when an item in one of the lists is highlighted.
   It stores away a copy of the selection event which may be used if 
   the select or de-select button is pushed, which causes the event to 
   be sent as if a double-click selection took place. I put this mechanism
   in place to avoid a dependency on the double click timing.
   Care was take to avoid memory leaks, but I offer no guarantees....
*/

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void get_selection(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	void free_selection();
	selection **select_event = (selection **)client_data;
/*
	if (*select_event != NULL) free(*select_event);
*/
  if (debug_mode >= 2) fprintf(stderr,"-> get_selection <-\n");
	if (*select_event != NULL) free_selection(widget,
		(XtPointer) select_event,NULL);

/*
	if (debug_mode >= 2)
	  fprintf(stderr,"get_selection: free malloced address = %08x\n",*select_event);
*/
	*select_event = (selection *) XtMalloc(sizeof(selection));
	if (debug_mode >= 2)
	  fprintf(stderr,"get_selection: malloced address = %08x\n",*select_event);
	(*select_event)->list_widget = widget;
	(*select_event)->list_callback = *(XmListCallbackStruct *) call_data;
/*
	(*select_event)->list_callback.item =
		(XmString) XtMalloc(sizeof(XmString));
	if (debug_mode >= 2)
	  fprintf(stderr,"get_selection: malloced address = %08x\n",
		(*select_event)->list_callback.item);
*/

	(*select_event)->list_callback.item =
		XmStringCopy((*(XmListCallbackStruct *) call_data).item);
	if (debug_mode) {
	  char *marked_file = NULL;
	  fprintf(stderr,"widget in get_selection = %08x\n",
			(*select_event)->list_widget);
	  XmStringGetLtoR((*select_event)->list_callback.item,
			XmSTRING_DEFAULT_CHARSET,&marked_file);
	  fprintf(stderr,"marked file = %s\n",marked_file);
	  XtFree(marked_file);
	}
/*
	*(XmListCallbackStruct *)client_data=
		*(XmListCallbackStruct *) call_data;
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void make_selection(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int item_count;
	selection **select_event = (selection **)client_data;
	Widget list_widget;
	XmListCallbackStruct *list_cb;
/*	XEvent *event; */
	Boolean mode_not_selected();

  if (debug_mode >= 2) fprintf(stderr,"-> make_selection <-\n");
	if (*select_event == NULL) {
	  post_message(TRUE,widget,
		"No item has been selected",
		XmDIALOG_WARNING,
	 	TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  return;
	  }

	if (mode_not_selected(widget)) return;

	list_widget = (*select_event)->list_widget;
	list_cb = &((*select_event)->list_callback);
/*	event = list_cb->event; */

	if (debug_mode >=2)
	  fprintf(stderr,"widget in make_selection = %08x\n",list_widget);

	XtVaGetValues((*select_event)->list_widget,
		XmNselectedItemCount,&item_count,NULL);

	if (debug_mode) {
	  char *marked_file = NULL;
	  XmStringGetLtoR(list_cb->item,XmSTRING_DEFAULT_CHARSET,&marked_file);
	  fprintf(stderr,"marked file = %s\n",marked_file);
	  XtFree(marked_file);
	}

/*  don't make the callback unless item_count on the selected widget is 1 */

	if (item_count == 1) 
	  XtCallCallbacks(list_widget,XmNdefaultActionCallback,list_cb);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void free_selection(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int item_count;
	selection **select_event = (selection **)client_data;

/* check to see if the structure is already freed */

  if (debug_mode >= 2) fprintf(stderr,"-> free_selection <-\n");
	if (*select_event == NULL) return;

	XtVaGetValues((*select_event)->list_widget,
		XmNselectedItemCount,&item_count, NULL);
  if (debug_mode >= 2) fprintf(stderr,"item_count = %d\n",item_count);
/*
	if (item_count == 0) {
*/
	  XmStringFree((*select_event)->list_callback.item);
	  if (debug_mode >= 2)
	  fprintf(stderr,
	    "free_selection: malloced address %08x\n",*select_event);
	  XtFree((char *)*select_event);
	  *select_event = NULL;
/*
	  }
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void select_all(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int indx,num_new_items;
	file_list_item *list_entry;
	XmStringTable item_table;
	Boolean mode_not_selected();

  if (debug_mode >= 2) fprintf(stderr,"-> select_all <-\n");
	if (mode_not_selected(widget)) return;

/*
	XtUnmanageChild( lists[0] );
	XtUnmanageChild( lists[1] );
*/

	XtVaGetValues(lists[0], XmNitemCount,&num_new_items, NULL);
        XtVaGetValues(lists[0], XmNitems,&item_table, NULL);

	for (indx=0; indx<num_new_items; indx++) {
/*
c	  new_item = XmStringCopy(item_table[indx]);
c	  XmListAddItemUnselected(lists[1],new_item,0);
c	  XmStringFree(new_item);
*/
 	  XmListAddItemUnselected(lists[1],item_table[indx],0); /* try this */
	  }
/*
c	XtVaGetValues(lists[1],XmNitems,
c		&(item_table[num_list_items-num_selected_items])),NULL);
c
c	if (debug_mode) {
c	char *marked_file = NULL;
c	fprintf(stderr," items to be put in list 1:\n");
c	for (indx=0; indx<num_list_items; indx++) {
c	  marked_file = NULL;
c	  XmStringGetLtoR(item_table[indx],XmSTRING_DEFAULT_CHARSET,&marked_file);
c	  fprintf(stderr,"%s\n",marked_file);
c	  }
c	}
c
c	XtVaSetValues(lists[1],XmNitemCount,(int)num_list_items,
c				XmNitems,item_table,NULL);
c
c	XtVaSetValues(lists[0],XmNitemCount,0,NULL);
*/
	XmListDeleteAllItems(lists[0]);

	for (indx=0, list_entry = sorted_list;
		indx<num_list_items; indx++, list_entry++) {
	  list_entry->current_pos = 1;
	  if (!list_entry->selected) {
	    list_entry->selected = TRUE;
	    *(selected_list + num_selected_items) = list_entry;
	    num_selected_items++;
	    }
	  }
/*
	XtManageChild( lists[0] );
	XtManageChild( lists[1] );
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void de_select_all(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	XmStringTable select_list;  
	file_list_item **selected_list_ptr;
	int indx,indx2,num_items;

  if (debug_mode >= 2) fprintf(stderr,"-> de_select_all <-\n");

	XtVaGetValues(lists[1], XmNitemCount,&num_items, NULL);

	if (num_items == 0) {
	  post_message(TRUE,widget,
		"No items have been selected",
		XmDIALOG_WARNING,
	 	TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  return;
	  }

/*
	XtUnmanageChild(lists[0]);
	XtUnmanageChild(lists[1]);
*/

	XtVaGetValues(lists[1], XmNitems,&select_list, NULL);
	selected_list_ptr = selected_list;

        for (indx=0; indx<num_items; indx++, *selected_list_ptr++) {
	  XmListAddItemUnselected(lists[0],select_list[indx],
		(*selected_list_ptr)->current_pos);
	  (*selected_list_ptr)->selected = FALSE;

	  for (indx2=(*selected_list_ptr)->orig_pos;
		indx2 < num_list_items; indx2++) {
	    (sorted_list+indx2)->current_pos++;
	    }
	  }
	XmUpdateDisplay(lists[0]);
	XmListDeleteAllItems(lists[1]);
	num_selected_items = 0;
/*
	XtManageChild(lists[0]);
	XtManageChild(lists[1]);
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void select_item(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int indx;
	file_list_item *list_entry;
	int item_ptr;
	struct stat file_stat;
	XmListCallbackStruct *list_cb = (XmListCallbackStruct *) call_data;
	Boolean mode_not_selected();
	void dir_not_allowed();
	int item_count;

  if (debug_mode >= 2) fprintf(stderr,"-> select_item <-\n");
	if (debug_mode)
	  fprintf(stderr,"select item: call_data = %08x\n",call_data);
	
	if (debug_mode >= 2) {
	 fprintf(stderr,"select_item:\n widget = %08x\n",widget);
	 fprintf(stderr,"reason = %d\n",list_cb->reason);
	 fprintf(stderr,"item = %08x\n",&(list_cb->item));
	 fprintf(stderr,"item_length = %d\n",list_cb->item_length);
	 fprintf(stderr,"item_position = %d\n",list_cb->item_position);
	 }

	if (mode_not_selected(widget)) return;

	item_ptr = list_cb->item_position-1;
	list_entry = sorted_list+item_ptr;

	if ((mode == ARCHIVAL) && (archival_mode == IBM_ARCHIVAL_TAPE)) {
	  if (num_selected_items != 0) {
	    post_message(FALSE,widget,
		"Only one file may be specified for IBM archival",
		XmDIALOG_WARNING,
	 	TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	    return;
	    }
	  if (!get_file_info(list_entry->name,&file_stat)) return;
	  if ((file_stat.st_mode & S_IFMT) == S_IFDIR ) {
	    dir_not_allowed(list_entry->name);
	    return;
	    }
	  }

	if (debug_mode) fprintf(stderr,"marked file = %s\n",list_entry->name);

	for (indx=0;
	  indx<num_list_items;
	    indx++, list_entry++, item_ptr++) {
	  if (( !list_entry->selected ) &&
	     (list_entry->current_pos == list_cb->item_position)) {

	    if (!get_file_info(list_entry->name,&file_stat)) {
/*
	      cant_process(list_entry->name);
*/
	      XmListSelectPos(lists[0],list_cb->item_position,FALSE);
	      return;
	      }

	    if (debug_mode) {
	      fprintf(stderr,"Selected Item:\n");
	      fprintf(stderr,"%d %d %d %s\n",
		list_entry->orig_pos,list_entry->current_pos,
		list_entry->selected,list_entry->name);
	      }
	    list_entry->selected = TRUE;
	    *(selected_list+num_selected_items) = list_entry;
	    num_selected_items++;
	    break;
	    }
	  }
	
	for (indx = item_ptr+1, list_entry++;
	  indx<num_list_items; indx++, list_entry++) list_entry->current_pos--;

/* 	Unmanaged the widgets to overcome geometry management problems in 
	Motif (currently 1.1), especially when height of list_form is close
	to the screen height
*/
/* let's see if these are really necessary
	XtUnmanageChild(lists[0]);
	XtUnmanageChild(lists[1]);
	XtUnmanageChild(list_form);
*/
	XmListAddItemUnselected(lists[1], list_cb->item, 0);

/* this is a kludge to get around a bug in the list widget */

	XtVaGetValues(lists[0],XmNitemCount, &item_count, NULL);
	if (item_count == 1)
	  XmListDeleteAllItems(lists[0]);
	else
	  XmListDeletePos(lists[0], list_cb->item_position);

/* let's see if these are really necessary
	XtManageChild(lists[0]);
	XtManageChild(lists[1]);
	XtManageChild(list_form);
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
Boolean mode_not_selected(trigger)
Widget trigger;
{
  if (debug_mode >= 2) fprintf(stderr,"-> mode_not_selected <-\n");
	if (mode == 0) {
	  post_message(FALSE,trigger,
		"You must select a mode first",XmDIALOG_MESSAGE,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
/*
	  XmListSelectPos(lists[0], list_cb->item_position, TRUE);
	  if (list_cb->reason == XmCR_SINGLE_SELECT)
		XmStringFree(list_cb->item);
*/
	  return(TRUE);
	  }
	return(FALSE);
}
/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
/* XtCallbackProc */ void print_lists()
{
	int indx;
	file_list_item *list_entry;

  if (debug_mode >= 2) fprintf(stderr,"-> print_lists <-\n");

/*
	if (debug_mode) {
*/
	  fprintf(stderr,"Sorted List:\n");
	  for (indx=0,
	    list_entry=sorted_list;
	      indx<num_list_items;indx++,list_entry++)
	   fprintf(stderr,"%d %d %d %s\n",list_entry->orig_pos,
		list_entry->current_pos,list_entry->selected,list_entry->name);

	  fprintf(stderr,"Selected List:\n");
	  for (indx=0; indx<num_selected_items; indx++) {
	    list_entry = *(selected_list+indx);
 	    fprintf(stderr,"%d %d %d %s\n",list_entry->orig_pos,
		list_entry->current_pos,list_entry->selected,list_entry->name);
	    }
/*
	  }
*/
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void delete_selected_list_item(list,num_items,delete_indx)
file_list_item **list;
int num_items,delete_indx;
{
	int indx;
	file_list_item **list_entry;
  if (debug_mode >= 2) fprintf(stderr,"-> delete_selected_list_item <-\n");
	list_entry = list+delete_indx-1;
	for (indx = 0; indx < num_items-delete_indx; indx++, list_entry++)
	  *list_entry = *(list_entry+1);
}

/*ARGSUSED*/			/* this comment is to satisfy Saber-C */
void delete_sorted_list_item(list,num_items,delete_indx)
file_list_item *list;
int num_items,delete_indx;
{
	int indx;
	file_list_item *list_entry;
  if (debug_mode >= 2) fprintf(stderr,"-> delete_sorted_list_item <-\n");
	list_entry = list+delete_indx-1;
	for (indx = 0; indx < num_items-delete_indx; indx++, list_entry++) {
	  *list_entry = *(list_entry+1);
	  list_entry->orig_pos--;
	  }
}

void main(argc,argv)
     int argc;
     char **argv;
{
	Display *dpy;
	Window top_window;
	unsigned int screen_number;
	Widget pwd_label;
	Widget delete,chdir_but,quit;
  	Widget debug_pulldown,debug_opt_0,debug_opt_1,debug_opt_2,debug_opt_3;
	Widget tree_but;
	Widget db_level_pulldown,db_level_but;
	Widget file_pulldown,file_but;
	Widget mode_pulldown,mode_but;
	Widget tape_pulldown,tape_but;
	Widget list_pulldown,list_but;
	Widget help_pulldown,help_but,help_general;
	Widget import,export,recover,save_processed;
	Widget save_dialog = NULL;
	Widget display_pulldown,display_but,remote_tar_but ;
	Widget display_dialog;
	Widget apply_form;
	Widget separator1,option_but,sorting_but,menubar;
	Widget searching_but,search_dialog;
	Widget list0_buttons,select_all_but;
	Widget deselect_but,deselect_all_but;
	Widget filter_label;
	Widget edit_pd,edit_but;
	Widget option_pd,fd_options_but,floppy_pd,fd_format_but,fd_eject_but;
	Widget display_menu(),search_menu();
/*
	XtCallbackRec helpCB[2];
*/
	XmString list_label,button_label,accel_label;
	XtTranslations trans_table;
	ApplicationData res_data;
	char *getcwd();
	XEvent event;
	selection *single_select = NULL;
	char *res_path;
	char *help_path;
	unsigned long mask;
	XSetWindowAttributes attr;
	Atom delete_atom;
	void tar_device_menu(),set_the_options(),tree();
	void dismiss_dialog(),pop_the_dialog(),fd_eject();
	void save_list(),retrieve_list();
	void recover_list(), save_processed_files();
	void save_processed_list();
	void QueryWidget();

	shell = XtAppInitialize(&app_con,"Dskutil",cmd_line_opts,
		XtNumber(cmd_line_opts),&argc,argv,app_defs,NULL,0);

	XtGetApplicationResources(shell,&res_data,resources,XtNumber(resources),
		NULL,0);

/* Create some label strings which get reused */

	debug_mode = res_data.debug_mode;
	bool_label[TRUE] = XmStringCreateLtoR("Yes",XmSTRING_DEFAULT_CHARSET);
	bool_label[FALSE] = XmStringCreateLtoR("No",XmSTRING_DEFAULT_CHARSET);
	path_labels[TRUE] = XmStringCreateLtoR("Full",XmSTRING_DEFAULT_CHARSET);
	path_labels[FALSE] = XmStringCreateLtoR("Relative",XmSTRING_DEFAULT_CHARSET);

/* Get list of groups to which user belongs */

	group_ids = (int *) malloc(NGROUPS_MAX*sizeof(int));
	num_groups = getgroups(NGROUPS_MAX,group_ids);
	group_ids = (int *) realloc(group_ids, num_groups*sizeof(int));

	XtVaSetValues(shell,
			XmNallowShellResize,	TRUE,
			XmNmappedWhenManaged,	FALSE,
			NULL);

/*
	XtAppAddActions(app_con, actionsTable, 1);
*/

	if (debug_mode) {
	  fprintf(stderr," Release = %d\n",VendorRelease(XtDisplay(shell)));
	  res_path = XtResolvePathname(XtDisplay(shell),"app-defaults",
		NULL,NULL,NULL,NULL,0,NULL);
          fprintf(stderr,"path for resources is %s\n",res_path);
	  }

	list_form = XtVaCreateManagedWidget("lform",xmFormWidgetClass,shell,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
/* April 3 - 11:15
			XmNresizable,		FALSE,
			XmNresizePolicy,	XmRESIZE_NONE,
			XmNresizePolicy,	XmRESIZE_GROW,
			XmNx,			10,
*/
			XmNverticalSpacing,	5,
			NULL);
/*
	XuSet_Help(  list_form, "list_form.help" );
*/

	menubar = XmCreateMenuBar(list_form,"menuBar",Xarg,nargs);
	XtVaSetValues(menubar,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			NULL);
	XtManageChild(menubar);
	XuSet_Help(menubar,"MenuB_Dsc.help");

	XuCreateHelpPulldown(menubar);
	XuSet_Help_Shell(shell);
	help_path = getenv("DSKUTIL_HELPDIR");
	if (help_path == (char *)NULL) help_path = ".";
	XuSet_Help_Path(help_path);
	XuSet_Help_Index(help_items,(sizeof(help_items)/sizeof(char *))/2);
	XuSet_Help_Version(version);

  	file_pulldown = XmCreatePulldownMenu(menubar,"file_pd",NULL,0);
	XuSet_Help(  file_pulldown, "File_Dsc.help" );

  	file_but = XtVaCreateManagedWidget("File",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'F',
			XmNsubMenuId,		file_pulldown,
			NULL);
	XuSet_Help(  file_but, "File_Dsc.help" );

	button_label = XmStringCreate("Deletion",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+D",XmSTRING_DEFAULT_CHARSET);
	delete = XtVaCreateManagedWidget("delete",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'D',
			XmNaccelerator, 	"Ctrl<Key>d",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XtAddCallback(delete, XmNactivateCallback,
				remove_file, (XtPointer)NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

  	tape_pulldown = XmCreatePulldownMenu(file_pulldown,"tape_pd",NULL,0);
	XuSet_Help(  tape_pulldown, "Arch_Desc.help" );

	button_label =
		XmStringCreate("Archival",XmSTRING_DEFAULT_CHARSET);
  	tape_but = XtVaCreateManagedWidget("tape",
		xmCascadeButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'A',
			XmNlabelString,		button_label,
			XmNsubMenuId,		tape_pulldown,
			NULL);
	XmStringFree(button_label);
	XuSet_Help(  tape_but, "Arch_Desc.help" );

	button_label =
		XmStringCreate("Tar Tape",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+T",XmSTRING_DEFAULT_CHARSET);
	tar_tape_but = XtVaCreateManagedWidget("tar_tape",
		xmPushButtonWidgetClass, tape_pulldown,
			XmNmnemonic,		'T',
			XmNaccelerator, 	"Ctrl<Key>t",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);
	tar_device_menu(tar_tape_but,arch_parms,TAR_ARCHIVAL_TAPE);

	button_label =
		XmStringCreate("Tar File",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+L",XmSTRING_DEFAULT_CHARSET);
	tar_file_but = XtVaCreateManagedWidget("tar_file",
		xmPushButtonWidgetClass, tape_pulldown,
			XmNmnemonic,		'F',
			XmNaccelerator, 	"Ctrl<Key>l",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	button_label =
		XmStringCreate("Remote Device",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+R",XmSTRING_DEFAULT_CHARSET);
	remote_tar_but = XtVaCreateManagedWidget("remote_tar",
		xmPushButtonWidgetClass, tape_pulldown,
			XmNmnemonic,		'R',
			XmNaccelerator, 	"Ctrl<Key>r",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	tar_device_menu(remote_tar_but,arch_parms,TAR_REMOTE_DEVICE);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	button_label = XmStringCreate("Cray Format Tape",
			XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+C",XmSTRING_DEFAULT_CHARSET);
	cray_tape_but = XtVaCreateManagedWidget("cray_tape",
		xmPushButtonWidgetClass, tape_pulldown,
			XmNmnemonic,		'C',
			XmNaccelerator, 	"Ctrl<Key>c",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
#ifndef CRAYSYSTEM
			XmNsensitive, FALSE,
#endif
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

        tape_menu(cray_tape_but,arch_parms,CRAY_ARCHIVAL_TAPE);

	button_label = XmStringCreate
		("IBM Format Tape",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+I",XmSTRING_DEFAULT_CHARSET);
	usp_tape_but = XtVaCreateManagedWidget("usp_tape",
		xmPushButtonWidgetClass, tape_pulldown,
			XmNmnemonic,		'I',
			XmNaccelerator, 	"Ctrl<Key>i",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
#ifndef CRAYSYSTEM
			XmNsensitive, FALSE,
#endif
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

        tape_menu(usp_tape_but,arch_parms,IBM_ARCHIVAL_TAPE);

  	list_pulldown = XmCreatePulldownMenu(file_pulldown,"list_pd",NULL,0);
	XuSet_Help(  list_pulldown, "FileList.help" );

	button_label = XmStringCreate("File Lists",
	  XmSTRING_DEFAULT_CHARSET);
	list_but = XtVaCreateManagedWidget("lists",
		xmCascadeButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'F',
			XmNlabelString,		button_label,
			XmNsubMenuId,		list_pulldown,
			NULL);
	XmStringFree(button_label);
	XuSet_Help(  list_but, "FileList.help" );

	button_label = XmStringCreate("Store selections in file",
	  XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+X",XmSTRING_DEFAULT_CHARSET);
	export = XtVaCreateManagedWidget("export",
		xmPushButtonWidgetClass, list_pulldown,
			XmNmnemonic,		'S',
			XmNaccelerator,		"Ctrl<Key>x",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);
	XuSet_Help(  export, "Sv_Files.help" );

	button_label = XmStringCreate("Retrieve selections from file",
	  XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+M",XmSTRING_DEFAULT_CHARSET);
	import = XtVaCreateManagedWidget("import",
		xmPushButtonWidgetClass, list_pulldown,
			XmNmnemonic,		'R',
			XmNaccelerator, 	"Ctrl<Key>m",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	button_label = XmStringCreate(
		"Restore processed selections",
		XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+E",XmSTRING_DEFAULT_CHARSET);
	recover = XtVaCreateManagedWidget("recover",
		xmPushButtonWidgetClass, list_pulldown,
			XmNmnemonic,		'e',
			XmNaccelerator, 	"Ctrl<Key>e",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	button_label = XmStringCreate(
		"Save processed selections to file",
		XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+S",XmSTRING_DEFAULT_CHARSET);
	save_processed = XtVaCreateManagedWidget("save_processed",
		xmPushButtonWidgetClass, list_pulldown,
			XmNmnemonic,		'p',
			XmNaccelerator, 	"Ctrl<Key>s",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	XtAddCallback(export, XmNactivateCallback,
				save_list, (XtPointer) &save_dialog);
	XtAddCallback(import, XmNactivateCallback,
				retrieve_list, (XtPointer) &save_dialog);
	XtAddCallback(recover, XmNactivateCallback,
				recover_list, (XtPointer) &save_dialog);
	XtAddCallback(save_processed, XmNactivateCallback,
				save_processed_list, (XtPointer) &save_dialog);

	accel_label = XmStringCreate("Ctrl+Q",XmSTRING_DEFAULT_CHARSET);
	quit = XtVaCreateManagedWidget("Exit",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic, 		'E',
			XmNaccelerator, 	"Ctrl<Key>q",
			XmNacceleratorText,	accel_label,
			NULL);
	XmStringFree(accel_label);
	XtAddCallback(quit, XmNactivateCallback, bye_bye, NULL );
	XtManageChild(quit);
	XuSet_Help( quit, "Quit_Desc.help");

  	edit_pd = XmCreatePulldownMenu(menubar,"edit_pd",NULL,0);

	button_label = XmStringCreate("Edit",XmSTRING_DEFAULT_CHARSET);
  	edit_but = XtVaCreateManagedWidget("Edit",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'E',
			XmNlabelString,		button_label,
			XmNsubMenuId,		edit_pd,
			NULL);
	XmStringFree(button_label);
	XuSet_Help( edit_but, "Edit_Dsc.help");

	button_label = XmStringCreate("Go to Sub-directory",
		XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+G",XmSTRING_DEFAULT_CHARSET);
	chdir_but = XtVaCreateManagedWidget("chdir",
		xmPushButtonWidgetClass, edit_pd,
			XmNmnemonic,		'G',
			XmNaccelerator,		"Ctrl<Key>g",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XtAddCallback(chdir_but, XmNactivateCallback,
				goto_subdir, (XtPointer)&list1_text_label);
	XtAddCallback(chdir_but, XmNactivateCallback,
				free_selection, (XtPointer)&single_select);
	XmStringFree(button_label);
	XmStringFree(accel_label);
	XuSet_Help( chdir_but, "SubDir.help");

	button_label = XmStringCreate("Go to Parent Directory",
		XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+P",XmSTRING_DEFAULT_CHARSET);
	chdir_but = XtVaCreateManagedWidget("chdir",
		xmPushButtonWidgetClass, edit_pd,
			XmNmnemonic,		'P',
			XmNaccelerator, 	"Ctrl<Key>p",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XtAddCallback(chdir_but, XmNactivateCallback,
				goto_parent, (XtPointer)&list1_text_label);
	XmStringFree(button_label);
	XmStringFree(accel_label);

 	option_pd = XmCreatePulldownMenu(menubar,"options_pd",NULL,0);

  	floppy_pd = XmCreatePulldownMenu(option_pd,"floppy_pd",NULL,0);

	button_label = XmStringCreate("Options",XmSTRING_DEFAULT_CHARSET);
  	option_but = XtVaCreateManagedWidget("Options",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'O',
			XmNlabelString,		button_label,
			XmNsubMenuId,		option_pd,
			NULL);
	XmStringFree(button_label);
	XuSet_Help( option_but, "Opt_Dsc.help");

	button_label = XmStringCreate("Floppy",
		XmSTRING_DEFAULT_CHARSET);
	fd_options_but = XtVaCreateManagedWidget("fd_options",
		xmCascadeButtonWidgetClass, option_pd,
			XmNmnemonic,		'F',
			XmNlabelString,		button_label,
			XmNsubMenuId,		floppy_pd,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Format Floppy",
		XmSTRING_DEFAULT_CHARSET);
	fd_format_but = XtVaCreateManagedWidget("fd_format",
		xmPushButtonWidgetClass, floppy_pd,
			XmNmnemonic,		'F',
			XmNlabelString,		button_label,
			NULL);
	floppy_menu(fd_format_but);
	XmStringFree(button_label);

	button_label = XmStringCreate("Eject Floppy", XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+J", XmSTRING_DEFAULT_CHARSET);
	fd_eject_but = XtVaCreateManagedWidget("fd_eject",
		xmPushButtonWidgetClass, floppy_pd,
			XmNmnemonic,		'E',
			XmNaccelerator,		"Ctrl<Key>J",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);
	XtAddCallback(fd_eject_but, XmNactivateCallback, fd_eject, NULL);
	XtManageChild(option_pd);
	XtManageChild(floppy_pd);

  	display_pulldown = XmCreatePulldownMenu(menubar,"display",NULL,0);

	button_label = XmStringCreate("View",XmSTRING_DEFAULT_CHARSET);
  	display_but = XtVaCreateManagedWidget("View",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'V',
			XmNlabelString,		button_label,
			XmNsubMenuId,		display_pulldown,
			NULL);
	XmStringFree(button_label);
	XuSet_Help( display_but, "View_Dsc.help");

	button_label = XmStringCreate("Sorting",
		XmSTRING_DEFAULT_CHARSET);
	sorting_but = XtVaCreateManagedWidget("sorting",
		xmPushButtonWidgetClass, display_pulldown,
			XmNmnemonic,		'S',
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);

	button_label = XmStringCreate("Searching",XmSTRING_DEFAULT_CHARSET);
  	searching_but = XtVaCreateManagedWidget("searching",
		xmCascadeButtonWidgetClass, display_pulldown,
			XmNmnemonic,		'E',
			XmNlabelString,		button_label,
			NULL);
	XmStringFree(button_label);

	XuSet_Help( display_but, "View_Dsc.help");
  	debug_pulldown = XmCreatePulldownMenu(menubar,"debug_pd",NULL,0);

	XuSet_Help(debug_pulldown,"Debug_Dsc.help");
	XtManageChild(debug_pulldown);

	button_label =
		XmStringCreate("Debug Mode",XmSTRING_DEFAULT_CHARSET);
  	debug_but = XtVaCreateWidget("debug",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'Z',
			XmNsubMenuId,		debug_pulldown,
			XmNlabelString,		button_label,
			XmNmappedWhenManaged,	FALSE,
			NULL);

	XtManageChild(debug_but);
	XmStringFree(button_label);
	if (debug_mode)
	  XtMapWidget(debug_but);

	button_label = XmStringCreate(
		"Print current lists", XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Alt<Key>P",XmSTRING_DEFAULT_CHARSET);
	print_lists_but = XtVaCreateWidget("print_lists",
		xmPushButtonWidgetClass, debug_pulldown,
			XmNlabelString,		button_label,
			XmNaccelerator,		"Alt<Key>p",
			XmNacceleratorText,	accel_label,
			NULL);
	XmStringFree(button_label);
	XmStringFree(accel_label);
	XtAddCallback(print_lists_but,XmNactivateCallback,print_lists,NULL);
	XtManageChild(print_lists_but);

	button_label = XmStringCreate("show tree of selected widget",
			XmSTRING_DEFAULT_CHARSET);
	tree_but = XtVaCreateManagedWidget("debug",
		xmPushButtonWidgetClass, debug_pulldown,
			XmNlabelString,		button_label,
			NULL);
	XtAddCallback(tree_but, XmNactivateCallback, QueryWidget,shell);
	XmStringFree(button_label);

  	db_level_pulldown = XmCreatePulldownMenu(debug_pulldown,
		"db_level_pd",NULL,0);
	XtVaSetValues(db_level_pulldown,
			XmNradioBehavior,	TRUE,
			NULL);

	XtManageChild(db_level_pulldown);

	button_label = XmStringCreate("level",
			XmSTRING_DEFAULT_CHARSET);
	db_level_but = XtVaCreateManagedWidget("debug",
		xmCascadeButtonWidgetClass, debug_pulldown,
			XmNlabelString,		button_label,
			XmNsubMenuId,		db_level_pulldown,
			XmNradioBehavior,	TRUE,
			NULL);
	XmStringFree(button_label);

	button_label =
		XmStringCreate("debug off",XmSTRING_DEFAULT_CHARSET);
	debug_opt_0 = XtVaCreateManagedWidget("debug",
		xmToggleButtonWidgetClass, db_level_pulldown,
			XmNlabelString,		button_label,
			XmNindicatorType,	XmONE_OF_MANY,
			XmNvisibleWhenOff,	TRUE,
			NULL);
	XtAddCallback(debug_opt_0, XmNvalueChangedCallback, 
		(XtCallbackProc) debug_set_state, (XtPointer) 0);
	XmStringFree(button_label);

	button_label =
		XmStringCreate("level 1",XmSTRING_DEFAULT_CHARSET);
	debug_opt_1 = XtVaCreateManagedWidget("debug",
		xmToggleButtonWidgetClass, db_level_pulldown,
			XmNlabelString,		button_label,
			XmNindicatorType,	XmONE_OF_MANY,
			XmNvisibleWhenOff,	TRUE,
			NULL);
	XtAddCallback(debug_opt_1, XmNvalueChangedCallback, 
		(XtCallbackProc) debug_set_state, (XtPointer) 1);
	XmStringFree(button_label);

	button_label =
		XmStringCreate("level 2",XmSTRING_DEFAULT_CHARSET);
	debug_opt_2 = XtVaCreateManagedWidget("debug",
		xmToggleButtonWidgetClass, db_level_pulldown,
			XmNlabelString,		button_label,
			XmNindicatorType,	XmONE_OF_MANY,
			XmNvisibleWhenOff,	TRUE,
			NULL);
	XtAddCallback(debug_opt_2, XmNvalueChangedCallback, 
		(XtCallbackProc) debug_set_state, (XtPointer) 2);
	XmStringFree(button_label);

	button_label =
		XmStringCreate("level 3 (events)",XmSTRING_DEFAULT_CHARSET);
	debug_opt_3 = XtVaCreateManagedWidget("debug",
		xmToggleButtonWidgetClass, db_level_pulldown,
			XmNlabelString,		button_label,
			XmNindicatorType,	XmONE_OF_MANY,
			XmNvisibleWhenOff,	TRUE,
			NULL);
	XtAddCallback(debug_opt_3, XmNvalueChangedCallback, 
		(XtCallbackProc) debug_set_state, (XtPointer) 3);
	XmStringFree(button_label);

	switch (debug_mode) {
	  case 0:
	    XtVaSetValues(debug_opt_0,XmNset,TRUE,NULL);
	    break;
	  case 1:
	    XtVaSetValues(debug_opt_1,XmNset,TRUE,NULL);
	    break;
	  case 2:
	    XtVaSetValues(debug_opt_2,XmNset,TRUE,NULL);
	    break;
	  case 3:
	    XtVaSetValues(debug_opt_3,XmNset,TRUE,NULL);
	    break;
	    }

	XtAddEventHandler(menubar,ButtonPressMask,FALSE,
		(XtCallbackProc) show_debug_mode, (XtPointer) NULL);
	XtManageChild(debug_pulldown);
  	XtManageChild(menubar);

	display_dialog = display_menu(sorting_but);
	search_dialog = search_menu(searching_but);

	separator1 = XtVaCreateManagedWidget("separator1",
		xmSeparatorWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menubar,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL);

	list_label = XmStringCreate("File filter",XmSTRING_DEFAULT_CHARSET);
	filter_label = XtVaCreateManagedWidget("filter_label",
		xmLabelWidgetClass, list_form,
        		XmNlabelString,		list_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		separator1,
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
			NULL);
	XmStringFree(list_label);

	filter_text = XtVaCreateManagedWidget("filter_text",
		xmTextWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		filter_label,
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
			NULL);
	XtAddCallback(filter_text,XmNactivateCallback,sort_list,NULL);
	XuSet_Help(  filter_text, "FilterDsc.help" );

	XtVaGetValues(filter_text, XmNvalue,&file_filter, NULL);

	list_label = XmStringCreate("Files under directory:",
		XmSTRING_DEFAULT_CHARSET);
        pwd_label = XtVaCreateManagedWidget("pwd_label",
		xmLabelWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		filter_text,
        		XmNlabelString,		list_label,
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
			NULL);
	XmStringFree(list_label);

        list1_text_label = XtVaCreateManagedWidget("dir_text",
		xmTextWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		pwd_label,
        		XmNresizeWidth,		TRUE,
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
			NULL);
	XtAddCallback(list1_text_label,XmNactivateCallback,sort_list,NULL);
	XuSet_Help(  list1_text_label, "DirectDsc.help" );

	XtVaGetValues(list1_text_label, XmNvalue,&current_dir, NULL);

/* nothing was in app-defaults; use current directory */

	if (strlen(current_dir) == 0) {
/*
	  current_dir = getcwd((char *)NULL,MAXPATHLEN);
*/
	  current_dir = getcwd((char *)NULL,64);
	  if (current_dir == NULL) {
	    XtRealizeWidget(shell);
	    post_message(TRUE,shell,
		"Error getting current directory; using /",XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	    current_dir = "/";
	    }
	  XtVaSetValues(list1_text_label,
			XmNvalue,		current_dir,
			XmNcolumns,		strlen(current_dir),
			NULL);
	  }


/* We needed the current_dir before setting up the tar-file menu */

	tar_device_menu(tar_file_but,arch_parms,TAR_ARCHIVAL_FILE);

	nargs = 0;
	XtSetArg(Xarg[nargs],XmNtopAttachment, XmATTACH_WIDGET);	nargs++;
	XtSetArg(Xarg[nargs],XmNtopWidget, list1_text_label);	nargs++;
	XtSetArg(Xarg[nargs],XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET);
	nargs++;
	XtSetArg(Xarg[nargs],XmNleftWidget,		menubar);	nargs++;
	XtSetArg(Xarg[nargs],XmNrightAttachment,	XmATTACH_FORM); nargs++;
	XtSetArg(Xarg[nargs],XmNrightOffset,	5);		nargs++;
/*
	XtSetArg(Xarg[nargs],XmNleftAttachment,	XmATTACH_FORM);	nargs++;
	XtSetArg(Xarg[nargs],XmNleftOffset,		10);	nargs++;
	XtSetArg(Xarg[nargs],XmNrightOffset,		10);	nargs++;
*/
/*
	XtSetArg(Xarg[nargs],XmNresizePolicy,	XmRESIZE_GROW);	nargs++;
	XtSetArg(Xarg[nargs],XmNmappedWhenManaged, FALSE); nargs++;
*/
	XtSetArg(Xarg[nargs],XmNborderWidth,		0);	nargs++;
/*
	XtSetArg(Xarg[nargs],XmNselectionPolicy,	XmSINGLE_SELECT); nargs++;
*/
	lists[0] = XmCreateScrolledList(list_form,"file_mgr", Xarg, nargs);
	XtAddCallback(lists[0],XmNdefaultActionCallback,select_item,NULL);
	XtAddCallback(lists[0],XmNdefaultActionCallback,
		free_selection,&single_select);
/*
	XtAddCallback(lists[0],XmNsingleSelectionCallback,
*/
	XtAddCallback(lists[0],XmNbrowseSelectionCallback,
		get_selection,&single_select);
	XuSet_Help(  lists[0], "List0_Dsc.help" );
	XtManageChild(lists[0]);

/*
	defaultTranslations = (char *)malloc(48*sizeof(char));
	sprintf(defaultTranslations,"Ctrl<Key>G: SubDirAccel(%d)",chdir_but);
	trans_table = XtParseTranslationTable(defaultTranslations);
	XtAugmentTranslations(lists[0], trans_table);
*/

	list0_buttons = XtVaCreateManagedWidget("buttonform",
		xmFormWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		lists[0],
			XmNrightAttachment,	XmATTACH_FORM,
/*
			XmNleftAttachment,	XmATTACH_FORM,
			XmNorientation,		XmHORIZONTAL,
			XmNpacking,		XmPACK_COLUMN,
*/
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
			NULL);

	XuSet_Help( list0_buttons, "Select_B.help" );

	select_but = XtVaCreateManagedWidget("Select",
		xmPushButtonWidgetClass, list0_buttons,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	25,
			NULL);

	XtAddCallback(select_but,XmNactivateCallback,
		make_selection,&single_select);

	button_label = XmStringCreate("Select All",XmSTRING_DEFAULT_CHARSET);
	select_all_but = XtVaCreateManagedWidget("select-all",
		xmPushButtonWidgetClass, list0_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		select_but,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	50,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(select_all_but,XmNactivateCallback,select_all,NULL);
	XtAddCallback(select_all_but,XmNactivateCallback,
		free_selection,&single_select);

	deselect_but = XtVaCreateManagedWidget("De-Select",
		xmPushButtonWidgetClass, list0_buttons,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		select_all_but,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	75,
			NULL);
	XtAddCallback(deselect_but,XmNactivateCallback,
		make_selection,&single_select);

	button_label = XmStringCreate("De-Select All",XmSTRING_DEFAULT_CHARSET);
	deselect_all_but = XtVaCreateManagedWidget("de-select-all",
		xmPushButtonWidgetClass, list0_buttons,
        		XmNlabelString,		button_label,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		deselect_but,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);
	XmStringFree(button_label);

	XtAddCallback(deselect_all_but,XmNactivateCallback,
		de_select_all,NULL);
	XtAddCallback(deselect_all_but,XmNactivateCallback,
		free_selection,&single_select);

  	XtManageChild(list0_buttons);

/*
	XtManageChild(list_form);
*/

	list_label = XmStringCreate("Selected Files:",XmSTRING_DEFAULT_CHARSET);
        list2_label = XtVaCreateManagedWidget("list2_label",
		xmLabelWidgetClass, list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		list0_buttons,
			XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,		menubar,
        		XmNlabelString,		list_label,
			NULL);
	XmStringFree(list_label);

	nargs = 0;
	XtSetArg(Xarg[nargs],XmNtopAttachment, XmATTACH_WIDGET);		nargs++;
	XtSetArg(Xarg[nargs],XmNtopWidget, list2_label);			nargs++;
	XtSetArg(Xarg[nargs],XmNrightAttachment,	XmATTACH_FORM);		nargs++;
	XtSetArg(Xarg[nargs],XmNrightOffset,	5);			nargs++;
	XtSetArg(Xarg[nargs],XmNleftAttachment,	XmATTACH_OPPOSITE_WIDGET);
	nargs++;
	XtSetArg(Xarg[nargs],XmNleftWidget,		menubar);	nargs++;
/*
	XtSetArg(Xarg[nargs],XmNleftAttachment,	XmATTACH_FORM);		nargs++;
	XtSetArg(Xarg[nargs],XmNleftOffset,		10);		nargs++;
*/
	XtSetArg(Xarg[nargs],XmNitemCount,		0);		nargs++;
/*
	XtSetArg(Xarg[nargs],XmNselectionPolicy,	XmSINGLE_SELECT);	nargs++;
*/
/*
	XtSetArg(Xarg[nargs],XmNmappedWhenManaged, FALSE); nargs++;
	XtSetArg(Xarg[nargs],XmNscrollingPolicy,	XmAUTOMATIC);		nargs++;
	XtSetArg(Xarg[nargs],XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET);
									nargs++;
	XtSetArg(Xarg[nargs],XmNrightWidget, list_form);			nargs++;
	XtSetArg(Xarg[nargs],XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET);
									nargs++;
	XtSetArg(Xarg[nargs],XmNleftWidget, list_form);			nargs++;
	XtSetArg(Xarg[nargs],XmNvisibleItemCount,	10);		nargs++;
	XtSetArg(Xarg[nargs],XmNlistSizePolicy,XmRESIZE_IF_POSSIBLE);	nargs++;
*/
	lists[1] = XmCreateScrolledList(list_form,"pick_list", Xarg, nargs);

	XtAddCallback(lists[1],XmNdefaultActionCallback,de_select_item,lists);
	XtAddCallback(lists[1],XmNdefaultActionCallback,
		free_selection,&single_select);
/*
	XtAddCallback(lists[1],XmNsingleSelectionCallback,
*/
	XtAddCallback(lists[1],XmNbrowseSelectionCallback,
		get_selection,&single_select);
	XuSet_Help(  lists[1], "List1_Dsc.help" );
	XtManageChild(lists[1]);

	apply_form = XtVaCreateManagedWidget("apply_form",
		xmFormWidgetClass,list_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		lists[1],
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,	10,
			NULL);

	apply_but = XtVaCreateWidget("apply",
		xmPushButtonWidgetClass, apply_form,
			NULL);
	XtAddCallback(apply_but, XmNactivateCallback,
				confirm_processing, (XtPointer) NULL);
/*
	XtAddCallback(apply_but, XmNactivateCallback,
				confirm_processing , (XtPointer) save_dialog);
*/
/*
	XtManageChild(list_form);
*/


	/* Make the widgets appear on the screen. */
	XtRealizeWidget(shell);

	/* print the widget hierarchy */

	dpy = XtDisplay(shell);
	top_window = XtWindow(shell);
	screen_number = DefaultScreen(dpy);
/*
	screen = XScreenOfDisplay(dpy,screen_number);
*/
	display_string = DisplayString(dpy);

	if (debug_mode) {
	  Widget dummy;
	  dummy = XtWindowToWidget(dpy,top_window);
	  fprintf(stderr,"shell = %08x  dummy = %08x\n",shell,dummy);
	  fprintf(stderr,"display_string = %s\n",display_string);
	  tree(shell,0);
/*
	  tree(save_dialog,0);
*/
	  XtManageChild(print_lists_but);
	  }

/* Define a busy window to be managed when processing is taking place */

     /* Ignore device events while the busy cursor is displayed. */

	mask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
		ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(XtDisplay(shell), XC_watch);

	busy_win = XCreateWindow(dpy, top_window, 0, 0,
		DisplayWidth(dpy,screen_number),
		DisplayHeight(dpy,screen_number),
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);

	XtAddEventHandler(list_form,StructureNotifyMask,FALSE,
		c_label,(XtPointer) apply_but);

/* 	We use the re-sorting subroutine to do our initial list. 
	This enables the user to set initial sort options in the 
	resources file
*/
	set_the_options((Widget) NULL,(char *)display_dialog,(char *) NULL);
/*	sort_list(shell,NULL,NULL); */
	XtCallCallbacks(list1_text_label,XmNactivateCallback,NULL);

	delete_atom = XmInternAtom( XtDisplay(shell),"WM_DELETE_WINDOW",False);
	if ( delete_atom != (Atom) None ) {
	  XmAddWMProtocols(shell,&delete_atom, 1);
/*
          XmAddWMProtocolCallback(shell,delete_atom,pd_activate,
		(XtPointer) mode_but);
*/
          XmAddWMProtocolCallback(shell, delete_atom, wm_exit,
		(XtPointer) quit);
	  }

	/* Wait for i/o and dispatch. */
	
	while (TRUE) {
	  XtAppNextEvent(app_con,&event);
	  if (debug_mode >= 3)
	  fprintf(stderr,
	    "main: event type = %s  window = %8x  verified = %d\n",
	      event_names[event.type],event.xany.window,dsn_verified);
	  XtDispatchEvent(&event);
	  }

/*
	XtMainLoop();
*/
}
