/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>

#include "HelpObject.h"
#include "dskutil_glob.h"

Boolean get_file_info(filename,file_stat)
char *filename;
struct stat *file_stat;
{
	Boolean status;
  if (debug_mode >= 2) fprintf(stderr,"-> get_file_info <-\n");
	status = stat(filename,file_stat);
	if (status)  {
	  char *tag = "Unable to determine status of ";
	  char *msg = (char *)
		XtMalloc((strlen(tag)+strlen(filename)+1)*sizeof(char));
	  strcpy(msg,tag);
	  strcat(msg,filename);
	  post_message(TRUE,shell,msg,XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtPointer) XuHelper, (XtPointer) "No_Stat.help");
	  XtFree(msg);
	  return(FALSE);
	  }
	return(TRUE);
}
void cant_process(filename)
char *filename;
{
	char *tag = "Unable to process file ";
	char *msg = (char *)
		XtMalloc((strlen(tag)+strlen(filename)+1)*sizeof(char));
  if (debug_mode >= 2) fprintf(stderr,"-> cant_process <-\n");
	strcpy(msg,tag);
	strcat(msg,filename);
	post_message(TRUE,shell,msg,XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtPointer) XuHelper, (XtPointer) "Bypass.help");
	XtFree(msg);
}
void skip_dir(filename)
char *filename;
{
	char *tag = " is a directory;\nbypass processing";
	char *msg = (char *)
		XtMalloc((strlen(tag)+strlen(filename)+1)*sizeof(char));
	strcpy(msg,filename);
	strcat(msg,tag);
	post_message(TRUE,shell,msg,XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtPointer) XuHelper, (XtPointer) "Bypass.help");
/*
	fprintf(stderr,"skip_dir: widget = %08x\n",dialog);
*/
	XtFree(msg);
}
void dir_not_allowed(filename)
char *filename;
{
	char *tag = " is a directory;\ninvalid for selected mode";
	char *msg = (char *)
		XtMalloc((strlen(tag)+strlen(filename)+1)*sizeof(char));
	strcpy(msg,filename);
	strcat(msg,tag);
	post_message(TRUE,shell,msg,XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	XtFree(msg);
}

Boolean check_dir_stat(dir)
char *dir;
{
	struct stat file_stat;
  if (debug_mode >= 2) fprintf(stderr,"-> check_dir_stat <-\n");
	if( get_file_info(dir,&file_stat)) {
/*	  if ((file_stat.st_mode & S_IFDIR ) == 0) { */
	  if ((file_stat.st_mode & S_IFMT) != S_IFDIR ) {
	    post_message(FALSE,shell,
		"Specified name is not a directory",XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	    return(FALSE);
	    }
	  return(TRUE);
	  }
	return(FALSE);
}

