/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*ARGSUSED*/			/* this is a pacifier for Saber-C */
#include <stdio.h>
#include <localsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>

#include "dskutil_defs.h"
#include "dskutil_glob.h"
#include "tape_menu.h"
#include "HelpObject.h"
 
Widget dos_format,dos_label_text,dos_label,eject,force,density,verify; 

void fd_eject(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	system("eject");
}

void format_floppy(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	char *command = NULL;
	int cmd_length = 0;
	int status;
  if (debug_mode >= 2) fprintf(stderr,"-> format_floppy <-\n");

	XMapRaised(XtDisplay(widget),busy_win);
	XmUpdateDisplay(widget);

	bld_cmd_line(&command,&cmd_length,
	  "xcat -am -C Dskutil -busy -tr -title 'formatting disk'");
	bld_cmd_line(&command,&cmd_length," -e fdformat -f");
	if (XmToggleButtonGetState(dos_format)) 
	  bld_cmd_line(&command,&cmd_length,"-d");
	if (XmToggleButtonGetState(dos_label)) {
	  bld_cmd_line(&command,&cmd_length,"-b");
	  bld_cmd_line(&command,&cmd_length,XmTextGetString(dos_label_text));
	  }
	if (XmToggleButtonGetState(eject)) 
	  bld_cmd_line(&command,&cmd_length,"-e");
	if (XmToggleButtonGetState(density)) 
	  bld_cmd_line(&command,&cmd_length,"-l");
	if (XmToggleButtonGetState(verify)) 
	  bld_cmd_line(&command,&cmd_length,"-v");

	if (debug_mode)
	  fprintf(stderr,"%s\n",command);
	else
	  status = system(command);

	if (status != 0) post_message(TRUE,widget,
                "Formatting failed",
                XmDIALOG_ERROR,
                TRUE,NULL,NULL,NULL,
                FALSE,NULL,NULL,NULL,
                FALSE,NULL,NULL,NULL);
	else {
	  XtUnmanageChild((Widget) client_data);
	  }

	XUnmapWindow(XtDisplay(widget),busy_win);
	free(command);

}

void dos_toggle(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XtVaSetValues((Widget)client_data,
			XmNsensitive, XmToggleButtonGetState(widget),
			NULL);
}
void dos_label_toggle(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	if ( XmToggleButtonGetState(widget)) {
	  XtManageChild((Widget) client_data);
	  set_dialog_focus(widget,client_data,NULL);
	  }
	else
	  XtUnmanageChild((Widget) client_data);
}

void floppy_menu(trigger)
Widget trigger;
{
	Widget floppy_form,options_rc;
	Widget separator,ok,cancel,help;
	Dimension width;
	XmString item_label;
	String machine_name,blocksize,orig_tar_device;
	callback_info *info;
	void pop_the_dialog(),dismiss_dialog();
	void chg_toggle_label(),set_dialog_focus();
	void tree();

  if (debug_mode >= 2) fprintf(stderr,"-> floppy_menu <-\n");

	item_label = XmStringCreateLtoR("Formatting Options",
		XmSTRING_DEFAULT_CHARSET);
	nargs =0;
	XtSetArg(Xarg[nargs], XmNautoUnmanage,	FALSE);		nargs++;
	XtSetArg(Xarg[nargs], XmNdialogTitle, 	item_label);	nargs++;
	XtSetArg(Xarg[nargs], XmNmappedWhenManaged,	TRUE);	nargs++;
	XtSetArg(Xarg[nargs], XmNallowShellResize,	TRUE);	nargs++;
	XtSetArg(Xarg[nargs], XmNresizable,		TRUE);	nargs++;
	floppy_form = XmCreateFormDialog(trigger,"floppy_menu",Xarg,nargs);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("OK",XmSTRING_DEFAULT_CHARSET);
	ok = XtVaCreateManagedWidget("floppy_ok",
		xmPushButtonWidgetClass,floppy_form,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNlabelString,		item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("Cancel",XmSTRING_DEFAULT_CHARSET);
	cancel = XtVaCreateManagedWidget("floppy_cancel",
		xmPushButtonWidgetClass,floppy_form,
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		ok,
			XmNtopOffset,		0,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	ok,
			XmNbottomOffset,	0,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			XmNlabelString,		item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("Help",XmSTRING_DEFAULT_CHARSET);
	help = XtVaCreateManagedWidget("floppy_help",
		xmPushButtonWidgetClass,floppy_form,
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		ok,
			XmNtopOffset,		0,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	ok,
			XmNbottomOffset,	0,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			XmNlabelString,		item_label,
			NULL);
	XmStringFree(item_label);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,floppy_form,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	ok,
			NULL);
			
	options_rc = XtVaCreateManagedWidget("floppy_options",
		xmRowColumnWidgetClass,floppy_form,
			XmNresizable,TRUE,
			XmNresizePolicy, XmRESIZE_GROW,
			XmNx, 0,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			NULL);

	item_label = XmStringCreateLtoR("DOS Format",XmSTRING_DEFAULT_CHARSET);
	dos_format = XtVaCreateManagedWidget("dos_format",
		xmToggleButtonWidgetClass,options_rc,
			XmNlabelString,	item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("DOS Label",XmSTRING_DEFAULT_CHARSET);
	dos_label = XtVaCreateManagedWidget("dos_label",
		xmToggleButtonWidgetClass,options_rc,
			XmNlabelString,	item_label,
			XmNsensitive, XmToggleButtonGetState(dos_format),
			NULL);
	XmStringFree(item_label);

	dos_label_text = XtVaCreateWidget("dos_label_text",
		xmTextWidgetClass,options_rc,
			NULL);

	XtAddCallback(dos_format, XmNvalueChangedCallback,
		dos_toggle, (XtPointer) dos_label);

	item_label = XmStringCreateLtoR("eject when finished",
		XmSTRING_DEFAULT_CHARSET);
	eject = XtVaCreateManagedWidget("floppy_eject",
		xmToggleButtonWidgetClass,options_rc,
			XmNlabelString,	item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("low density",XmSTRING_DEFAULT_CHARSET);
	density = XtVaCreateManagedWidget("density",
		xmToggleButtonWidgetClass,options_rc,
			XmNlabelString,	item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("verify",XmSTRING_DEFAULT_CHARSET);
	verify = XtVaCreateManagedWidget("verify",
		xmToggleButtonWidgetClass,options_rc,
			XmNlabelString,	item_label,
			NULL);
	XmStringFree(item_label);

	XtAddCallback(dos_label, XmNvalueChangedCallback,
		dos_label_toggle, dos_label_text);

	XtAddCallback(ok, XmNactivateCallback, format_floppy,
		(XtPointer) floppy_form);

	XtAddCallback(cancel, XmNactivateCallback, dismiss_dialog,
		(XtPointer) floppy_form);

	XtAddCallback(trigger, XmNhelpCallback, XuHelper,
		(XtPointer) "FmtFloppy.help");

	XtAddCallback(help, XmNactivateCallback, XuHelper,
		(XtPointer) "FmtFloppy.help");

	XtAddCallback(trigger, XmNactivateCallback, pop_the_dialog,
		(XtPointer) floppy_form);

	XtAddCallback(floppy_form, XmNmapCallback, set_dialog_focus,
		(XtPointer) options_rc);

        if (debug_mode >= 1) tree(floppy_form,0);
}
