/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>

Window GetVRoot(dpy, scr)
Display        *dpy;
int             scr;
{
Window          rootReturn, parentReturn, *children;
unsigned int    numChildren;
Window          root = RootWindow(dpy, scr);
Atom            __SWM_VROOT = None;
int             i;

  __SWM_VROOT = XInternAtom(dpy, "__SWM_VROOT", False);
  XQueryTree(dpy, root, &rootReturn, &parentReturn, &children, &numChildren);
  for (i = 0; i < numChildren; i++) {
	Atom            actual_type;
	int             actual_format;
	unsigned long   nitems, bytesafter;
	Window         *newRoot = NULL;

	if (XGetWindowProperty(dpy, children[i], __SWM_VROOT, 0, 1,
	    False, XA_WINDOW, &actual_type, &actual_format, &nitems,
            &bytesafter, (unsigned char **) &newRoot) == Success && newRoot) {
			root = *newRoot;
			break;
		}
	}

	return root;
}
