/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "dskutil_defs.h"
#include "dskutil_glob.h"

#ifndef MAXPATHLEN		/* if it isn't system defined, we'll define it */
#define MAXPATHLEN 1024
#endif

Boolean parse_tar_files(cmd,cmd_length,processed_list,num_processed_items)
file_list_item **processed_list;
int *num_processed_items,*cmd_length;
char **cmd;
{
	char *tar_cmd = NULL;
	char *list_line;
	int i,j;
	Boolean bld_cmd_line();
	char *get_suffix();
	if (debug_mode >= 2) fprintf(stderr,"-> parse_tar_files <-\n");

	if (arch_parms[archival_mode].full_path_names) {
	  if (debug_mode >= 2) fprintf(stderr," Use the full path names\n");
	  for (j=0; j<*num_processed_items; j++) {
	    if (!bld_cmd_line(cmd,cmd_length,(*(processed_list+j))->name)) {
	      *num_processed_items = j;
	      return(FALSE);
	      }
	    }
	  }
	else {
	  if (debug_mode >= 2) fprintf(stderr," Use relative path names\n");
	  tar_cmd = (char *) malloc((MAXPATHLEN+4)*sizeof(char));
	  for (j=0; j<*num_processed_items; j++) {
	    list_line = (char *)((*(processed_list+j))->name);
#ifndef CRAYSYSTEM
/*
	    if ((archival_mode == TAR_ARCHIVAL_TAPE) || 
		(archival_mode == TAR_ARCHIVAL_FILE) ||
		(archival_mode == TAR_REMOTE_DEVICE)) {
*/

	      strcpy(tar_cmd,"-C ");
	      strcat(tar_cmd,list_line);
	      for (i=strlen(tar_cmd); i>=0; i--) {
	        if (strncmp((char *)(tar_cmd+i),"/",1) == 0) {
	          strncpy(tar_cmd+i," ",1);
	          if (!bld_cmd_line(cmd,cmd_length,tar_cmd)) {
	  	    *num_processed_items = j;
		    XtFree(tar_cmd);
		    return(FALSE);
		    }
	          break;
	          }
	        }
#else
/*
	      }
	    else {
*/
/*
	For Cray system archives, don't use the -C option, we can only
	write files from a single base directory.
*/
	      if (!bld_cmd_line(cmd,cmd_length,get_suffix(list_line,"/"))) {
	  	*num_processed_items = j;
		XtFree(tar_cmd);
		return(FALSE);
		}
#endif
/*
	      }
*/
	    }
	  XtFree(tar_cmd);
	  }
	return(TRUE);
}
