/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _TapeMenu_h
#define _TapeMenu_h

typedef struct {
  int menu_format;
  Widget *widgets;
  } callback_info ;

typedef struct {
  char *machine_name;
  char *transfer_blocksize;
  char *transfer_blocksize_option;
  char *dataset_name;
  char *device_blocksize;
  char *device_blocksize_option;
  char *expiration_date;
  char *max_no_of_tapes;
  char *record_format;
  Boolean full_path_names;
  Boolean remove_archive_files;
  callback_info *menu_info;
  char *help_file;
} tape_parameters;

typedef struct {
  FILE *verify_cmd;
  tape_parameters *archive_info;
  } verify_info ;

/* I keep a structure of widget values for all of the various 
   archival method popup menus. I use this enum to make additions
   simpler. There is a small amount of wasted malloced space
   for those menu which have fewer options, but the cost is worth
   the simplicity. The common structure allows us to share callbacks
   among all these menus.
*/

enum archive_menu_constants {
	TRIGGER_WIDGET,
	DIALOG_WIDGET,
	MACHINE_NAME,
	TRANSFER_BLOCKSIZE,
	TRANSFER_BLOCKSIZE_OPTION,
	TRANSFER_BLOCKSIZE_HISTORY,
	DATASET_TEXT,
	DEVICE_BLOCKSIZE,
	DEVICE_BLOCKSIZE_OPTION,
	DEVICE_BLOCKSIZE_HISTORY,
	EXPDT_TEXT,
	TAPE_LIM_TEXT,
	RECFM_TEXT,
	FULL_PATH_TOGGLE,
	REMOVAL_TOGGLE,
	APPLY_BUTTON,
	CANCEL_BUTTON,
	MENU_WIDGET_MAX } /* archive_menu_constants */ ;

#endif	/* _TapeMenu_h */
