C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pwt ( data, n, isign, cc, cr, ioff, joff, ncof )

c the array work[] in the wtn subroutine becomes the array data[] here.
c the array work[] here is not the same array, but merely workspace in
c this routine.

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from main

      integer n, isign, ioff, joff, ncof

      real data(*), cc(SZLNHD), cr(SZLNHD)

c local variables

      integer i, ii, jf, jr, k, n1, ni, nj, nh, nmod

      real  ai, ai1, work(SZLNHD)

c initialize variables

      call vclr(work,1,SZLNHD)

      if ( n .lt. 4 ) return

      nmod = ncof * n
      n1 = n - 1
      nh = n / 2
      
      if ( isign .ge. 0 ) then

c apply filter

         ii = 1
         do i = 1, n, 2

c pointer to be incremented and wrapped around

            ni = i + nmod + ioff
            nj = i + nmod + joff

            do k = 1, ncof

c use bitwise and to wraparound the pointers

               jf = iand(n1, ni + k)
               jr = iand(n1, nj + k)
               work(ii) = work(ii) + cc(k) * data(jf + 1)
               work(ii + nh) = work(ii + nh) + cr(k) * data(jr + 1)
            enddo

            ii = ii + 1
         enddo

      else

c apply transpose filter

         ii = 1

         do i = 1, n, 2

c pointer to be incremented and wrapped around

            ai = data(ii)
            ai1 = data(ii + nh)
            ni = i + nmod + ioff
            nj = i + nmod + joff

            do k = 1, ncof

c use bitwise and to wraparound the pointers

               jf = iand(n1, ni + k) + 1
               jr = iand(n1, nj + k) + 1
               work(jf) = work(jf) + cc(k) * ai
               work(jr) = work(jr) + cr(k) * ai1
            enddo

            ii = ii + 1
         enddo
      endif

c copy results back from workspace

      call vmov(work, 1, data, 1, n)

      return
      end
