C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pwtset ( NumCoefs, cc, cr, ioff, joff, peak ) 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from main

      integer NumCoefs, ioff, joff
      
      real    cc(SZLNHD), cr(SZLNHD)

      logical peak

c local variables

      integer k

      real sig, Daubechie4(4), Daubechie12(12), Daubechie20(20)
      real Meyer(39), Battle_Lemarie1(14), Battle_Lemarie3(24)
      real Battle_Lemarie5(29)

c initialize wavelets      

      data Daubechie4/0.4829629131445341, 0.8365163037378079, 
     :     0.2241438680420134,-0.1294095225512604/

      data Daubechie12/0.111540743350, 0.494623890398, 0.751133908021,
     :     0.315250351709, -0.226264693965, -0.129766867567,
     :     0.097501605587,  0.027522865530, -0.031582039318,
     :     0.000553842201,  0.004777257511, -0.001077301085/

      data Daubechie20/0.026670057901, 0.188176800078, 0.527201188932,
     :      0.688459039454,  0.281172343661, -0.249846424327,
     :     -0.195946274377,  0.127369340336,  0.093057364604,
     :     -0.071394147166, -0.029457536822,  0.033212674059,
     :      0.003606553567, -0.010733175483,  0.001395351747,
     :      0.001992405295, -0.000685856695, -0.000116466855,
     :      0.000093588670, -0.000013264203/

c Battle_Lemarie1 --> 1st orderfrom Cohen at CSM
c cummulative sum is 1.00002

      data Battle_Lemarie1/1.15633, 0.561863, -0.0977235,
     :     -0.0734618, 0.0240007, 0.0141288, -0.00549176 ,
     :     -0.00311403, 0.00130584, 0.000723563, -0.000317203,
     :     -0.000173505, 0.0000782857, 0.0000424422/

c Battle_Lemarie3 --> 3rd orderfrom Cohen at CSM
c cummulative sum is 0.999935

      data Battle_Lemarie3/1.08347, 0.613659, -0.070996, -0.155616,
     :     0.0453692, 0.0594936, -0.024291, -0.0254308, 0.0122829,
     :     0.0115986, -0.00615726, -0.00549058, 0.00309248,
     :     0.00266174, -0.00156092, -0.00131126, 0.00079187, 
     :     0.00065353, -0.000403594, -0.000328589, 0.000206534,
     :     0.000166351, -0.000106064, -0.0000846822/

c Battle_Lemarie5 --> 5th orderfrom Cohen at CSM
c cummulative sum is 0.999963

      data Battle_Lemarie5/1.05675, 0.625737, -0.0523542, -0.182814,
     :     0.0416828, 0.0867089, -0.0297073, -0.0459902, 0.0198127,
     :     0.0257508, -0.0127977, -0.014937, 0.00815765, 0.00888004,
     :     -0.00517632, -0.00537292, 0.00328264, 0.00329318, 
     :     -0.00208414, -0.00203825, 0.00132567, 0.00127113,
     :     -0.00084497, -0.000797519, 0.000539684, 0.000502837,
     :     -0.00034537, -0.000318335, 0.000221419/


c Meyer from  Cohen at CSM
c listed as c[]/2 so may have to multiply by 2 on application

      data Meyer/0.516838, 0.316478, -0.0164997, -0.10073, 0.0155232, 
     :     0.055095, -0.0140178, -0.0342401, 0.0121439, 
     :     0.0221083, -0.010086, -0.0143256, 0.00802405, 
     :     0.00916062, -0.00610887, -0.0057323, 0.00444608, 
     :     0.00349957, -0.00309065, -0.00208857, 0.00205092, 
     :     0.00122774, -0.00129965, -0.000720319, 0.000788058, 
     :     0.000428782, -0.000459496, -0.000262368, 0.000260026, 
     :     0.000165292, -0.000144889, -0.000105901, 
     :     0.0000809309, 0.0000675985, -0.0000460132, 
     :     -0.0000421409, 0.0000267451, 0.0000253135, 
     :     -0.0000157453/

      sig = -1.

c load wavelet coefficients of choice

      do k=1,NumCoefs

         if ( NumCoefs .eq. 4 ) then
            cc(k) = Daubechie4(k)
         elseif ( NumCoefs .eq. 12 ) then
            cc(k) = Daubechie12(k)
         elseif ( NumCoefs .eq. 14 ) then
            cc(k) = Battle_Lemarie1(k)
         elseif ( NumCoefs .eq. 20 ) then
            cc(k) = Daubechie20(k)
         elseif ( NumCoefs .eq. 24 ) then
            cc(k) = Battle_Lemarie3(k)
         elseif ( NumCoefs .eq. 29 ) then
            cc(k) = Battle_Lemarie5(k)
         elseif ( NumCoefs .eq. 39 ) then
            cc(k) = Meyer(k)
         else
            write(LERR,*)'DWT2D: Wavelet choice ',NumCoefs,' not '
            write(LERR,*)'       available.  Check parameters and'
            write(LERR,*)'       rerun'
            write(LERR,*)'FATAL'
            write(LER,*)'DWT2D: Wavelet choice ',NumCoefs,' not '
            write(LER,*)'       available.  Check parameters and'
            write(LER,*)'       rerun'
            write(LER,*)'FATAL'
            stop
         endif

         cr( NumCoefs + 1 - k ) = sig * cc(k)
         sig = -sig

      enddo

c the following values center the "support" of the wavelets at each 
c level.  Alternatively, the "peaks" of the wavelets can be approximately
c centered by the choices:
c

      if ( peak ) then

c center peak of wavelet at each level
  
         ioff = -2
         joff = -NumCoefs + 2

      else

c center support of wavlet at each level

         ioff =  -NumCoefs / 2
         joff =  -NumCoefs / 2

      endif

      return
      end

