C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(tracebuf,ibuffer,trheader,
     1                    uin,live,luin,nx,eof,
     2                    mx,ITRWRD,mt,nt,lerr,
     3                    kstart,kend,cputim,waltim,nxpad,
     4                    l_StaCor,ifmt_StaCor,ln_StaCor)
c
      integer   trheader(ITRWRD,0:nx)
      integer   ibuffer(*)
      real      tracebuf(-ITRWRD:nt)
      real      uin(-mt:nt+mt,-mx:nx+mx)   
      real      cputim(*),waltim(*)
      logical   live(-mx:nx+mx)
      logical   eof
c
      eof=.false.
      call timstr(v1,w1)
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the first (-mx,-1) traces of the seismic record.
c_______________________________________________________________________
         do 13000 jx=-nxpad,-1
          nbytes_in=0
          call rtape(luin,tracebuf(-ITRWRD),nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .ge. -mx) then
             call saver2(ibuffer,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istat, 1)
             if(istat .eq. 30000) then
                live(jx)=.false.
                call vclr(uin(0,jx),1,nt+1)
             else
                live(jx)=.true.
                do 12000 k=0,nt
                 uin(k,jx)=tracebuf(k)
12000           continue
             endif
          endif
13000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 14000 jx=-mx,-1
          live(jx)=.false. 
          call vclr(uin(0,jx),1,nt+1)
14000    continue
      endif
c_______________________________________________________________________
c     read in the next (0,nx) traces of the seismic record.
c_______________________________________________________________________
      do 40000 jx=0,nx       
       nbytes_in=0
       call rtape(luin,tracebuf(-ITRWRD),nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          return
       endif
c_______________________________________________________________________
c      copy trace headers into trheader array.
c      copy data into uin.                   
c_______________________________________________________________________
       do 35000 k=1,ITRWRD
        trheader(k,jx)=ibuffer(k)
35000  continue
       call saver2(trheader(1,jx),ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istat, 1)
       if(istat .eq. 30000) then
          live(jx)=.false.
          call vclr(uin(0,jx),1,nt+1)
       else
          live(jx)=.true.    
          do 37000 k=0,nt
           uin(k,jx)=tracebuf(k)
37000     continue
       endif
40000 continue
70000 continue
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the last (nx+1,nx+mx) traces of the seismic record.
c_______________________________________________________________________
         do 83000 jx=nx+1,nx+nxpad
          nbytes_in=0
          call rtape(luin,tracebuf(-ITRWRD),nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .le. nx+mx) then
             call saver2(ibuffer,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istat, 1)
             if(istat .eq. 30000) then
                live(jx)=.false.
                call vclr(uin(0,jx),1,nt+1)
             else
                live(jx)=.true.
                do 82000 k=0,nt
                 uin(k,jx)=tracebuf(k)
82000           continue
             endif
          endif
83000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 84000 jx=nx+1,nx+mx
          live(jx)=.false.
          call vclr(uin(0,jx),1,nt+1)
84000    continue
      endif
c___________________________________________________________________
c     replicate samples above and below the data limits.
c__________________________________________________________________
      do 86000 jx=-mx,nx+mx
       do 85000 jt=1,mt
        uin(0-jt,jx)=uin(0,jx)
        uin(nt+jt,jx)=uin(nt,jx)
85000  continue
86000 continue
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
c
      return
      end 
