C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, irs, ire, ns, ne, ist, iend, 
     :     Xzero, deltaX, Xmax, Type, HdrWrd, num_mnemonics,
     :     mirror, num_mirror_inside, num_mirror_outside, 
     :     dead, name, distap, verbos )

      implicit none

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer    ist, iend, irs, ire, ns, ne, num_mnemonics
      integer    num_mirror_inside, num_mirror_outside

      real       Xzero, deltaX, Xmax

      character  ntap*(*), otap*(*), name*(*), Type*(*), distap*(*)
      character*6  HdrWrd(SZLNHD)

      logical    mirror, dead, verbos

c declare local variables


      integer ntrco, argis

      logical done

      dead = (argis('-dead') .gt. 0)
      call argr4 ( '-dx', deltaX, 25., 25. )
      call argstr ( '-D', distap, ' ', ' ' ) 

      call argi4 ( '-e', iend, 0, 0 )

      call argi4 ( '-in', num_mirror_inside, 0, 0 )

      mirror = (argis('-mirror') .gt. 0)

      call argstr ( '-N', ntap, ' ', ' ' ) 
      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argi4 ( '-ntr', ntrco, 0, 0 )

      call argstr ( '-O', otap, ' ', ' ' ) 
      call argi4 ( '-out', num_mirror_outside, 0, 0 )

      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      call argi4 ( '-s', ist, 1, 1 )

      if ( argis('-linear') .gt. 0) then
         Type = 'linear'
      elseif ( argis('-fft') .gt. 0) then
         Type = 'FFT'
      else
         Type = 'spline'
      endif

      verbos = (argis('-V') .gt. 0)

      call argr4 ( '-xmax', Xmax, 0., 0. )
      call argr4 ( '-x0', Xzero, 0., 0. )

      num_mnemonics = 0
      done = .false.

      do while ( .not. done )
         num_mnemonics = num_mnemonics + 1

         call argstr ( '-hw', HdrWrd(num_mnemonics), ' ', ' ' ) 
         if ( HdrWrd(num_mnemonics) .eq. ' ' ) then
            done = .true.
            num_mnemonics = num_mnemonics - 1
         endif
      enddo

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

c Policemen
      
c make sure a -dx appears on the command line

      if ( abs(deltaX) .lt. 1.e-32 .and. .not. dead) then
         write(LER,*)' '
         write(LER,*)'EQUALDX:'
         write(LER,*)' This routine requires a -dx entry on the'
         write(LER,*)' command line.  Please choose a trace '
         write(LER,*)' spacing and resubmit'
         write(LER,*)'FATAL'
         write(LERR,*)' '
         write(LERR,*)'EQUALDX:'
         write(LERR,*)'EQUALDX:'
         write(LERR,*)' This routine requires a -dx entry on the'
         write(LERR,*)' command line.  Please choose a trace '
         write(LERR,*)' spacing and resubmit'
         write(LERR,*)'FATAL'
         close(LERR)
         write(LER,*)' '
         write(LER,*)' '
         write(LER,*)' equaldx: Abnormal Termination'
         write(LER,*)' '
         stop
      endif

c make sure that one of -ntr or -xmax appears on the command line

      if ( ntrco .eq. 0 .and. abs(Xmax - Xzero) .lt. 1.e-32 .and.
     :     .not. dead .and. distap .eq. ' ') then
         write(LER,*)' '
         write(LER,*)'EQUALDX:'
         write(LER,*)' This routine requires one of -ntr or -xmax'
         write(LER,*)' in order to determine the number of output'
         write(LER,*)' traces per record.  Supply one or the other'
         write(LER,*)' on the command line and resubmit'
         write(LER,*)'FATAL'
         write(LERR,*)' '
         write(LERR,*)'EQUALDX:'
         write(LERR,*)' This routine requires one of -ntr or -xmax'
         write(LERR,*)' in order to determine the number of output'
         write(LERR,*)' traces per record.  Supply one or the other'
         write(LERR,*)' on the command line and resubmit'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         close(LERR)
         write(LER,*)' '
         write(LER,*)' equaldx: Abnormal Termination'
         write(LER,*)' '
         stop
      elseif ( ntrco .ne. 0 ) then

c reset Xmax to use -ntr as the -ntr entry overrides the -xmax entry
c it is also expected that the deltaX is a signed entry so if you want
c a negative Xmax and are using -ntr the issue a negative deltaX

         Xmax = Xzero + float ( ntrco - 1 ) * deltaX
      endif

c make sure that the sign of deltaX is correct for the relationship
c between Xzero and Xmax

      if (  Xzero .gt. Xmax ) then
         if ( deltaX .ge. 0. ) then
            write(LERR,*)' '
            write(LERR,*)' Check the sign on your -dx entry'
            write(LERR,*)' To go from a -x0 of ',Xzero, ' to an '
            write(LERR,*)' -xmax of ',Xmax,' You require a negative'
            write(LERR,*)' value for -dx.  Your entry is ',deltaX
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'EQUALDX:'
            write(LER,*)' Check the sign on your -dx entry'
            write(LER,*)' To go from a -x0 of ',Xzero, ' to an '
            write(LER,*)' -xmax of ',Xmax,' You require a negative'
            write(LER,*)' value for -dx.  Your entry is ',deltaX
            write(LER,*)'FATAL'
            close(LERR)
            stop
         endif
      elseif ( Xmax .gt. Xzero ) then
         if ( deltaX .le. 0. ) then
            write(LERR,*)' '
            write(LERR,*)' Check the sign on your -dx entry'
            write(LERR,*)' To go from a -x0 of ',Xzero, ' to an '
            write(LERR,*)' -xmax of ',Xmax,' You require a positive'
            write(LERR,*)' value for -dx.  Your entry is ',deltaX
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'EQUALDX:'
            write(LER,*)' Check the sign on your -dx entry'
            write(LER,*)' To go from a -x0 of ',Xzero, ' to an '
            write(LER,*)' -xmax of ',Xmax,' You require a positive'
            write(LER,*)' value for -dx.  Your entry is ',deltaX
            write(LER,*)'FATAL'
            close(LERR)
            stop
         endif
      endif

      return
      end
